/*
 * Decompiled with CFR 0.152.
 */
package top.r3944realms.superleadrope.content.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import top.r3944realms.superleadrope.CommonEventHandler;
import top.r3944realms.superleadrope.content.capability.inter.ILeashData;
import top.r3944realms.superleadrope.content.command.Command;
import top.r3944realms.superleadrope.content.entity.SuperLeashKnotEntity;
import top.r3944realms.superleadrope.content.gamerule.server.CreateSuperLeashKnotEntityIfAbsent;
import top.r3944realms.superleadrope.core.register.SLPGameruleRegistry;
import top.r3944realms.superleadrope.util.capability.LeashDataAPI;

public class LeashDataCommand {
    public static final String SLP_LEASH_MESSAGE_ = "superleadrope.command.leash.message.";
    public static final String LEASH_DATA_GET_ = "superleadrope.command.leash.message..get.";
    public static final String TITLE = "superleadrope.command.leash.message..get.title";
    public static final String TOTAL = "superleadrope.command.leash.message..get.total";
    public static final String BLOCK = "superleadrope.command.leash.message..get.block";
    public static final String UUID = "superleadrope.command.leash.message..get.uuid";
    public static final String MAX = "superleadrope.command.leash.message..get.max";
    public static final String ELASTIC = "superleadrope.command.leash.message..get.elastic";
    public static final String KEEP = "superleadrope.command.leash.message..get.keep";
    public static final String RESERVED = "superleadrope.command.leash.message..get.reserved";
    public static final String SET_MAX_DISTANCE = "superleadrope.command.leash.message.setApplyEntity.max_distance";
    public static final String REMOVE_ALL_BLOCK_LEASHES = "superleadrope.command.leash.message.removeApplyEntity.all_block_leashes";
    public static final String REMOVE_ALL_HOLDER_LEASHES = "superleadrope.command.leash.message.removeApplyEntity.all_holder_leashes";
    public static final String TRANSFER_FROM_BLOCK = "superleadrope.command.leash.message.transfer.from_block";
    public static final String SET_ELASTIC_DISTANCE = "superleadrope.command.leash.message.setApplyEntity.elastic_distance";
    public static final String SET_BLOCK_MAX_DISTANCE = "superleadrope.command.leash.message.setApplyEntity.block_max_distance";
    public static final String SET_BLOCK_ELASTIC_DISTANCE = "superleadrope.command.leash.message.setApplyEntity.block_elastic_distance";

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        @Nullable ArrayList<LiteralArgumentBuilder<CommandSourceStack>> nodeList = Command.SHOULD_USE_PREFIX ? null : new ArrayList<LiteralArgumentBuilder<CommandSourceStack>>();
        LiteralArgumentBuilder literalArgumentBuilder = Commands.m_82127_((String)Command.PREFIX);
        LiteralArgumentBuilder<CommandSourceStack> $$leashDataRoot = Command.getLiterArgumentBuilderOfCSS("leashdata", !Command.SHOULD_USE_PREFIX, nodeList);
        RequiredArgumentBuilder $$$add$holder = (RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"holder", (ArgumentType)EntityArgument.m_91449_()).executes(LeashDataCommand::addLeash)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"maxDistance", (ArgumentType)DoubleArgumentType.doubleArg((double)1.0, (double)256.0)).executes(context -> LeashDataCommand.addLeash((CommandContext<CommandSourceStack>)context, DoubleArgumentType.getDouble((CommandContext)context, (String)"maxDistance")))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"elasticDistance", (ArgumentType)DoubleArgumentType.doubleArg((double)1.0, (double)128.0)).executes(context -> LeashDataCommand.addLeash((CommandContext<CommandSourceStack>)context, DoubleArgumentType.getDouble((CommandContext)context, (String)"maxDistance"), DoubleArgumentType.getDouble((CommandContext)context, (String)"elasticDistance")))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"keepTicks", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> LeashDataCommand.addLeash((CommandContext<CommandSourceStack>)context, DoubleArgumentType.getDouble((CommandContext)context, (String)"maxDistance"), DoubleArgumentType.getDouble((CommandContext)context, (String)"elasticDistance"), IntegerArgumentType.getInteger((CommandContext)context, (String)"keepTicks")))).then(Commands.m_82129_((String)"reserved", (ArgumentType)StringArgumentType.string()).executes(context -> LeashDataCommand.addLeash((CommandContext<CommandSourceStack>)context, DoubleArgumentType.getDouble((CommandContext)context, (String)"maxDistance"), DoubleArgumentType.getDouble((CommandContext)context, (String)"elasticDistance"), IntegerArgumentType.getInteger((CommandContext)context, (String)"keepTicks"), StringArgumentType.getString((CommandContext)context, (String)"reserved")))))));
        LiteralArgumentBuilder $$$add$pos = (LiteralArgumentBuilder)Commands.m_82127_((String)"block").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"pos", (ArgumentType)BlockPosArgument.m_118239_()).executes(LeashDataCommand::addBlockLeash)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"maxDistance", (ArgumentType)DoubleArgumentType.doubleArg((double)1.0, (double)256.0)).executes(context -> LeashDataCommand.addBlockLeash((CommandContext<CommandSourceStack>)context, DoubleArgumentType.getDouble((CommandContext)context, (String)"maxDistance")))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"elasticDistance", (ArgumentType)DoubleArgumentType.doubleArg((double)1.0, (double)128.0)).executes(context -> LeashDataCommand.addBlockLeash((CommandContext<CommandSourceStack>)context, DoubleArgumentType.getDouble((CommandContext)context, (String)"maxDistance"), DoubleArgumentType.getDouble((CommandContext)context, (String)"elasticDistance"), 0, ""))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"keepTicks", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> LeashDataCommand.addBlockLeash((CommandContext<CommandSourceStack>)context, DoubleArgumentType.getDouble((CommandContext)context, (String)"maxDistance"), DoubleArgumentType.getDouble((CommandContext)context, (String)"elasticDistance"), IntegerArgumentType.getInteger((CommandContext)context, (String)"keepTicks")))).then(Commands.m_82129_((String)"reserved", (ArgumentType)StringArgumentType.string()).executes(context -> LeashDataCommand.addBlockLeash((CommandContext<CommandSourceStack>)context, DoubleArgumentType.getDouble((CommandContext)context, (String)"maxDistance"), DoubleArgumentType.getDouble((CommandContext)context, (String)"elasticDistance"), IntegerArgumentType.getInteger((CommandContext)context, (String)"keepTicks"), StringArgumentType.getString((CommandContext)context, (String)"reserved"))))))));
        LiteralArgumentBuilder $$$add = (LiteralArgumentBuilder)Commands.m_82127_((String)"addApplyEntity").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91460_()).then((ArgumentBuilder)$$$add$holder)).then((ArgumentBuilder)$$$add$pos));
        LiteralArgumentBuilder $$$remove = (LiteralArgumentBuilder)Commands.m_82127_((String)"removeApplyEntity").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91460_()).then(Commands.m_82129_((String)"holder", (ArgumentType)EntityArgument.m_91449_()).executes(LeashDataCommand::removeLeash))).then(Commands.m_82127_((String)"block").then(Commands.m_82129_((String)"pos", (ArgumentType)BlockPosArgument.m_118239_()).executes(LeashDataCommand::removeBlockLeash)))).then(Commands.m_82127_((String)"all").executes(LeashDataCommand::removeAllLeashes))).then(Commands.m_82127_((String)"holders").executes(LeashDataCommand::removeAllHolderLeashes))).then(Commands.m_82127_((String)"blocks").executes(LeashDataCommand::removeAllBlockLeashes)));
        LiteralArgumentBuilder $$$transfer = (LiteralArgumentBuilder)Commands.m_82127_((String)"transfer").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91460_()).then(Commands.m_82129_((String)"from", (ArgumentType)EntityArgument.m_91449_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"to", (ArgumentType)EntityArgument.m_91449_()).executes(LeashDataCommand::transferLeash)).then(Commands.m_82129_((String)"reserved", (ArgumentType)StringArgumentType.string()).executes(context -> LeashDataCommand.transferLeash((CommandContext<CommandSourceStack>)context, StringArgumentType.getString((CommandContext)context, (String)"reserved"))))))).then(Commands.m_82127_((String)"fromBlock").then(Commands.m_82129_((String)"fromPos", (ArgumentType)BlockPosArgument.m_118239_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"to", (ArgumentType)EntityArgument.m_91449_()).executes(LeashDataCommand::transferFromBlock)).then(Commands.m_82129_((String)"reserved", (ArgumentType)StringArgumentType.string()).executes(context -> LeashDataCommand.transferFromBlock((CommandContext<CommandSourceStack>)context, StringArgumentType.getString((CommandContext)context, (String)"reserved"))))))));
        RequiredArgumentBuilder $$$set$holder = (RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"holder", (ArgumentType)EntityArgument.m_91449_()).then(Commands.m_82127_((String)"maxDistance").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"distance", (ArgumentType)DoubleArgumentType.doubleArg((double)1.0, (double)256.0)).executes(LeashDataCommand::setMaxDistance)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"keepTicks", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> LeashDataCommand.setMaxDistance((CommandContext<CommandSourceStack>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"keepTicks")))).then(Commands.m_82129_((String)"reserved", (ArgumentType)StringArgumentType.string()).executes(context -> LeashDataCommand.setMaxDistance((CommandContext<CommandSourceStack>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"keepTicks"), StringArgumentType.getString((CommandContext)context, (String)"reserved")))))))).then(Commands.m_82127_((String)"elasticDistance").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"distance", (ArgumentType)DoubleArgumentType.doubleArg((double)1.0, (double)128.0)).executes(context -> LeashDataCommand.setElasticDistance((CommandContext<CommandSourceStack>)context, 0, ""))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"keepTicks", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> LeashDataCommand.setElasticDistance((CommandContext<CommandSourceStack>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"keepTicks"), ""))).then(Commands.m_82129_((String)"reserved", (ArgumentType)StringArgumentType.string()).executes(context -> LeashDataCommand.setElasticDistance((CommandContext<CommandSourceStack>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"keepTicks"), StringArgumentType.getString((CommandContext)context, (String)"reserved")))))));
        LiteralArgumentBuilder $$$set$pos = (LiteralArgumentBuilder)Commands.m_82127_((String)"block").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"pos", (ArgumentType)BlockPosArgument.m_118239_()).then(Commands.m_82127_((String)"maxDistance").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"distance", (ArgumentType)DoubleArgumentType.doubleArg((double)1.0, (double)256.0)).executes(LeashDataCommand::setBlockMaxDistance)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"keepTicks", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> LeashDataCommand.setBlockMaxDistance((CommandContext<CommandSourceStack>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"keepTicks")))).then(Commands.m_82129_((String)"reserved", (ArgumentType)StringArgumentType.string()).executes(context -> LeashDataCommand.setBlockMaxDistance((CommandContext<CommandSourceStack>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"keepTicks"), StringArgumentType.getString((CommandContext)context, (String)"reserved")))))))).then(Commands.m_82127_((String)"elasticDistance").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"distance", (ArgumentType)DoubleArgumentType.doubleArg((double)1.0, (double)128.0)).executes(LeashDataCommand::setBlockElasticDistance)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"keepTicks", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> LeashDataCommand.setBlockElasticDistance((CommandContext<CommandSourceStack>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"keepTicks")))).then(Commands.m_82129_((String)"reserved", (ArgumentType)StringArgumentType.string()).executes(context -> LeashDataCommand.setBlockElasticDistance((CommandContext<CommandSourceStack>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"keepTicks"), StringArgumentType.getString((CommandContext)context, (String)"reserved"))))))));
        LiteralArgumentBuilder $$$set = (LiteralArgumentBuilder)Commands.m_82127_((String)"setApplyEntity").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91460_()).then((ArgumentBuilder)$$$set$holder)).then((ArgumentBuilder)$$$set$pos));
        LiteralArgumentBuilder $$$applayForces = (LiteralArgumentBuilder)Commands.m_82127_((String)"applyForces").then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91460_()).executes(LeashDataCommand::applyForces));
        LiteralArgumentBuilder $$$get = (LiteralArgumentBuilder)Commands.m_82127_((String)"get").then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91460_()).executes(LeashDataCommand::getLeashData));
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)$$leashDataRoot.requires(source -> source.m_6761_(2))).then((ArgumentBuilder)$$$get)).then((ArgumentBuilder)$$$add)).then((ArgumentBuilder)$$$remove)).then((ArgumentBuilder)$$$transfer)).then((ArgumentBuilder)$$$set)).then((ArgumentBuilder)$$$applayForces);
        if (Command.SHOULD_USE_PREFIX) {
            literalArgumentBuilder.then($$leashDataRoot);
            dispatcher.register(literalArgumentBuilder);
        } else if (nodeList != null) {
            nodeList.forEach(arg_0 -> dispatcher.register(arg_0));
        }
    }

    private static int setMaxDistance(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return LeashDataCommand.setMaxDistance(context, CommonEventHandler.leashConfigManager.getMaxLeashLength(), "");
    }

    private static int setMaxDistance(CommandContext<CommandSourceStack> context, double maxDistance) throws CommandSyntaxException {
        return LeashDataCommand.setMaxDistance(context, maxDistance, "");
    }

    private static int setMaxDistance(CommandContext<CommandSourceStack> context, double maxDistance, String reserved) throws CommandSyntaxException {
        Collection targets = EntityArgument.m_91461_(context, (String)"target");
        Entity holder = EntityArgument.m_91452_(context, (String)"holder");
        for (Entity entity : targets) {
        }
        return -1;
    }

    private static int removeAllBlockLeashes(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return -1;
    }

    private static int removeAllHolderLeashes(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return -1;
    }

    private static int transferFromBlock(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return LeashDataCommand.transferFromBlock(context, "");
    }

    private static int transferFromBlock(CommandContext<CommandSourceStack> context, String reserved) throws CommandSyntaxException {
        return -1;
    }

    private static int setElasticDistance(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return LeashDataCommand.setElasticDistance(context, 0, "");
    }

    private static int setElasticDistance(CommandContext<CommandSourceStack> context, int keepTicks) throws CommandSyntaxException {
        return LeashDataCommand.setElasticDistance(context, keepTicks, "");
    }

    private static int setElasticDistance(CommandContext<CommandSourceStack> context, int keepTicks, String reserved) throws CommandSyntaxException {
        return -1;
    }

    private static int setBlockMaxDistance(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return LeashDataCommand.setBlockMaxDistance(context, 0, "");
    }

    private static int setBlockMaxDistance(CommandContext<CommandSourceStack> context, int keepTicks) throws CommandSyntaxException {
        return LeashDataCommand.setBlockMaxDistance(context, keepTicks, "");
    }

    private static int setBlockMaxDistance(CommandContext<CommandSourceStack> context, int keepTicks, String reserved) throws CommandSyntaxException {
        return -1;
    }

    private static int setBlockElasticDistance(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return LeashDataCommand.setBlockElasticDistance(context, 0, "");
    }

    private static int setBlockElasticDistance(CommandContext<CommandSourceStack> context, int keepTicks) throws CommandSyntaxException {
        return LeashDataCommand.setBlockElasticDistance(context, keepTicks, "");
    }

    private static int setBlockElasticDistance(CommandContext<CommandSourceStack> context, int keepTicks, String reserved) throws CommandSyntaxException {
        return -1;
    }

    private static int getLeashData(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection targets = EntityArgument.m_91461_(context, (String)"target");
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        for (Entity target : targets) {
            Collection<ILeashData.LeashInfo> leashes = LeashDataAPI.QueryOperations.getAllLeashes(target);
            source.m_288197_(() -> Component.m_237113_((String)("=== Leash Data for " + target.m_7755_().getString() + " ===")), false);
            source.m_288197_(() -> Component.m_237113_((String)("Total leashes: " + leashes.size())), false);
            for (ILeashData.LeashInfo leash : leashes) {
                StringBuilder info = new StringBuilder();
                leash.blockPosOpt().ifPresent(pos -> info.append("Block: ").append(pos.m_123344_()).append(" "));
                leash.holderUUIDOpt().ifPresent(uuid -> info.append("UUID: ").append(uuid).append(" "));
                info.append("Max: ").append(leash.maxDistance()).append(" ");
                info.append("Elastic: ").append(leash.elasticDistance()).append(" ");
                info.append("Keep: ").append(leash.keepLeashTicks()).append("/").append(leash.maxKeepLeashTicks());
                if (!leash.reserved().isEmpty()) {
                    info.append(" Reserved: ").append(leash.reserved());
                }
                source.m_288197_(() -> Component.m_237113_((String)info.toString()), false);
            }
        }
        return targets.size();
    }

    private static int addLeash(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return LeashDataCommand.addLeash(context, CommonEventHandler.leashConfigManager.getMaxLeashLength(), CommonEventHandler.leashConfigManager.getElasticDistance(), 0, "");
    }

    private static int addLeash(CommandContext<CommandSourceStack> context, double maxDistance) throws CommandSyntaxException {
        return LeashDataCommand.addLeash(context, maxDistance, CommonEventHandler.leashConfigManager.getElasticDistance(), 0, "");
    }

    private static int addLeash(CommandContext<CommandSourceStack> context, double maxDistance, double elasticDistance) throws CommandSyntaxException {
        return LeashDataCommand.addLeash(context, maxDistance, elasticDistance, 0, "");
    }

    private static int addLeash(CommandContext<CommandSourceStack> context, double maxDistance, double elasticDistance, int keepTicks) throws CommandSyntaxException {
        return LeashDataCommand.addLeash(context, maxDistance, elasticDistance, keepTicks, "");
    }

    private static int addLeash(CommandContext<CommandSourceStack> context, double maxDistance, double elasticDistance, int keepTicks, String reserved) throws CommandSyntaxException {
        Collection targets = EntityArgument.m_91461_(context, (String)"target");
        Entity holder = EntityArgument.m_91452_(context, (String)"holder");
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ArrayList<Entity> successful = new ArrayList<Entity>();
        ArrayList<Entity> failed = new ArrayList<Entity>();
        for (Entity target : targets) {
            if (LeashDataAPI.LeashOperations.attach(target, holder, maxDistance, elasticDistance, keepTicks, reserved)) {
                successful.add(target);
                continue;
            }
            failed.add(target);
        }
        return successful.size();
    }

    private static int addBlockLeash(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return LeashDataCommand.addBlockLeash(context, CommonEventHandler.leashConfigManager.getMaxLeashLength(), CommonEventHandler.leashConfigManager.getElasticDistance(), 0, "");
    }

    private static int addBlockLeash(CommandContext<CommandSourceStack> context, double maxDistance) throws CommandSyntaxException {
        return LeashDataCommand.addBlockLeash(context, maxDistance, CommonEventHandler.leashConfigManager.getElasticDistance(), 0, "");
    }

    private static int addBlockLeash(CommandContext<CommandSourceStack> context, double maxDistance, double elasticDistance, int keepTicks) throws CommandSyntaxException {
        return LeashDataCommand.addBlockLeash(context, maxDistance, elasticDistance, keepTicks, "");
    }

    private static int addBlockLeash(CommandContext<CommandSourceStack> context, double maxDistance, double elasticDistance, int keepTicks, String reserved) throws CommandSyntaxException {
        Collection targets = EntityArgument.m_91461_(context, (String)"target");
        BlockPos pos = BlockPosArgument.m_264582_(context, (String)"pos");
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerLevel level = source.m_81372_();
        SuperLeashKnotEntity knotEntity = SuperLeashKnotEntity.get((Level)level, pos).or(() -> {
            if (SLPGameruleRegistry.getGameruleBoolValue((Level)level, CreateSuperLeashKnotEntityIfAbsent.NAME_KEY)) {
                return Optional.of(SuperLeashKnotEntity.createKnot((Level)level, pos, true));
            }
            return Optional.empty();
        }).orElse(null);
        if (knotEntity == null) {
            return -1;
        }
        ArrayList<Entity> successful = new ArrayList<Entity>();
        ArrayList<Entity> failed = new ArrayList<Entity>();
        for (Entity target : targets) {
            if (LeashDataAPI.LeashOperations.attach(target, (Entity)knotEntity, maxDistance, elasticDistance, keepTicks, reserved)) {
                successful.add(target);
                continue;
            }
            failed.add(target);
        }
        return successful.size();
    }

    private static int removeLeash(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection targets = EntityArgument.m_91461_(context, (String)"target");
        Entity holder = EntityArgument.m_91452_(context, (String)"holder");
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        int successCount = 0;
        for (Entity target : targets) {
            boolean success = LeashDataAPI.LeashOperations.detach(target, holder);
            if (success) {
                ++successCount;
                source.m_288197_(() -> Component.m_237113_((String)("Removed leash from " + target.m_7755_().getString() + " held by " + holder.m_7755_().getString())), false);
                continue;
            }
            source.m_81352_((Component)Component.m_237113_((String)("No leash found for " + holder.m_7755_().getString() + " on " + target.m_7755_().getString())));
        }
        return successCount;
    }

    private static int removeBlockLeash(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection targets = EntityArgument.m_91461_(context, (String)"target");
        BlockPos pos = BlockPosArgument.m_264582_(context, (String)"pos");
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        int successCount = 0;
        for (Entity target : targets) {
            boolean success = LeashDataAPI.LeashOperations.detach(target, pos);
            if (success) {
                ++successCount;
                source.m_288197_(() -> Component.m_237113_((String)("Removed block leash from " + target.m_7755_().getString() + " at " + pos.m_123344_())), false);
                continue;
            }
            source.m_81352_((Component)Component.m_237113_((String)("No block leash found at " + pos.m_123344_() + " on " + target.m_7755_().getString())));
        }
        return successCount;
    }

    private static int removeAllLeashes(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection targets = EntityArgument.m_91461_(context, (String)"target");
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        for (Entity target : targets) {
            LeashDataAPI.LeashOperations.detachAll(target);
            source.m_288197_(() -> Component.m_237113_((String)("Removed all leashes from " + target.m_7755_().getString())), false);
        }
        return targets.size();
    }

    private static int transferLeash(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return LeashDataCommand.transferLeash(context, "");
    }

    private static int transferLeash(CommandContext<CommandSourceStack> context, String reserved) throws CommandSyntaxException {
        Collection targets = EntityArgument.m_91461_(context, (String)"target");
        Entity from = EntityArgument.m_91452_(context, (String)"from");
        Entity to = EntityArgument.m_91452_(context, (String)"to");
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        int successCount = 0;
        for (Entity target : targets) {
            boolean success;
            boolean bl = success = reserved.isEmpty() ? LeashDataAPI.TransferOperations.transfer(target, from, to) : LeashDataAPI.TransferOperations.transfer(target, from, to, reserved);
            if (success) {
                ++successCount;
                source.m_288197_(() -> Component.m_237113_((String)("Transferred leash from " + from.m_7755_().getString() + " to " + to.m_7755_().getString() + " for " + target.m_7755_().getString())), false);
                continue;
            }
            source.m_81352_((Component)Component.m_237113_((String)("Failed to transfer leash for " + target.m_7755_().getString())));
        }
        return successCount;
    }

    private static int applyForces(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection targets = EntityArgument.m_91461_(context, (String)"target");
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        for (Entity target : targets) {
            LeashDataAPI.PhysicsOperations.applyForces(target);
            source.m_288197_(() -> Component.m_237113_((String)("Applied leash forces to " + target.m_7755_().getString())), false);
        }
        return targets.size();
    }
}

