/*
 * Decompiled with CFR 0.152.
 */
package top.r3944realms.superleadrope.content.entity;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.LeashFenceKnotEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import top.r3944realms.superleadrope.content.capability.impi.LeashDataImpl;
import top.r3944realms.superleadrope.core.register.SLPEntityTypes;
import top.r3944realms.superleadrope.util.capability.LeashDataAPI;

public class SuperLeashKnotEntity
extends LeashFenceKnotEntity {
    private static final float DEFAULT_WIDTH = 0.5f;
    private static final float DEFAULT_HEIGHT = 0.5f;
    private float currentWidth = 0.5f;
    private float currentHeight = 0.5f;
    private static final List<TagKey<Block>> SUPPORTED_BLOCK = Arrays.asList(BlockTags.f_13039_, BlockTags.f_13032_);

    public SuperLeashKnotEntity(EntityType<? extends SuperLeashKnotEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public SuperLeashKnotEntity(Level pLevel, BlockPos pPos) {
        this((EntityType<? extends SuperLeashKnotEntity>)((EntityType)SLPEntityTypes.SUPER_LEAD_KNOT.get()), pLevel);
        this.m_6034_(pPos.m_123341_(), pPos.m_123342_(), pPos.m_123343_());
    }

    public boolean m_6469_(@NotNull DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return false;
        }
        if (!this.m_213877_() && !this.m_9236_().f_46443_) {
            Entity entity2 = source.m_7639_();
            if (entity2 instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity2;
                if (player.f_8941_.m_9290_() == GameType.ADVENTURE) {
                    return false;
                }
            }
            this.m_6074_();
            this.m_5834_();
            this.m_216990_(SoundEvents.f_12033_);
            List<Entity> entities = LeashDataImpl.leashableInArea(this.m_9236_(), this.f_31698_.m_252807_(), entity -> LeashDataImpl.isLeashHolder(entity, (Entity)this));
            entities.forEach(entity -> LeashDataAPI.getLeashData(entity).map(iLeashDataCapability -> iLeashDataCapability.removeLeash((Entity)this)));
        }
        return true;
    }

    public boolean m_7088_() {
        boolean supportBlock = SuperLeashKnotEntity.isSupportBlock(this.m_9236_().m_8055_(this.f_31698_));
        if (!supportBlock) {
            for (Entity entity : LeashDataImpl.leashableInArea((Entity)this)) {
                LeashDataAPI.LeashOperations.detach(entity, (Entity)this);
            }
        }
        return supportBlock;
    }

    @NotNull
    public static SuperLeashKnotEntity getOrCreateKnot(@NotNull Level pLevel, @NotNull BlockPos pPos) {
        int i = pPos.m_123341_();
        int j = pPos.m_123342_();
        int k = pPos.m_123343_();
        for (SuperLeashKnotEntity superLeashKnotEntity : pLevel.m_45976_(SuperLeashKnotEntity.class, new AABB((double)i - 1.0, (double)j - 1.0, (double)k - 1.0, (double)i + 1.0, (double)j + 1.0, (double)k + 1.0))) {
            if (!superLeashKnotEntity.m_31748_().equals((Object)pPos)) continue;
            return superLeashKnotEntity;
        }
        SuperLeashKnotEntity superLeashKnotEntity1 = new SuperLeashKnotEntity(pLevel, pPos);
        pLevel.m_7967_((Entity)superLeashKnotEntity1);
        return superLeashKnotEntity1;
    }

    @NotNull
    public static Optional<SuperLeashKnotEntity> get(@NotNull Level level, @NotNull BlockPos pos) {
        AABB searchArea = new AABB(pos).m_82400_(1.0);
        return level.m_45976_(SuperLeashKnotEntity.class, searchArea).stream().filter(knot -> knot.m_31748_().equals((Object)pos)).findFirst();
    }

    @NotNull
    public static SuperLeashKnotEntity createKnot(@NotNull Level pLevel, @NotNull BlockPos pPos, boolean isEmpty) {
        if (isEmpty) {
            SuperLeashKnotEntity superLeashKnotEntity1 = new SuperLeashKnotEntity(pLevel, pPos);
            pLevel.m_7967_((Entity)superLeashKnotEntity1);
            return superLeashKnotEntity1;
        }
        throw new IllegalArgumentException("Cannot create Knot Entity of type " + SuperLeashKnotEntity.class.getSimpleName());
    }

    protected void m_7087_() {
        this.updateDimensionsBasedOnBlock();
        this.m_20343_((double)this.f_31698_.m_123341_() + 0.5, (double)this.f_31698_.m_123342_() + 0.2, (double)this.f_31698_.m_123343_() + 0.5);
        double halfWidth = this.currentWidth / 2.0f;
        this.m_20011_(new AABB(this.m_20185_() - halfWidth, this.m_20186_(), this.m_20189_() - halfWidth, this.m_20185_() + halfWidth, this.m_20186_() + (double)this.currentHeight, this.m_20189_() + halfWidth));
    }

    private void updateDimensionsBasedOnBlock() {
        BlockState state = this.m_9236_().m_8055_(this.f_31698_);
        if (state.m_204336_(BlockTags.f_13032_)) {
            this.currentWidth = 0.75f;
            this.currentHeight = 0.75f;
        } else {
            this.currentWidth = 0.5f;
            this.currentHeight = 0.5f;
        }
    }

    public static boolean isSupportBlock(BlockState state) {
        for (TagKey<Block> tagKey : SUPPORTED_BLOCK) {
            if (!state.m_204336_(tagKey)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public InteractionResult m_6096_(@NotNull Player player, @NotNull InteractionHand hand) {
        if (this.m_9236_().f_46443_) {
            return InteractionResult.SUCCESS;
        }
        AtomicBoolean isTransferLeash = new AtomicBoolean(false);
        List<Entity> entities = LeashDataImpl.leashableInArea((Entity)player);
        for (Entity entity2 : entities) {
            if (!LeashDataImpl.isLeashHolder(entity2, player.m_20148_())) continue;
            LeashDataAPI.getLeashData(entity2).ifPresent(i -> {
                i.transferLeash(player.m_20148_(), (Entity)this);
                isTransferLeash.set(true);
            });
        }
        AtomicBoolean isRemoveLeashKnot = new AtomicBoolean(false);
        if (!isTransferLeash.get()) {
            if (((ServerPlayer)player).f_8941_.m_9290_() != GameType.ADVENTURE) {
                this.m_216990_(SoundEvents.f_12033_);
                this.m_146870_();
                List<Entity> entities1 = LeashDataImpl.leashableInArea((Entity)this);
                entities1.forEach(entity -> LeashDataAPI.getLeashData(entity).ifPresent(iLeashDataCapability -> {
                    iLeashDataCapability.removeLeash((Entity)this);
                    isRemoveLeashKnot.set(true);
                }));
            }
        } else {
            this.m_216990_(SoundEvents.f_12087_);
        }
        if (isTransferLeash.get() || isRemoveLeashKnot.get()) {
            this.m_146852_(GameEvent.f_157791_, (Entity)player);
        }
        return InteractionResult.CONSUME;
    }
}

