/*
 * Decompiled with CFR 0.152.
 */
package top.r3944realms.superleadrope.content.item;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.NotNull;
import top.r3944realms.superleadrope.content.SLPDamageTypes;
import top.r3944realms.superleadrope.content.capability.CapabilityHandler;
import top.r3944realms.superleadrope.content.capability.provider.EternalPotatoProvider;
import top.r3944realms.superleadrope.datagen.data.SLPLangKeyValue;

public class EternalPotatoItem
extends Item {
    private static final String ITEM_UUID_TAG = "item_uuid";

    public EternalPotatoItem(Item.Properties properties) {
        super(properties.m_41497_(Rarity.EPIC).m_41487_(1));
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag nbt) {
        return new EternalPotatoProvider(stack);
    }

    public static UUID getOrCreateItemUUID(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128403_(ITEM_UUID_TAG)) {
            return tag.m_128342_(ITEM_UUID_TAG);
        }
        UUID uuid = UUID.randomUUID();
        tag.m_128362_(ITEM_UUID_TAG, uuid);
        return uuid;
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        if (player == null || context.m_43725_().f_46443_) {
            return InteractionResult.PASS;
        }
        ItemStack stack = context.m_43722_();
        stack.getCapability(CapabilityHandler.ETERNAL_POTATO_CAP).ifPresent(cap -> {
            if (cap.getCompletionRule().isCompleted((ServerPlayer)player, stack)) {
                cap.getCompletionRule().onCompleted((ServerPlayer)player, stack);
                cap.beginInit();
                cap.setPendingPunishments(Math.max(0, cap.getPendingPunishments() - 1));
                cap.endInit();
            }
        });
        return InteractionResult.m_19078_((boolean)player.m_9236_().f_46443_);
    }

    public void m_7373_(@NotNull ItemStack stack, Level world, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        stack.getCapability(CapabilityHandler.ETERNAL_POTATO_CAP).ifPresent(cap -> {
            tooltip.add((Component)Component.m_237115_((String)SLPLangKeyValue.EP_TOOLTIP_TITLE.getKey()));
            tooltip.add((Component)Component.m_237115_((String)SLPLangKeyValue.EP_DESC_TOOLTIP.getKey()));
            if (cap.getOwnerUUID() != null) {
                tooltip.add((Component)Component.m_237110_((String)SLPLangKeyValue.EP_OBLIGATION_TOOLTIP.getKey(), (Object[])new Object[]{cap.getFinalTaskCount(), cap.getPendingPunishments()}));
                if (cap.getPendingPunishments() > cap.getGracePunishments()) {
                    tooltip.add((Component)Component.m_237110_((String)SLPLangKeyValue.EP_PUNISH_TOOLTIP.getKey(), (Object[])new Object[]{cap.getPendingPunishments(), cap.getGracePunishments()}));
                }
                tooltip.add((Component)Component.m_237110_((String)SLPLangKeyValue.EP_BIND_OWNER.getKey(), (Object[])new Object[]{cap.getOwnerName()}));
            } else {
                tooltip.add((Component)Component.m_237115_((String)SLPLangKeyValue.EP_UNBOUND.getKey()));
            }
        });
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (level.f_46443_) {
            return InteractionResultHolder.m_19096_((Object)stack);
        }
        if (player.m_36335_().m_41519_((Item)this)) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        stack.getCapability(CapabilityHandler.ETERNAL_POTATO_CAP).ifPresent(cap -> {
            boolean isOwner;
            if (cap.getOwnerUUID() == null) {
                cap.beginInit();
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    cap.bindSyncContext((Player)serverPlayer);
                }
                cap.setOwner(player.m_20148_(), player.m_5446_().getString());
                cap.setDailyObligations(99);
                cap.setPendingPunishments(0);
                cap.endInit();
                player.m_5661_((Component)Component.m_237115_((String)SLPLangKeyValue.EP_BIND_MSG.getKey()), true);
                cap.syncToClient(player);
                return;
            }
            if (cap.getBoundPlayer() == null || !cap.getBoundPlayer().m_20148_().equals(player.m_20148_())) {
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    cap.bindSyncContext((Player)serverPlayer);
                }
                assert (player instanceof ServerPlayer);
                cap.syncToClient(player);
            }
            if (!(isOwner = cap.getOwnerUUID().equals(player.m_20148_()))) {
                cap.getPunishment().execute((ServerPlayer)player, new DamageSource(Holder.m_205709_((Object)SLPDamageTypes.ETERNAL_POTATO_NOT_OWNER), (Entity)player), (Component)Component.m_237115_((String)SLPLangKeyValue.EP_PUNISH_NOT_OWNER.getKey()));
            } else {
                player.m_6672_(hand);
                player.m_5634_(50.0f);
                player.m_36324_().m_38707_(18, 8.0f);
                player.m_5661_((Component)Component.m_237110_((String)SLPLangKeyValue.EP_OBLIGATION_INFO.getKey(), (Object[])new Object[]{cap.getDailyObligations()}), true);
                player.m_36335_().m_41524_((Item)this, 60);
            }
        });
        return InteractionResultHolder.m_19092_((Object)stack, (boolean)false);
    }

    public int m_8105_(@NotNull ItemStack stack) {
        return 32;
    }

    @NotNull
    public UseAnim m_6164_(@NotNull ItemStack stack) {
        return UseAnim.EAT;
    }

    @NotNull
    public ItemStack m_5922_(@NotNull ItemStack stack, @NotNull Level level, @NotNull LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!level.f_46443_) {
                player.m_5634_(50.0f);
                player.m_36324_().m_38707_(18, 8.0f);
                player.m_5661_((Component)Component.m_237115_((String)SLPLangKeyValue.EP_POTATO_HEAL.getKey()), true);
                player.m_36335_().m_41524_((Item)this, 60);
            }
        }
        return stack.m_41777_();
    }

    public static String getDescKey(String name) {
        return "item.eternal_potato.tooltip." + name;
    }

    public static String getMsgKey(String name) {
        return "item.eternal_potato.msg." + name;
    }

    public boolean m_41386_(@NotNull DamageSource source) {
        return false;
    }

    public boolean m_142095_() {
        return false;
    }

    public boolean m_5812_(@NotNull ItemStack stack) {
        return true;
    }

    public void m_6883_(@NotNull ItemStack stack, @NotNull Level level, @NotNull Entity entity, int slot, boolean selected) {
        super.m_6883_(stack, level, entity, slot, selected);
    }

    public static void ensureItemInInventory(Player player, ItemStack stack) {
        if (player.m_150109_().m_36054_(stack)) {
            return;
        }
        ArrayList<ItemStack> nonEmptySlots = new ArrayList<ItemStack>();
        for (ItemStack s : player.m_150109_().f_35974_) {
            if (s.m_41619_() || s == stack) continue;
            nonEmptySlots.add(s);
        }
        if (!nonEmptySlots.isEmpty()) {
            ItemStack toDrop = (ItemStack)nonEmptySlots.get(player.m_217043_().m_188503_(nonEmptySlots.size()));
            player.m_7197_(toDrop.m_41777_(), true, false);
            player.m_150109_().m_36057_(toDrop);
            player.m_150109_().m_36054_(stack);
            return;
        }
        ItemStack currentHelmet = (ItemStack)player.m_150109_().f_35975_.get(3);
        if (!currentHelmet.m_41619_()) {
            Objects.requireNonNull(player.m_7197_(currentHelmet.m_41777_(), true, false)).m_6034_(player.m_20185_(), player.m_20186_() + 1.0, player.m_20189_());
        }
        player.m_150109_().f_35975_.set(3, (Object)stack);
    }

    public boolean m_41465_() {
        return false;
    }
}

