/*
 * Decompiled with CFR 0.152.
 */
package top.r3944realms.superleadrope.core.potato;

import java.util.List;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.server.level.ServerLevel;
import net.minecraftforge.server.ServerLifecycleHooks;
import top.r3944realms.superleadrope.content.capability.inter.IEternalPotato;
import top.r3944realms.superleadrope.core.potato.IEternalPotatoChangeListener;
import top.r3944realms.superleadrope.core.potato.IEternalPotatoManager;
import top.r3944realms.superleadrope.core.potato.LocalEternalPotatoManager;
import top.r3944realms.superleadrope.core.potato.PotatoSavedData;
import top.r3944realms.superleadrope.core.potato.SyncedEternalPotatoManager;
import top.r3944realms.superleadrope.core.util.PotatoMode;
import top.r3944realms.superleadrope.core.util.PotatoModeHelper;
import top.r3944realms.superleadrope.network.NetworkHandler;
import top.r3944realms.superleadrope.network.toClient.PacketEternalPotatoRemovePacket;

public class EternalPotatoFacade {
    private static IEternalPotatoManager manager;
    private static PotatoSavedData savedData;
    private static final List<IEternalPotatoChangeListener> listeners;

    public static void addListener(IEternalPotatoChangeListener listener) {
        listeners.add(listener);
    }

    public static void removeListener(IEternalPotatoChangeListener listener) {
        listeners.remove(listener);
    }

    static void notifyChange(UUID uuid, IEternalPotato potato) {
        listeners.forEach(l -> l.onPotatoChanged(uuid, potato));
    }

    public static IEternalPotatoManager getManager() {
        return manager;
    }

    public static PotatoSavedData getSavedData() {
        return savedData;
    }

    public static void initSavedData(ServerLevel serverLevel) {
        savedData = PotatoSavedData.create(serverLevel);
    }

    public static void init(PotatoMode mode, boolean isServer) {
        if (manager != null) {
            return;
        }
        switch (mode) {
            case INTEGRATED: {
                manager = new LocalEternalPotatoManager();
                break;
            }
            case DEDICATED: 
            case REMOTE_CLIENT: {
                manager = new SyncedEternalPotatoManager(isServer);
            }
        }
    }

    public static IEternalPotato getOrCreate(UUID uuid) {
        if (manager == null) {
            throw new IllegalStateException("EternalPotatoFacade not initialized!");
        }
        IEternalPotato potato = manager.getOrCreate(uuid);
        potato.bindItemStackSync(() -> {
            if (savedData != null) {
                savedData.m_77762_();
            }
            EternalPotatoFacade.notifyChange(uuid, potato);
        });
        return potato;
    }

    public static void remove(UUID uuid) {
        if (manager != null) {
            manager.remove(uuid);
        }
        if (PotatoModeHelper.getCurrentMode().isSynced() && ServerLifecycleHooks.getCurrentServer() != null) {
            ServerLifecycleHooks.getCurrentServer().m_6846_().m_11314_().forEach(player -> {
                PacketEternalPotatoRemovePacket packet = new PacketEternalPotatoRemovePacket(uuid);
                NetworkHandler.sendToPlayer(packet, player);
            });
        }
    }

    public static void clear() {
        if (manager != null) {
            manager.clear();
        }
    }

    public static boolean isServer() {
        SyncedEternalPotatoManager synced;
        IEternalPotatoManager iEternalPotatoManager = manager;
        return iEternalPotatoManager instanceof SyncedEternalPotatoManager && (synced = (SyncedEternalPotatoManager)iEternalPotatoManager).isServer();
    }

    static {
        listeners = new CopyOnWriteArrayList<IEternalPotatoChangeListener>();
    }
}

