/*
 * Decompiled with CFR 0.152.
 */
package top.r3944realms.superleadrope.datagen;

import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.r3944realms.superleadrope.datagen.provider.SLPBlockTagProvider;
import top.r3944realms.superleadrope.datagen.provider.SLPItemModelProvider;
import top.r3944realms.superleadrope.datagen.provider.SLPItemRecipeProvider;
import top.r3944realms.superleadrope.datagen.provider.SLPItemTagProvider;
import top.r3944realms.superleadrope.datagen.provider.SLPLanguageProvider;
import top.r3944realms.superleadrope.datagen.provider.SLPSoundDefinitionsProvider;
import top.r3944realms.superleadrope.util.lang.LanguageEnum;

@Mod.EventBusSubscriber(modid="superleadrope", bus=Mod.EventBusSubscriber.Bus.MOD)
public class SLPDataGenEvent {
    static Logger logger = LoggerFactory.getLogger(SLPDataGenEvent.class);

    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        logger.info("GatherDataEvent thread: {}", (Object)Thread.currentThread().getName());
        CompletableFuture lookupProvider = event.getLookupProvider();
        SLPDataGenEvent.LanguageGenerator(event, LanguageEnum.English);
        SLPDataGenEvent.LanguageGenerator(event, LanguageEnum.SimpleChinese);
        SLPDataGenEvent.LanguageGenerator(event, LanguageEnum.TraditionalChinese);
        SLPDataGenEvent.LanguageGenerator(event, LanguageEnum.LiteraryChinese);
        SLPDataGenEvent.RecipeGenerator(event);
        SLPDataGenEvent.ModelDataGenerate(event);
        SLPDataGenEvent.TagsProvider(event, lookupProvider);
        SLPDataGenEvent.SoundProvider(event);
    }

    private static void LanguageGenerator(GatherDataEvent event, LanguageEnum language) {
        event.getGenerator().addProvider(event.includeClient(), pOutput -> new SLPLanguageProvider(pOutput, language));
    }

    private static void RecipeGenerator(GatherDataEvent event) {
        PackOutput packOutput = event.getGenerator().getPackOutput();
        event.getGenerator().addProvider(true, (DataProvider)new SLPItemRecipeProvider(packOutput));
    }

    private static void TagsProvider(GatherDataEvent event, CompletableFuture<HolderLookup.Provider> completableFuture) {
        event.getGenerator().addProvider(event.includeServer(), pOutput -> new SLPBlockTagProvider(pOutput, completableFuture, event.getExistingFileHelper()));
        event.getGenerator().addProvider(event.includeServer(), pOutput -> new SLPItemTagProvider(pOutput, completableFuture, event.getExistingFileHelper()));
    }

    private static void SoundProvider(GatherDataEvent event) {
        event.getGenerator().addProvider(event.includeClient(), pOutput -> new SLPSoundDefinitionsProvider(pOutput, event.getExistingFileHelper()));
    }

    private static void ModelDataGenerate(GatherDataEvent event) {
        event.getGenerator().addProvider(event.includeClient(), pOutput -> new SLPItemModelProvider(pOutput, event.getExistingFileHelper()));
    }
}

