/*
 * Decompiled with CFR 0.152.
 */
package top.r3944realms.superleadrope.datagen.provider;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import top.r3944realms.superleadrope.datagen.data.SLPLangKeyValue;

public class SLPItemModelProvider
extends ItemModelProvider {
    private static List<Item> objectList;
    public static final String GENERATED = "item/generated";
    public static final String HANDHELD = "item/handheld";

    public SLPItemModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "superleadrope", existingFileHelper);
        objectList = new ArrayList<Item>();
        this.init();
    }

    protected void registerModels() {
        this.DefaultModItemModelRegister();
        this.superLeadRopeModel();
    }

    private void init() {
        for (SLPLangKeyValue obj : SLPLangKeyValue.values()) {
            if (!obj.isDefaultItem()) continue;
            objectList.add(obj.getItem());
        }
    }

    private void DefaultModItemModelRegister() {
        objectList.forEach(arg_0 -> ((SLPItemModelProvider)this).basicItem(arg_0));
    }

    public void itemGenerateModel(Item item, ResourceLocation location) {
        ((ItemModelBuilder)this.withExistingParent(this.itemName(item), GENERATED)).texture("layer0", location);
    }

    public void itemHandHeldModel(Item item, ResourceLocation location) {
        ((ItemModelBuilder)this.withExistingParent(this.itemName(item), HANDHELD)).texture("layer0", location);
    }

    public void superLeadRopeModel() {
        ItemModelBuilder builder = (ItemModelBuilder)this.getBuilder("superleadrope:super_lead_rope");
        ((ItemModelBuilder)((ItemModelBuilder)builder.parent((ModelFile)new ModelFile.UncheckedModelFile(GENERATED))).texture("layer0", this.resourceItem("super_lead_rope"))).override().predicate(new ResourceLocation("superleadrope", "broken"), 1.0f).model((ModelFile)new ModelFile.UncheckedModelFile(this.resourceItem("broken_super_lead_rope"))).end();
        ItemModelBuilder brokenBuilder = (ItemModelBuilder)this.getBuilder("superleadrope:broken_super_lead_rope");
        ((ItemModelBuilder)brokenBuilder.parent((ModelFile)new ModelFile.UncheckedModelFile(GENERATED))).texture("layer0", this.resourceItem("broken_super_lead_rope"));
    }

    public String itemName(Item item) {
        return Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)item)).m_135815_();
    }

    public ResourceLocation resourceItem(String path) {
        return this.modLoc("item/" + path);
    }
}

