/*
 * Decompiled with CFR 0.152.
 */
package top.r3944realms.superleadrope.network.toClient;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;
import top.r3944realms.superleadrope.util.capability.LeashDataAPI;

public record LeashDataSyncPacket(int entityId, CompoundTag leashData) {
    public static void encode(LeashDataSyncPacket msg, FriendlyByteBuf buffer) {
        buffer.writeInt(msg.entityId);
        buffer.m_130079_(msg.leashData);
    }

    public static LeashDataSyncPacket decode(FriendlyByteBuf buffer) {
        return new LeashDataSyncPacket(buffer.readInt(), buffer.m_130260_());
    }

    public static void handle(LeashDataSyncPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Entity entity;
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            if (level != null && (entity = level.m_6815_(msg.entityId)) != null) {
                LeashDataAPI.getLeashData(entity).ifPresent(cap -> {
                    CompoundTag current = (CompoundTag)cap.serializeNBT();
                    if (!current.equals((Object)msg.leashData)) {
                        cap.deserializeNBT((Tag)msg.leashData);
                    }
                });
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

