/*
 * Decompiled with CFR 0.152.
 */
package top.r3944realms.superleadrope.network.toClient;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;
import top.r3944realms.superleadrope.content.capability.CapabilityHandler;

public record LeashStateSyncPacket(int entityId, CompoundTag leashState) {
    public static void encode(LeashStateSyncPacket msg, FriendlyByteBuf buffer) {
        buffer.writeInt(msg.entityId);
        buffer.m_130079_(msg.leashState);
    }

    public static LeashStateSyncPacket decode(FriendlyByteBuf buffer) {
        return new LeashStateSyncPacket(buffer.readInt(), buffer.m_130260_());
    }

    public static void handle(LeashStateSyncPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Entity entity;
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            if (level != null && (entity = level.m_6815_(msg.entityId)) != null) {
                entity.getCapability(CapabilityHandler.LEASH_STATE_CAP).ifPresent(cap -> {
                    CompoundTag current = (CompoundTag)cap.serializeNBT();
                    if (!current.equals((Object)msg.leashState)) {
                        cap.deserializeNBT((Tag)msg.leashState);
                    }
                });
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

