/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.mod_menu;

import com.google.common.collect.LinkedListMultimap;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.platform.NativeImage;
import com.terraformersmc.mod_menu.config.ModMenuConfig;
import com.terraformersmc.mod_menu.config.ModMenuConfigScreen;
import com.terraformersmc.mod_menu.util.EnumToLowerCaseJsonConverter;
import com.terraformersmc.mod_menu.util.ModMenuScreenTexts;
import com.terraformersmc.mod_menu.util.mod.Mod;
import com.terraformersmc.mod_menu.util.mod.ModBadge;
import com.terraformersmc.mod_menu.util.mod.java.JavaDummyMod;
import com.terraformersmc.mod_menu.util.mod.neoforge.NeoforgeDummyParentMod;
import com.terraformersmc.mod_menu.util.mod.neoforge.NeoforgeIconHandler;
import com.terraformersmc.mod_menu.util.mod.neoforge.NeoforgeMod;
import java.awt.Color;
import java.awt.Dimension;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.options.OptionsScreen;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.packs.PackType;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Tuple;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.config.ModConfigs;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforgespi.language.IModInfo;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@net.neoforged.fml.common.Mod(value="mod_menu", dist={Dist.CLIENT})
public class ModMenu {
    public static final String MOD_ID = "mod_menu";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Mod Menu");
    public static final Gson GSON;
    public static final Gson GSON_MINIFIED;
    public static final Pair<ModMenuConfig, ModConfigSpec> CONFIG;
    public static boolean shouldResetCache;
    public static final Map<String, Mod> MODS;
    public static final Map<String, Mod> ROOT_MODS;
    public static final LinkedListMultimap<Mod, Mod> PARENT_MAP;
    public static final Map<String, IConfigScreenFactory> configScreenFactories;
    private static int cachedDisplayedModCount;

    public static boolean hasConfigScreen(ModContainer container) {
        return ModMenu.getConfigScreenFactory(container) != null;
    }

    @Nullable
    public static Screen getConfigScreen(ModContainer container, Screen parent) {
        IConfigScreenFactory factory = ModMenu.getConfigScreenFactory(container);
        if (factory != null) {
            return factory.createScreen(container, parent);
        }
        return null;
    }

    @Nullable
    private static IConfigScreenFactory getConfigScreenFactory(ModContainer container) {
        if (((List)ModMenu.getConfig().HIDDEN_CONFIGS.get()).contains(container.getModId()) || "java".equals(container.getModId())) {
            return null;
        }
        if (configScreenFactories.containsKey(container.getModId())) {
            return configScreenFactories.get(container.getModId());
        }
        configScreenFactories.putIfAbsent("minecraft", (modContainer, screen) -> new OptionsScreen(screen, Minecraft.getInstance().options));
        Optional factoryOptional = IConfigScreenFactory.getForMod((IModInfo)container.getModInfo());
        if (factoryOptional.isPresent()) {
            configScreenFactories.putIfAbsent(container.getModId(), (IConfigScreenFactory)factoryOptional.get());
            return configScreenFactories.get(container.getModId());
        }
        String modId = container.getModId();
        boolean hasNeoForgeConfig = ModMenu.hasNeoForgeConfig(modId);
        if (hasNeoForgeConfig) {
            IConfigScreenFactory autoFactory = (modContainer, screen) -> new ConfigurationScreen(modContainer, screen);
            configScreenFactories.putIfAbsent(modId, autoFactory);
            LOGGER.debug("Auto-detected NeoForge config for mod: {}", (Object)modId);
        }
        return configScreenFactories.get(container.getModId());
    }

    private static boolean hasNeoForgeConfig(String modId) {
        try {
            for (ModConfig.Type type : ModConfig.Type.values()) {
                Set configSet = ModConfigs.getConfigSet((ModConfig.Type)type);
                if (configSet == null) continue;
                for (ModConfig config : configSet) {
                    if (!modId.equals(config.getModId())) continue;
                    return true;
                }
            }
        }
        catch (Throwable t) {
            LOGGER.warn("Error checking NeoForge configs for mod {}: {}", (Object)modId, (Object)t.getMessage());
        }
        return false;
    }

    public ModMenu(IEventBus bus, ModContainer container) {
        bus.addListener(this::onClientSetup);
        container.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)CONFIG.getValue());
        container.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)(modContainer, screen) -> new ConfigurationScreen(container, screen, ModMenuConfigScreen::new)));
        for (ModContainer modContainer2 : ModList.get().getSortedMods()) {
            NeoforgeMod mod = new NeoforgeMod(modContainer2);
            MODS.put(mod.getId(), mod);
        }
        HashMap<String, Mod> dummyParents = new HashMap<String, Mod>();
        HashSet<String> modParentSet = new HashSet<String>();
        for (Mod mod : MODS.values()) {
            Mod parent;
            String parentId = mod.getParent();
            if (parentId == null) {
                ROOT_MODS.put(mod.getId(), mod);
                continue;
            }
            modParentSet.clear();
            while (true) {
                if ((parent = MODS.getOrDefault(parentId, (Mod)dummyParents.get(parentId))) == null) {
                    parent = new NeoforgeDummyParentMod(mod, parentId);
                    dummyParents.put(parentId, parent);
                }
                String string = parentId = parent != null ? parent.getParent() : null;
                if (parentId == null) break;
                if (modParentSet.contains(parentId)) {
                    LOGGER.warn("Mods contain each other as parents: {}", modParentSet);
                    parent = null;
                    break;
                }
                modParentSet.add(parentId);
            }
            if (parent == null) {
                ROOT_MODS.put(mod.getId(), mod);
                continue;
            }
            PARENT_MAP.put((Object)parent, (Object)mod);
        }
        JavaDummyMod java = new JavaDummyMod();
        MODS.put("java", java);
        ROOT_MODS.put("java", java);
        MODS.putAll(dummyParents);
    }

    public void onClientSetup(FMLClientSetupEvent event) {
        ModMenu.getConfig().onLoad();
    }

    public static void clearModCountCache() {
        cachedDisplayedModCount = -1;
    }

    public static String getDisplayedModCount() {
        if (cachedDisplayedModCount == -1) {
            boolean includeChildren = (Boolean)ModMenu.getConfig().COUNT_CHILDREN.get();
            boolean includeLibraries = (Boolean)ModMenu.getConfig().COUNT_LIBRARIES.get();
            boolean includeHidden = (Boolean)ModMenu.getConfig().COUNT_HIDDEN_MODS.get();
            cachedDisplayedModCount = Math.toIntExact(MODS.values().stream().filter(mod -> {
                boolean isChild;
                boolean bl = isChild = mod.getParent() != null;
                if (!includeChildren && isChild) {
                    return false;
                }
                boolean isLibrary = mod.getBadges().contains(ModBadge.LIBRARY);
                if (!includeLibraries && isLibrary) {
                    return false;
                }
                return includeHidden || !mod.isHidden();
            }).count());
        }
        return NumberFormat.getInstance().format(cachedDisplayedModCount);
    }

    public static Component createModsButtonText(boolean title) {
        ModMenuConfig.TitleMenuButtonStyle titleStyle = (ModMenuConfig.TitleMenuButtonStyle)((Object)ModMenu.getConfig().MODS_BUTTON_STYLE.get());
        ModMenuConfig.GameMenuButtonStyle gameMenuStyle = (ModMenuConfig.GameMenuButtonStyle)((Object)ModMenu.getConfig().GAME_MENU_BUTTON_STYLE.get());
        boolean isIcon = title ? titleStyle == ModMenuConfig.TitleMenuButtonStyle.ICON : gameMenuStyle == ModMenuConfig.GameMenuButtonStyle.ICON;
        MutableComponent modsText = ModMenuScreenTexts.TITLE.copy().withStyle(style -> style.withColor(16747520));
        if (!isIcon) {
            try {
                String count = ModMenu.getDisplayedModCount();
                modsText.append((Component)Component.literal((String)(" (" + count + ")")).withStyle(style -> style.withColor(16747520)));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return modsText;
    }

    public static ModMenuConfig getConfig() {
        return (ModMenuConfig)CONFIG.getLeft();
    }

    public static void createBadgesAndIcons() {
        ModBadge.CUSTOM_BADGES.clear();
        NeoforgeIconHandler.modResourceIconCache.clear();
        Stream resourcePacks = Minecraft.getInstance().getResourceManager().listPacks();
        resourcePacks.forEach(packResources -> packResources.getNamespaces(PackType.CLIENT_RESOURCES).forEach(namespace -> {
            packResources.listResources(PackType.CLIENT_RESOURCES, namespace, "badge", (key, value) -> {
                try {
                    JsonArray textColor;
                    JsonObject jsonObject = GsonHelper.parse((Reader)new InputStreamReader((InputStream)value.get()));
                    JsonArray fillColor = jsonObject.getAsJsonArray("fill_color");
                    JsonArray outlineColor = jsonObject.getAsJsonArray("outline_color");
                    try {
                        textColor = jsonObject.getAsJsonArray("text_color");
                    }
                    catch (Exception ignored) {
                        textColor = null;
                    }
                    String id = key.getPath().replace("badge/", "").replace(".json", "");
                    ModBadge badge = new ModBadge(id, jsonObject.get("name").getAsString(), new Color(outlineColor.get(0).getAsInt(), outlineColor.get(1).getAsInt(), outlineColor.get(2).getAsInt()).getRGB(), new Color(fillColor.get(0).getAsInt(), fillColor.get(1).getAsInt(), fillColor.get(2).getAsInt()).getRGB(), textColor == null ? -3487030 : new Color(textColor.get(0).getAsInt(), textColor.get(1).getAsInt(), textColor.get(2).getAsInt()).getRGB());
                    ModBadge.CUSTOM_BADGES.put(id, badge);
                }
                catch (Exception e) {
                    LOGGER.warn("incorrect badge json from {} because {}", key, (Object)e.getMessage());
                }
            });
            packResources.listResources(PackType.CLIENT_RESOURCES, namespace, "modicon", (key, value) -> {
                try {
                    NativeImage image = NativeImage.read((InputStream)((InputStream)value.get()));
                    Tuple tex = new Tuple((Object)new DynamicTexture(() -> key.toString(), image), (Object)new Dimension(image.getWidth(), image.getHeight()));
                    String id = key.getPath().replace("modicon/", "").replace(".png", "");
                    NeoforgeIconHandler.modResourceIconCache.put(id, (Tuple<DynamicTexture, Dimension>)tex);
                }
                catch (Exception e) {
                    LOGGER.warn(e.getMessage());
                }
            });
        }));
        shouldResetCache = true;
        MODS.values().forEach(Mod::reCalculateBadge);
    }

    static {
        shouldResetCache = false;
        GsonBuilder builder = new GsonBuilder().registerTypeHierarchyAdapter(Enum.class, (Object)new EnumToLowerCaseJsonConverter()).setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES);
        GSON = builder.setPrettyPrinting().create();
        GSON_MINIFIED = builder.create();
        CONFIG = new ModConfigSpec.Builder().configure(ModMenuConfig::new);
        MODS = new HashMap<String, Mod>();
        ROOT_MODS = new HashMap<String, Mod>();
        PARENT_MAP = LinkedListMultimap.create();
        configScreenFactories = new HashMap<String, IConfigScreenFactory>();
        cachedDisplayedModCount = -1;
    }
}

