/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.mod_menu;

import com.terraformersmc.mod_menu.ModMenu;
import eu.pb4.placeholders.api.ParserContext;
import eu.pb4.placeholders.api.parsers.NodeParser;
import net.minecraft.network.chat.Component;

public class TextPlaceholderApiCompat {
    private static volatile NodeParser PARSER = null;
    private static volatile boolean INIT_ATTEMPTED = false;
    private static volatile boolean INIT_FAILED = false;

    private static NodeParser createParser() {
        try {
            return NodeParser.builder().quickText().build();
        }
        catch (Throwable t) {
            ModMenu.LOGGER.warn("Placeholder API parser failed to initialize; placeholder parsing disabled. This is expected on NeoForge 1.21.10.");
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static NodeParser getParser() {
        if (INIT_FAILED) {
            return null;
        }
        NodeParser p = PARSER;
        if (p != null) return p;
        if (INIT_ATTEMPTED) return p;
        Class<TextPlaceholderApiCompat> clazz = TextPlaceholderApiCompat.class;
        synchronized (TextPlaceholderApiCompat.class) {
            if (INIT_ATTEMPTED) return PARSER;
            INIT_ATTEMPTED = true;
            PARSER = p = TextPlaceholderApiCompat.createParser();
            if (p != null) return p;
            INIT_FAILED = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return p;
        }
    }

    public static Component parseText(String input, ParserContext ctx) {
        block4: {
            if (INIT_FAILED) {
                return Component.literal((String)(input == null ? "" : input));
            }
            try {
                NodeParser p = TextPlaceholderApiCompat.getParser();
                if (p != null) {
                    return p.parseText(input, ctx);
                }
            }
            catch (Throwable t) {
                if (INIT_FAILED) break block4;
                INIT_FAILED = true;
                ModMenu.LOGGER.warn("Placeholder parsing failed at runtime, disabling");
            }
        }
        return Component.literal((String)(input == null ? "" : input));
    }
}

