/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.mod_menu.gui.widget;

import com.terraformersmc.mod_menu.gui.ModsScreen;
import com.terraformersmc.mod_menu.util.mod.Mod;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FormattedCharSequence;

public class DescriptionListWidget
extends ObjectSelectionList<DescriptionEntry> {
    private static final Component LINKS_TEXT = Component.translatable((String)"mod_menu.links");
    private static final Component SOURCE_TEXT = Component.translatable((String)"mod_menu.source").withStyle(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.UNDERLINE});
    private static final Component LICENSE_TEXT = Component.translatable((String)"mod_menu.license");
    private static final Component CREDITS_TEXT = Component.translatable((String)"mod_menu.credits");
    private static final Component AUTHORS_TEXT = Component.translatable((String)"mod_menu.authors");
    private final Font textRenderer;
    private Mod selectedMod = null;
    public int itemHeight;

    public DescriptionListWidget(Minecraft client, int width, int height, int y, int itemHeight, DescriptionListWidget list, ModsScreen parent) {
        super(client, width, height, y, itemHeight);
        this.textRenderer = client.font;
        this.itemHeight = itemHeight;
        if (list != null) {
            try {
                this.setScrollAmount(list.getScrollAmount());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void updateSelectedModIfRequired(Mod mod) {
        if (mod != this.selectedMod) {
            this.selectedMod = mod;
            this.clearEntries();
            try {
                this.setScrollAmount(0.0);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.rebuildUI();
        }
    }

    public int getRowWidth() {
        return this.width - 10;
    }

    protected int getScrollbarPosition() {
        return this.getX() + this.width - 6;
    }

    public double getScrollAmount() {
        return this.scrollAmount();
    }

    protected int contentHeight() {
        return this.getItemCount() * this.itemHeight + 4;
    }

    public int maxScrollAmount() {
        return Math.max(0, this.contentHeight() - this.height);
    }

    public double scrollRate() {
        return 20.0;
    }

    private void renderScrollbar(GuiGraphics guiGraphics) {
        int maxScroll = this.maxScrollAmount();
        if (maxScroll > 0) {
            int scrollbarX = this.getScrollbarPosition();
            int scrollbarWidth = 6;
            int scrollbarHeight = this.height;
            int contentH = this.contentHeight();
            int thumbHeight = Math.max(32, (int)((float)(scrollbarHeight * scrollbarHeight) / (float)contentH));
            thumbHeight = Math.min(thumbHeight, scrollbarHeight);
            int thumbY = (int)(this.scrollAmount() / (double)maxScroll * (double)(scrollbarHeight - thumbHeight));
            thumbY = Math.max(0, Math.min(thumbY, scrollbarHeight - thumbHeight));
            int scrollbarTop = this.getY();
            guiGraphics.fill(scrollbarX, scrollbarTop, scrollbarX + scrollbarWidth, scrollbarTop + scrollbarHeight, Integer.MIN_VALUE);
            guiGraphics.fill(scrollbarX, scrollbarTop + thumbY, scrollbarX + scrollbarWidth, scrollbarTop + thumbY + thumbHeight, -6250336);
        }
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        int maxScroll = this.maxScrollAmount();
        if (maxScroll <= 0) {
            return false;
        }
        double scrollSpeed = this.scrollRate();
        double newScroll = this.scrollAmount() - verticalAmount * scrollSpeed;
        newScroll = Math.max(0.0, Math.min(newScroll, (double)maxScroll));
        this.setScrollAmount(newScroll);
        return true;
    }

    public int getRowTop(int index) {
        return this.getY() + 4 - (int)this.scrollAmount() + index * this.itemHeight;
    }

    protected void renderListItems(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        int entryLeft = this.getRowLeft();
        int entryCount = this.getItemCount();
        int listY = this.getY();
        int listBottom = this.getBottom();
        for (int index = 0; index < entryCount; ++index) {
            DescriptionEntry entry;
            int entryTop = this.getRowTop(index);
            int entryBottom = entryTop + this.itemHeight;
            if (entryBottom < listY || entryTop > listBottom || (entry = (DescriptionEntry)((Object)this.children().get(index))) == null) continue;
            entry.render(guiGraphics, entryLeft, entryTop, mouseX, mouseY, delta);
        }
        this.renderScrollbar(guiGraphics);
    }

    public int getRowLeft() {
        return this.getX() + 6;
    }

    private void rebuildUI() {
        SortedMap<String, Set<String>> sortedMap;
        Set<String> licenses;
        List<String> authors;
        this.clearEntries();
        if (this.selectedMod == null) {
            return;
        }
        int wrapWidth = Math.max(10, this.getRowWidth() - 5);
        Component description = this.selectedMod.getFormattedDescription();
        if (description != null && !description.getString().isEmpty()) {
            List lines = this.textRenderer.split((FormattedText)description, wrapWidth);
            for (FormattedCharSequence line : lines) {
                this.addEntry((AbstractSelectionList.Entry)new DescriptionEntry(this, line, 0));
            }
        }
        if ((authors = this.selectedMod.getAuthors()) != null && !authors.isEmpty()) {
            this.addEntry((AbstractSelectionList.Entry)new DescriptionEntry(this, FormattedCharSequence.EMPTY, 0));
            for (FormattedCharSequence line : this.textRenderer.split((FormattedText)AUTHORS_TEXT, wrapWidth)) {
                this.addEntry((AbstractSelectionList.Entry)new DescriptionEntry(this, line, 0));
            }
            for (String author : authors) {
                for (FormattedCharSequence formattedCharSequence : this.textRenderer.split((FormattedText)Component.literal((String)author), wrapWidth - 16)) {
                    this.addEntry((AbstractSelectionList.Entry)new DescriptionEntry(this, formattedCharSequence, 8));
                }
            }
        }
        Map<String, String> links = this.selectedMod.getLinks();
        String sourceLink = this.selectedMod.getSource();
        if (links != null && !links.isEmpty() || sourceLink != null) {
            this.addEntry((AbstractSelectionList.Entry)new DescriptionEntry(this, FormattedCharSequence.EMPTY, 0));
            for (FormattedCharSequence formattedCharSequence : this.textRenderer.split((FormattedText)LINKS_TEXT, wrapWidth)) {
                this.addEntry((AbstractSelectionList.Entry)new DescriptionEntry(this, formattedCharSequence, 0));
            }
            if (sourceLink != null) {
                for (FormattedCharSequence formattedCharSequence : this.textRenderer.split((FormattedText)SOURCE_TEXT, wrapWidth - 16)) {
                    this.addEntry((AbstractSelectionList.Entry)new DescriptionEntry(this, formattedCharSequence, 8));
                }
            }
            if (links != null) {
                for (Map.Entry entry : links.entrySet()) {
                    MutableComponent linkText = Component.literal((String)((String)entry.getKey())).withStyle(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.UNDERLINE});
                    for (FormattedCharSequence line : this.textRenderer.split((FormattedText)linkText, wrapWidth - 16)) {
                        this.addEntry((AbstractSelectionList.Entry)new DescriptionEntry(this, line, 8));
                    }
                }
            }
        }
        if ((licenses = this.selectedMod.getLicense()) != null && !licenses.isEmpty()) {
            this.addEntry((AbstractSelectionList.Entry)new DescriptionEntry(this, FormattedCharSequence.EMPTY, 0));
            for (FormattedCharSequence line : this.textRenderer.split((FormattedText)LICENSE_TEXT, wrapWidth)) {
                this.addEntry((AbstractSelectionList.Entry)new DescriptionEntry(this, line, 0));
            }
            for (String license : licenses) {
                for (FormattedCharSequence line : this.textRenderer.split((FormattedText)Component.literal((String)license), wrapWidth - 16)) {
                    this.addEntry((AbstractSelectionList.Entry)new DescriptionEntry(this, line, 8));
                }
            }
        }
        if ((sortedMap = this.selectedMod.getCredits()) != null && !sortedMap.isEmpty()) {
            this.addEntry((AbstractSelectionList.Entry)new DescriptionEntry(this, FormattedCharSequence.EMPTY, 0));
            for (FormattedCharSequence formattedCharSequence : this.textRenderer.split((FormattedText)CREDITS_TEXT, wrapWidth)) {
                this.addEntry((AbstractSelectionList.Entry)new DescriptionEntry(this, formattedCharSequence, 0));
            }
            for (Map.Entry entry : sortedMap.entrySet()) {
                String roleName = (String)entry.getKey();
                String translationKey = "mod_menu.credits.role." + roleName.replaceAll("[ -]", "_").toLowerCase();
                Object fallback = roleName.endsWith("r") ? roleName + "s" : roleName;
                MutableComponent roleText = Component.translatableWithFallback((String)translationKey, (String)fallback).append((Component)Component.literal((String)":"));
                for (FormattedCharSequence line : this.textRenderer.split((FormattedText)roleText, wrapWidth - 16)) {
                    this.addEntry((AbstractSelectionList.Entry)new DescriptionEntry(this, line, 8));
                }
                for (String contributor : (Set)entry.getValue()) {
                    for (FormattedCharSequence line : this.textRenderer.split((FormattedText)Component.literal((String)contributor), wrapWidth - 24)) {
                        this.addEntry((AbstractSelectionList.Entry)new DescriptionEntry(this, line, 16));
                    }
                }
            }
        }
    }

    public static class DescriptionEntry
    extends ObjectSelectionList.Entry<DescriptionEntry> {
        private final DescriptionListWidget list;
        private final FormattedCharSequence text;
        private final int indent;

        public DescriptionEntry(DescriptionListWidget list, FormattedCharSequence text, int indent) {
            this.list = list;
            this.text = text;
            this.indent = indent;
        }

        public void render(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY, float delta) {
            guiGraphics.drawString(this.list.textRenderer, this.text, x + this.indent, y, -5592406, true);
        }

        public void renderContent(GuiGraphics guiGraphics, int mouseX, int mouseY, boolean hovered, float delta) {
            int index = this.list.children().indexOf((Object)this);
            int y = this.list.getRowTop(index);
            int x = this.list.getRowLeft();
            guiGraphics.drawString(this.list.textRenderer, this.text, x + this.indent, y, -5592406, true);
        }

        public Component getNarration() {
            return Component.empty();
        }
    }
}

