/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.mod_menu.gui.widget;

import com.terraformersmc.mod_menu.ModMenu;
import com.terraformersmc.mod_menu.config.ModMenuConfig;
import com.terraformersmc.mod_menu.gui.ModsScreen;
import com.terraformersmc.mod_menu.gui.widget.entries.ChildEntry;
import com.terraformersmc.mod_menu.gui.widget.entries.ChildParentEntry;
import com.terraformersmc.mod_menu.gui.widget.entries.IndependentEntry;
import com.terraformersmc.mod_menu.gui.widget.entries.ModListEntry;
import com.terraformersmc.mod_menu.gui.widget.entries.ParentEntry;
import com.terraformersmc.mod_menu.util.mod.Mod;
import com.terraformersmc.mod_menu.util.mod.ModBadge;
import com.terraformersmc.mod_menu.util.mod.ModSearch;
import com.terraformersmc.mod_menu.util.mod.neoforge.NeoforgeIconHandler;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.GameNarrator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class ModListWidget
extends ObjectSelectionList<ModListEntry>
implements AutoCloseable {
    public static final boolean DEBUG = Boolean.getBoolean("mod_menu.debug");
    private final ModsScreen parent;
    private List<Mod> mods = null;
    private final Set<Mod> addedMods = new HashSet<Mod>();
    private String selectedModId = null;
    private final NeoforgeIconHandler iconHandler = new NeoforgeIconHandler();
    private Double restoreScrollY = null;
    public int itemHeight;
    public int headerHeight = 0;

    public ModListWidget(Minecraft client, int width, int height, int y, int itemHeight, ModListWidget list, ModsScreen parent) {
        super(client, width, height, y, itemHeight);
        this.itemHeight = itemHeight;
        this.parent = parent;
        if (list != null) {
            this.mods = list.mods;
            this.restoreScrollY = list.getScrollAmount();
        }
    }

    public int getRowTop(int index) {
        return this.getY() + 4 - (int)this.scrollAmount() + index * this.itemHeight;
    }

    public int getItemCount() {
        return super.getItemCount();
    }

    public ModListEntry getSelected() {
        return (ModListEntry)super.getSelected();
    }

    public void setScrollAmount(double amount) {
        super.setScrollAmount(amount);
        int denominator = Math.max(0, this.getMaxPosition() - (this.getBottom() - this.getY() - 4));
        if (denominator <= 0) {
            this.parent.updateScrollPercent(0.0);
        } else {
            double percent = this.scrollAmount() / (double)Math.max(0, this.getMaxPosition() - (this.getBottom() - this.getY() - 4));
            this.parent.updateScrollPercent(percent);
        }
    }

    public double getScrollAmount() {
        return this.scrollAmount();
    }

    protected int contentHeight() {
        return this.getItemCount() * this.itemHeight + 4;
    }

    public int maxScrollAmount() {
        return Math.max(0, this.contentHeight() - this.height);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        int maxScroll = this.maxScrollAmount();
        if (maxScroll <= 0) {
            return false;
        }
        double scrollRate = this.scrollRate();
        double newScroll = this.scrollAmount() - verticalAmount * scrollRate;
        newScroll = Math.max(0.0, Math.min(newScroll, (double)maxScroll));
        this.setScrollAmount(newScroll);
        return true;
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean doubleClick) {
        double mouseY;
        double mouseX = event.x();
        if (!this.isMouseOver(mouseX, mouseY = event.y())) {
            return false;
        }
        ModListEntry entry = this.getEntryAtPos(mouseX, mouseY);
        if (entry != null) {
            return entry.mouseClicked(event, doubleClick);
        }
        return false;
    }

    public boolean isFocused() {
        return this.parent.getFocused() == this;
    }

    public void select(ModListEntry entry) {
        this.setSelected(entry);
        if (entry != null) {
            Mod mod = entry.mod;
            try {
                GameNarrator narrator = Minecraft.getInstance().getNarrator();
                Method m = narrator.getClass().getMethod("sayNow", String.class);
                m.invoke((Object)narrator, Component.translatable((String)"narrator.select", (Object[])new Object[]{mod.getTranslatedName()}).getString());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void setSelected(ModListEntry entry) {
        double savedScroll = this.scrollAmount();
        try {
            Field selectedField = null;
            Class<?> clazz = this.getClass().getSuperclass();
            while (clazz != null && selectedField == null) {
                try {
                    selectedField = clazz.getDeclaredField("selected");
                }
                catch (NoSuchFieldException e) {
                    clazz = clazz.getSuperclass();
                }
            }
            if (selectedField != null) {
                selectedField.setAccessible(true);
                selectedField.set(this, (Object)entry);
            } else {
                super.setSelected((AbstractSelectionList.Entry)entry);
            }
        }
        catch (Throwable t) {
            super.setSelected((AbstractSelectionList.Entry)entry);
        }
        this.setScrollAmount(savedScroll);
        this.selectedModId = entry == null || entry.mod == null ? null : entry.mod.getId();
        this.parent.updateSelectedEntry(entry);
    }

    private void deferSetSelected(ModListEntry entry, String ctx) {
        Minecraft.getInstance().execute(() -> {
            double savedScroll = this.scrollAmount();
            try {
                Field selectedField = null;
                Class<?> clazz = this.getClass().getSuperclass();
                while (clazz != null && selectedField == null) {
                    try {
                        selectedField = clazz.getDeclaredField("selected");
                    }
                    catch (NoSuchFieldException e) {
                        clazz = clazz.getSuperclass();
                    }
                }
                if (selectedField != null) {
                    selectedField.setAccessible(true);
                    selectedField.set(this, (Object)entry);
                } else {
                    super.setSelected((AbstractSelectionList.Entry)entry);
                }
            }
            catch (Throwable t) {
                super.setSelected((AbstractSelectionList.Entry)entry);
            }
            this.setScrollAmount(savedScroll);
            this.selectedModId = entry == null || entry.mod == null ? null : entry.mod.getId();
            this.parent.updateSelectedEntry(entry);
        });
    }

    protected boolean isSelectedItem(int index) {
        ModListEntry selected = this.getSelected();
        ModListEntry e = this.getEntry(index);
        return selected != null && e != null && selected.mod != null && e.mod != null && selected.mod.getId().equals(e.mod.getId());
    }

    public int addEntry(ModListEntry entry) {
        if (this.addedMods.contains(entry.mod)) {
            return 0;
        }
        this.addedMods.add(entry.mod);
        int idx = super.addEntry((AbstractSelectionList.Entry)entry);
        if (entry.mod != null && entry.mod.getId().equals(this.selectedModId)) {
            this.deferSetSelected(entry, "addEntry-match");
        }
        return idx;
    }

    protected void removeEntry(ModListEntry entry) {
        this.addedMods.remove(entry.mod);
        super.removeEntry((AbstractSelectionList.Entry)entry);
    }

    protected ModListEntry remove(int index) {
        ModListEntry e = (ModListEntry)((Object)this.children().remove(index));
        if (e != null) {
            this.addedMods.remove(e.mod);
        }
        return e;
    }

    public void finalizeInit() {
        this.reloadFilters();
        if (this.restoreScrollY != null) {
            this.setScrollAmount(this.restoreScrollY);
            this.restoreScrollY = null;
        }
    }

    public void reloadFilters() {
        this.filter(this.parent.getSearchInput(), true, false);
    }

    public void filter(String searchTerm, boolean refresh) {
        this.filter(searchTerm, refresh, true);
    }

    private boolean hasVisibleChildMods(Mod parent) {
        List children = ModMenu.PARENT_MAP.get((Object)parent);
        boolean hideLibraries = (Boolean)ModMenu.getConfig().SHOW_LIBRARIES.get() == false;
        return !children.stream().allMatch(child -> child.isHidden() || hideLibraries && (child.getBadgeNames().contains("library") || child.getBadges().contains(ModBadge.LIBRARY)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void filter(String searchTerm, boolean refresh, boolean search) {
        block32: {
            this.clearEntries();
            this.addedMods.clear();
            ModMenu.LOGGER.debug("ModListWidget.filter() start: search='{}' refresh={} searchFlag={}", new Object[]{searchTerm, refresh, search});
            ArrayList mods = (ArrayList)((Object)ModMenu.MODS.values().stream().filter(mod -> {
                if (((Boolean)ModMenu.getConfig().CONFIG_MODE.get()).booleanValue()) {
                    return !this.parent.getModHasConfigScreen(mod.getContainer());
                }
                return !mod.isHidden();
            }).collect(Collectors.toSet()));
            if (DEBUG) {
                mods = new ArrayList(mods);
            }
            if (this.mods == null || refresh) {
                this.mods = new ArrayList<Mod>();
                this.mods.addAll(mods);
                ModMenu.LOGGER.debug("ModListWidget.filter(): collected {} mods before sorting", (Object)this.mods.size());
                this.mods.sort(((ModMenuConfig.Sorting)((Object)ModMenu.getConfig().SORTING.get())).getComparator());
                ModMenu.LOGGER.debug("ModListWidget.filter(): sorting complete");
            }
            List<Mod> matched = ModSearch.search(this.parent, searchTerm, this.mods);
            ModMenu.LOGGER.debug("ModListWidget.filter(): matched {} mods after search", (Object)matched.size());
            int __ml_idx = 0;
            ArrayList<ModListEntry> entriesToAdd = new ArrayList<ModListEntry>();
            for (Mod mod2 : matched) {
                if ((__ml_idx++ & 0x1F) == 0) {
                    ModMenu.LOGGER.trace("ModListWidget.filter(): processing matched index {}", (Object)__ml_idx);
                }
                String modId = mod2.getId();
                long __entryStart = System.nanoTime();
                ModMenu.LOGGER.debug("ModListWidget.filter(): processing mod '{}' ({}/{}) start", new Object[]{modId, __ml_idx, matched.size()});
                try {
                    if (!((Boolean)ModMenu.getConfig().SHOW_LIBRARIES.get()).booleanValue() && (mod2.getBadgeNames().contains("library") || mod2.getBadges().contains(ModBadge.LIBRARY)) || ModMenu.PARENT_MAP.values().contains(mod2)) continue;
                    if (ModMenu.PARENT_MAP.keySet().contains(mod2) && this.hasVisibleChildMods(mod2)) {
                        List children = ModMenu.PARENT_MAP.get((Object)mod2);
                        children.sort(((ModMenuConfig.Sorting)((Object)ModMenu.getConfig().SORTING.get())).getComparator());
                        ModMenu.LOGGER.debug("ModListWidget.filter(): creating ParentEntry for mod {} ({} children)", (Object)modId, (Object)children.size());
                        long beforeParent = System.nanoTime();
                        ParentEntry parent = new ParentEntry(mod2, children, this);
                        long afterParentCreate = System.nanoTime();
                        ModMenu.LOGGER.debug("ModListWidget.filter(): ParentEntry created in {} ms", (Object)((afterParentCreate - beforeParent) / 1000000L));
                        ModMenu.LOGGER.debug("ModListWidget.filter(): queuing ParentEntry for mod {}", (Object)modId);
                        entriesToAdd.add(parent);
                        if (!this.parent.showModChildren.contains(modId)) continue;
                        List<Mod> validChildren = ModSearch.search(this.parent, searchTerm, children);
                        for (Mod child : validChildren) {
                            this.collectChildEntries(child, validChildren, parent, List.of(parent), searchTerm, 1, entriesToAdd);
                        }
                        continue;
                    }
                    ModMenu.LOGGER.debug("ModListWidget.filter(): creating IndependentEntry for mod {}", (Object)modId);
                    long beforeIndependent = System.nanoTime();
                    ModListEntry entry = new IndependentEntry(mod2, this);
                    long afterIndependentCreate = System.nanoTime();
                    ModMenu.LOGGER.debug("ModListWidget.filter(): IndependentEntry created in {} ms", (Object)((afterIndependentCreate - beforeIndependent) / 1000000L));
                    ModMenu.LOGGER.debug("ModListWidget.filter(): queuing IndependentEntry for mod {}", (Object)modId);
                    entriesToAdd.add(entry);
                }
                finally {
                    long __entryEnd = System.nanoTime();
                    ModMenu.LOGGER.debug("ModListWidget.filter(): processing mod '{}' finished, took {} ms", (Object)modId, (Object)((__entryEnd - __entryStart) / 1000000L));
                }
            }
            ModMenu.LOGGER.debug("ModListWidget.filter(): adding {} entries in batch", (Object)entriesToAdd.size());
            try {
                Field childrenField = null;
                Class currentClass = this.getClass();
                while (currentClass != null && childrenField == null) {
                    try {
                        childrenField = currentClass.getDeclaredField("children");
                    }
                    catch (NoSuchFieldException e) {
                        currentClass = currentClass.getSuperclass();
                    }
                }
                if (childrenField != null) {
                    boolean modifiable;
                    childrenField.setAccessible(true);
                    List internalList = (List)childrenField.get(this);
                    String internalClassName = internalList.getClass().getName();
                    boolean bl = modifiable = !internalClassName.contains("Unmodifiable") && !internalClassName.contains("UnmodifiableCollection");
                    if (modifiable) {
                        try {
                            long __internalAddStart = System.nanoTime();
                            internalList.addAll(entriesToAdd);
                            long __internalAddEnd = System.nanoTime();
                            ModMenu.LOGGER.debug("ModListWidget.filter(): internalList.addAll took {} ms", (Object)((__internalAddEnd - __internalAddStart) / 1000000L));
                            for (ModListEntry entry : entriesToAdd) {
                                this.addedMods.add(entry.mod);
                                if (entry.mod == null || !entry.mod.getId().equals(this.selectedModId)) continue;
                                this.deferSetSelected(entry, "bulk-match");
                            }
                            break block32;
                        }
                        catch (UnsupportedOperationException uoe) {
                            ModMenu.LOGGER.warn("ModListWidget.filter(): internalList.addAll threw UnsupportedOperationException (class={}), falling back to per-entry addEntry()", (Object)internalList.getClass().getName());
                            for (ModListEntry entry : entriesToAdd) {
                                this.addEntry(entry);
                            }
                            break block32;
                        }
                    }
                    ModMenu.LOGGER.warn("ModListWidget.filter(): internal 'children' list appears unmodifiable (class={}), falling back to per-entry addEntry()", (Object)internalClassName);
                    for (ModListEntry entry : entriesToAdd) {
                        this.addEntry(entry);
                    }
                    break block32;
                }
                ModMenu.LOGGER.warn("ModListWidget.filter(): could not find internal 'children' field, falling back to addEntry()");
                for (ModListEntry entry : entriesToAdd) {
                    this.addEntry(entry);
                }
            }
            catch (Throwable t) {
                ModMenu.LOGGER.error("ModListWidget.filter(): error adding entries via reflection, falling back to addEntry()", t);
                for (ModListEntry entry : entriesToAdd) {
                    this.addEntry(entry);
                }
            }
        }
        try {
            ModListEntry parentSelected = this.parent.getSelectedEntry();
            ModListEntry currentSelected = this.getSelected();
            if (parentSelected != null && !this.children().isEmpty()) {
                boolean found = false;
                for (ModListEntry entry : this.children()) {
                    if (entry.mod == null || parentSelected.mod == null || !entry.mod.equals(parentSelected.mod)) continue;
                    this.deferSetSelected(entry, "parent-match");
                    found = true;
                    break;
                }
                if (!found && !this.children().isEmpty() && this.getEntry(0) != null) {
                    this.deferSetSelected(this.getEntry(0), "select-first");
                }
            } else if (currentSelected == null && !this.children().isEmpty() && this.getEntry(0) != null) {
                this.deferSetSelected(this.getEntry(0), "select-first");
            }
        }
        catch (Exception e) {
            ModMenu.LOGGER.error("ModListWidget.filter(): Error in selection logic", (Throwable)e);
        }
        if (this.getScrollAmount() > (double)Math.max(0, this.getMaxPosition() - (this.getBottom() - this.getY() - 4))) {
            this.setScrollAmount(Math.max(0, this.getMaxPosition() - (this.getBottom() - this.getY() - 4)));
        }
    }

    public void addChildMod(Mod child, List<Mod> validChildren, ParentEntry parent, List<ModListEntry> parents, String searchTerm, int parentCount) {
        if (ModMenu.PARENT_MAP.keySet().contains(child) && this.hasVisibleChildMods(child)) {
            List childChildren = ModMenu.PARENT_MAP.get((Object)child);
            childChildren.sort(((ModMenuConfig.Sorting)((Object)ModMenu.getConfig().SORTING.get())).getComparator());
            ChildParentEntry childParentEntry = new ChildParentEntry(child, parent, parents, childChildren, this, validChildren.indexOf(child) == validChildren.size() - 1);
            this.addEntry(childParentEntry);
            if (this.parent.showModChildren.contains(child.getId())) {
                List<Mod> validChildChildren = ModSearch.search(this.parent, searchTerm, childChildren);
                for (Mod childChild : validChildChildren) {
                    ArrayList<ModListEntry> childParents = new ArrayList<ModListEntry>(parents);
                    childParents.add(childParentEntry);
                    this.addChildMod(childChild, validChildChildren, parent, childParents, searchTerm, parentCount + 1);
                }
            }
        } else {
            this.addEntry(new ChildEntry(child, parent, parents, this, validChildren.indexOf(child) == validChildren.size() - 1));
        }
    }

    private void collectChildEntries(Mod child, List<Mod> validChildren, ParentEntry parent, List<ModListEntry> parents, String searchTerm, int parentCount, List<ModListEntry> collector) {
        if (ModMenu.PARENT_MAP.keySet().contains(child) && this.hasVisibleChildMods(child)) {
            List childChildren = ModMenu.PARENT_MAP.get((Object)child);
            childChildren.sort(((ModMenuConfig.Sorting)((Object)ModMenu.getConfig().SORTING.get())).getComparator());
            ChildParentEntry childParentEntry = new ChildParentEntry(child, parent, parents, childChildren, this, validChildren.indexOf(child) == validChildren.size() - 1);
            collector.add(childParentEntry);
            if (this.parent.showModChildren.contains(child.getId())) {
                List<Mod> validChildChildren = ModSearch.search(this.parent, searchTerm, childChildren);
                for (Mod childChild : validChildChildren) {
                    ArrayList<ModListEntry> childParents = new ArrayList<ModListEntry>(parents);
                    childParents.add(childParentEntry);
                    this.collectChildEntries(childChild, validChildChildren, parent, childParents, searchTerm, parentCount + 1, collector);
                }
            }
        } else {
            collector.add(new ChildEntry(child, parent, parents, this, validChildren.indexOf(child) == validChildren.size() - 1));
        }
    }

    protected void renderListItems(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        int entryLeft = this.getRowLeft();
        int entryWidth = this.getRowWidth();
        int entryHeight = this.itemHeight - 4;
        int entryCount = this.getItemCount();
        int listY = this.getY();
        int listBottom = this.getBottom();
        for (int index = 0; index < entryCount; ++index) {
            ModListEntry entry;
            int entryTop = this.getRowTop(index);
            int entryBottom = entryTop + this.itemHeight;
            if (entryBottom < listY || entryTop > listBottom || (entry = this.getEntry(index)) == null) continue;
            if (this.isSelectedItem(index)) {
                int entryContentLeft = entryLeft + entry.getXOffset() - 2;
                int selectionRight = entryLeft + entryWidth + 2;
                int selectionTop = entryTop - 1;
                int alpha = this.isFocused() ? 160 : 64;
                int outlineColor = alpha << 24 | 0xFF8C00;
                guiGraphics.fill(entryContentLeft, selectionTop, selectionRight, selectionTop + 2, outlineColor);
                guiGraphics.fill(entryContentLeft, selectionTop + entryHeight + 1, selectionRight, selectionTop + entryHeight + 3, outlineColor);
                guiGraphics.fill(entryContentLeft, selectionTop + 1, entryContentLeft + 2, selectionTop + entryHeight + 2, outlineColor);
                guiGraphics.fill(selectionRight - 2, selectionTop + 1, selectionRight, selectionTop + entryHeight + 2, outlineColor);
                int innerAlpha = this.isFocused() ? 48 : 18;
                int innerColor = innerAlpha << 24 | 0xFF8C00;
                guiGraphics.fill(entryContentLeft + 2, selectionTop + 2, selectionRight - 2, selectionTop + entryHeight + 1, innerColor);
            }
            boolean hovered = this.isMouseOver(mouseX, mouseY) && mouseY >= entryTop && mouseY < entryBottom;
            entry.renderEntry(guiGraphics, index, entryTop, entryLeft, entryWidth, entryHeight, mouseX, mouseY, hovered, delta);
        }
    }

    public void ensureVisible(ModListEntry entry) {
        if (entry == null) {
            return;
        }
        int index = this.children().indexOf((Object)entry);
        if (index < 0) {
            return;
        }
        int top = this.getRowTop(index);
        int bottom = top + this.itemHeight;
        if (top < this.getY()) {
            this.setScrollAmount(this.getScrollAmount() - (double)(this.getY() - top));
        } else if (bottom > this.getBottom()) {
            this.setScrollAmount(this.getScrollAmount() + (double)(bottom - this.getBottom()));
        }
    }

    public boolean legacyKeyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 265 || keyCode == 264) {
            return false;
        }
        if (this.getSelected() != null) {
            return this.getSelected().legacyKeyPressed(keyCode, scanCode, modifiers);
        }
        return false;
    }

    public boolean keyPressed(Object event) {
        try {
            Integer key = ModListWidget.extractInt(event, "getKeyCode", "getKey", "key");
            Integer scan = ModListWidget.extractInt(event, "getScanCode", "getScan");
            Integer mods = ModListWidget.extractInt(event, "getModifiers", "getModifiersEx", "mods");
            return this.legacyKeyPressed(key == null ? 0 : key, scan == null ? 0 : scan, mods == null ? 0 : mods);
        }
        catch (Throwable t) {
            return false;
        }
    }

    private static Integer extractInt(Object ev, String ... names) {
        Object val;
        Method m2;
        if (ev == null) {
            return null;
        }
        for (String n : names) {
            try {
                m2 = ev.getClass().getMethod(n, new Class[0]);
                m2.setAccessible(true);
                val = m2.invoke(ev, new Object[0]);
                if (val instanceof Integer) {
                    return (Integer)val;
                }
                if (val instanceof Short) {
                    return ((Short)val).intValue();
                }
                if (val instanceof Byte) {
                    return ((Byte)val).intValue();
                }
                if (val instanceof Long) {
                    return ((Long)val).intValue();
                }
                if (!(val instanceof Number)) continue;
                return ((Number)val).intValue();
            }
            catch (NoSuchMethodException m2) {
            }
            catch (Throwable m2) {
                // empty catch block
            }
        }
        for (String n : names) {
            try {
                m2 = ev.getClass().getMethod(n, new Class[0]);
                m2.setAccessible(true);
                val = m2.invoke(ev, new Object[0]);
                if (!(val instanceof Boolean)) continue;
                return (Boolean)val != false ? 1 : 0;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public final ModListEntry getEntryAtPos(double x, double y) {
        int int_5 = Mth.floor((double)(y - (double)this.getY())) - this.headerHeight + (int)this.getScrollAmount() - 4;
        int index = int_5 / this.itemHeight;
        return x < (double)this.getScrollbarPosition() && x >= (double)this.getRowLeft() && x <= (double)(this.getRowLeft() + this.getRowWidth()) && index >= 0 && int_5 >= 0 && index < this.getItemCount() ? (ModListEntry)((Object)this.children().get(index)) : null;
    }

    protected int getScrollbarPosition() {
        return this.width - 6;
    }

    public int getRowWidth() {
        return this.width - (Math.max(0, this.getMaxPosition() - (this.getBottom() - this.getY() - 4)) > 0 ? 18 : 12);
    }

    public int getRowLeft() {
        return this.getX() + 6;
    }

    public int getWidth() {
        return this.width;
    }

    public int getTop() {
        return this.getY();
    }

    public ModsScreen getParent() {
        return this.parent;
    }

    protected int getMaxPosition() {
        return this.getItemCount() * this.itemHeight + 4;
    }

    public int getDisplayedCountFor(Set<String> set) {
        int count = 0;
        for (ModListEntry c : this.children()) {
            if (c.mod == null || !set.contains(c.mod.getId())) continue;
            ++count;
        }
        return count;
    }

    @Override
    public void close() {
        this.iconHandler.close();
    }

    public NeoforgeIconHandler getNeoforgeIconHandler() {
        return this.iconHandler;
    }

    public int getRowBottom(int index) {
        return super.getRowBottom(index);
    }

    public ModListEntry getEntry(int index) {
        return index >= 0 && index < this.children().size() ? (ModListEntry)((Object)this.children().get(index)) : null;
    }
}

