/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.mod_menu.util.mod.neoforge;

import com.mojang.blaze3d.platform.NativeImage;
import java.awt.Dimension;
import java.io.Closeable;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.util.Tuple;
import net.neoforged.fml.ModContainer;
import net.neoforged.neoforgespi.locating.IModFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NeoforgeIconHandler
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Mod Menu | NeoforgeIconHandler");
    private final Map<String, Tuple<DynamicTexture, Dimension>> modIconCache = new HashMap<String, Tuple<DynamicTexture, Dimension>>();
    public static final Map<String, Tuple<DynamicTexture, Dimension>> modResourceIconCache = new HashMap<String, Tuple<DynamicTexture, Dimension>>();

    public Tuple<DynamicTexture, Dimension> createIcon(ModContainer iconSource, String iconPath) {
        Tuple tuple;
        block10: {
            String cacheKey = iconSource.getModId() + "|" + iconPath;
            Tuple<DynamicTexture, Dimension> cached = this.modIconCache.get(cacheKey);
            if (cached != null) {
                return cached;
            }
            Path path = this.findIconPath(iconSource, iconPath);
            if (path == null || !Files.exists(path, new LinkOption[0])) {
                return null;
            }
            InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);
            try {
                NativeImage image = NativeImage.read((InputStream)Objects.requireNonNull(inputStream));
                String pathStr = path.toString();
                DynamicTexture tex = new DynamicTexture(() -> pathStr, image);
                Dimension dim = new Dimension(image.getWidth(), image.getHeight());
                Tuple result = new Tuple((Object)tex, (Object)dim);
                this.modIconCache.put(cacheKey, (Tuple<DynamicTexture, Dimension>)result);
                tuple = result;
                if (inputStream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    LOGGER.warn("Failed to load icon for mod {}: {}", (Object)iconSource.getModId(), (Object)t.getMessage());
                    return null;
                }
            }
            inputStream.close();
        }
        return tuple;
    }

    private Path findIconPath(ModContainer iconSource, String iconPath) {
        try {
            IModFile modFile;
            block23: {
                modFile = iconSource.getModInfo().getOwningFile().getFile();
                try {
                    Method getFilePath = modFile.getClass().getMethod("getFilePath", new Class[0]);
                    Object result = getFilePath.invoke((Object)modFile, new Object[0]);
                    if (!(result instanceof Path)) break block23;
                    Path jarPath = (Path)result;
                    if (Files.isRegularFile(jarPath, new LinkOption[0]) && jarPath.toString().endsWith(".jar")) {
                        try {
                            FileSystem fs;
                            URI jarUri = URI.create("jar:" + String.valueOf(jarPath.toUri()));
                            try {
                                fs = FileSystems.getFileSystem(jarUri);
                            }
                            catch (FileSystemNotFoundException e) {
                                fs = FileSystems.newFileSystem(jarUri, Collections.emptyMap());
                            }
                            Path iconInJar = fs.getPath(iconPath, new String[0]);
                            if (Files.exists(iconInJar, new LinkOption[0])) {
                                return iconInJar;
                            }
                            break block23;
                        }
                        catch (Throwable t) {
                            LOGGER.warn("findIconPath: JAR filesystem failed: {}", (Object)t.getMessage());
                        }
                        break block23;
                    }
                    if (Files.isDirectory(jarPath, new LinkOption[0])) {
                        Path iconInResources;
                        String resourcePath;
                        Path resourcesDir;
                        Path iconInResources2;
                        Path resourcesDir2;
                        Path iconInDir = jarPath.resolve(iconPath);
                        if (Files.exists(iconInDir, new LinkOption[0])) {
                            return iconInDir;
                        }
                        Path parent = jarPath.getParent();
                        if (parent != null && parent.getFileName() != null && parent.getFileName().toString().equals("java") && Files.isDirectory(resourcesDir2 = parent.getParent().resolve("resources").resolve("main"), new LinkOption[0]) && Files.exists(iconInResources2 = resourcesDir2.resolve(iconPath), new LinkOption[0])) {
                            return iconInResources2;
                        }
                        String pathStr = jarPath.toString().replace("\\", "/");
                        if (pathStr.contains("/build/classes/java/main") && Files.isDirectory(resourcesDir = Path.of(resourcePath = pathStr.replace("/build/classes/java/main", "/build/resources/main"), new String[0]), new LinkOption[0]) && Files.exists(iconInResources = resourcesDir.resolve(iconPath), new LinkOption[0])) {
                            return iconInResources;
                        }
                    }
                }
                catch (NoSuchMethodException getFilePath) {
                }
                catch (Throwable t) {
                    LOGGER.warn("findIconPath: getFilePath approach failed: {}", (Object)t.getMessage());
                }
            }
            try {
                Path path;
                Method m = modFile.getClass().getMethod("findResource", String[].class);
                String[] parts = iconPath.split("/");
                Object result = m.invoke((Object)modFile, new Object[]{parts});
                if (result instanceof Path && Files.exists(path = (Path)result, new LinkOption[0])) {
                    return path;
                }
            }
            catch (NoSuchMethodException m) {
            }
            catch (Throwable t) {
                LOGGER.warn("findIconPath: findResource(String[]) failed: {}", (Object)t.getMessage());
            }
            try {
                Path path;
                String[] rest;
                String[] parts;
                String first;
                Method getPath;
                Object result;
                Method getSecureJar = modFile.getClass().getMethod("getSecureJar", new Class[0]);
                Object secureJar = getSecureJar.invoke((Object)modFile, new Object[0]);
                if (secureJar != null && (result = (getPath = secureJar.getClass().getMethod("getPath", String.class, String[].class)).invoke(secureJar, first = (parts = iconPath.split("/")).length > 0 ? parts[0] : "", rest = parts.length > 1 ? Arrays.copyOfRange(parts, 1, parts.length) : new String[]{})) instanceof Path && Files.exists(path = (Path)result, new LinkOption[0])) {
                    return path;
                }
            }
            catch (NoSuchMethodException getSecureJar) {
            }
            catch (Throwable t) {
                LOGGER.warn("findIconPath: getSecureJar approach failed: {}", (Object)t.getMessage());
            }
        }
        catch (Throwable t) {
            LOGGER.warn("findIconPath: Error finding icon path for mod {}: {}", (Object)iconSource.getModId(), (Object)t.getMessage());
        }
        return null;
    }

    @Override
    public void close() {
        for (Tuple<DynamicTexture, Dimension> tex : this.modIconCache.values()) {
            try {
                ((DynamicTexture)tex.getA()).close();
            }
            catch (Throwable throwable) {}
        }
        this.modIconCache.clear();
    }

    public Tuple<DynamicTexture, Dimension> getCachedModIcon(String key) {
        return this.modIconCache.get(key);
    }
}

