/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.mod_menu.event;

import com.mojang.blaze3d.platform.InputConstants;
import com.terraformersmc.mod_menu.ModMenu;
import com.terraformersmc.mod_menu.config.ModMenuConfig;
import com.terraformersmc.mod_menu.gui.ModsScreen;
import com.terraformersmc.mod_menu.gui.widget.ModMenuButtonWidget;
import com.terraformersmc.mod_menu.gui.widget.UpdateCheckerTexturedButtonWidget;
import com.terraformersmc.mod_menu.util.CompatUtils;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.PlainTextButton;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.Identifier;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;

@EventBusSubscriber(modid="mod_menu", value={Dist.CLIENT})
public class ModMenuEventHandler {
    public static final Identifier MODS_BUTTON_TEXTURE = Identifier.parse((String)"mod_menu:textures/gui/mods_button.png");
    public static KeyMapping MENU_KEY_BIND;

    @SubscribeEvent
    public static void onScreenInit(ScreenEvent.Init.Post event) {
        Screen screen = event.getScreen();
        if (screen instanceof TitleScreen) {
            for (int i = 0; i < screen.renderables.size(); ++i) {
                Button b;
                Object renderable = screen.renderables.get(i);
                if (!(renderable instanceof Button) || !ModMenuEventHandler.buttonHasText((LayoutElement)(b = (Button)renderable), "menu.feedback") && !ModMenuEventHandler.buttonHasText((LayoutElement)b, "menu.sendFeedback") && !ModMenuEventHandler.buttonHasText((LayoutElement)b, "menu.reportBugs")) continue;
                try {
                    b.visible = false;
                    b.active = false;
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (((Boolean)ModMenu.getConfig().MODIFY_TITLE_SCREEN.get()).booleanValue() && !CompatUtils.isCustomMenu()) {
                ModMenuEventHandler.removeModsButton(screen);
                ModMenuEventHandler.afterTitleScreenInit(screen);
            }
        }
    }

    private static void removeModsButton(Screen screen) {
        Object renderable;
        int i;
        for (i = 0; i < screen.renderables.size(); ++i) {
            Button button;
            renderable = screen.renderables.get(i);
            if (!(renderable instanceof Button) || !ModMenuEventHandler.buttonHasText((LayoutElement)(button = (Button)renderable), "fml.menu.mods")) continue;
            try {
                int fullWidth = 200;
                int x = screen.width / 2 - fullWidth / 2;
                ModMenuEventHandler.set(screen, i, (AbstractWidget)new ModMenuButtonWidget(x, button.getY(), fullWidth, button.getHeight(), ModMenu.createModsButtonText(true), screen));
                continue;
            }
            catch (IndexOutOfBoundsException ignored) {
                button.setMessage(ModMenu.createModsButtonText(true));
            }
        }
        for (i = 0; i < screen.renderables.size(); ++i) {
            renderable = screen.renderables.get(i);
            if (!(renderable instanceof Button)) continue;
            Button b = (Button)renderable;
            if (ModMenuEventHandler.buttonHasText((LayoutElement)b, "menu.feedback") || ModMenuEventHandler.buttonHasText((LayoutElement)b, "menu.sendFeedback") || ModMenuEventHandler.buttonHasText((LayoutElement)b, "menu.reportBugs")) {
                try {
                    b.visible = false;
                    b.active = false;
                }
                catch (Exception ignored) {
                    // empty catch block
                }
            }
            try {
                String btnText = b.getMessage().getString();
                if (btnText == null || !btnText.contains("Create Test World")) continue;
                b.visible = false;
                b.active = false;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void afterTitleScreenInit(Screen screen) {
        List buttons = screen.renderables;
        int modsButtonIndex = -1;
        int spacing = 12;
        int buttonsY = screen.height / 4 + 48;
        boolean replacedRealmButton = false;
        for (int i = 0; i < buttons.size(); ++i) {
            Button button2;
            Renderable widget = (Renderable)buttons.get(i);
            if (!(widget instanceof Button) || (button2 = (Button)widget) instanceof PlainTextButton) continue;
            ModMenuEventHandler.shiftButtons((LayoutElement)button2, replacedRealmButton, 12 + (replacedRealmButton ? -12 : 8));
            boolean isRealmsButton = ModMenuEventHandler.buttonHasText((LayoutElement)button2, "menu.online");
            if (isRealmsButton) {
                replacedRealmButton = true;
            }
            if (ModMenu.getConfig().MODS_BUTTON_STYLE.get() == ModMenuConfig.TitleMenuButtonStyle.CLASSIC && button2.visible) {
                ModMenuEventHandler.shiftButtons((LayoutElement)button2, modsButtonIndex == -1, 12);
                if (modsButtonIndex == -1) {
                    buttonsY = button2.getY();
                }
            }
            if (isRealmsButton) {
                if (ModMenu.getConfig().MODS_BUTTON_STYLE.get() == ModMenuConfig.TitleMenuButtonStyle.REPLACE_REALMS) {
                    ModMenuEventHandler.set(screen, i, (AbstractWidget)new ModMenuButtonWidget(button2.getX(), button2.getY(), button2.getWidth(), button2.getHeight(), ModMenu.createModsButtonText(true), screen));
                } else {
                    if (ModMenu.getConfig().MODS_BUTTON_STYLE.get() == ModMenuConfig.TitleMenuButtonStyle.SHRINK) {
                        button2.setWidth(98);
                    }
                    if (ModMenu.getConfig().MODS_BUTTON_STYLE.get() == ModMenuConfig.TitleMenuButtonStyle.SHRINK_LEFT) {
                        button2.setWidth(98);
                        button2.setX(screen.width / 2 + 2);
                    }
                    modsButtonIndex = i + 1;
                    if (button2.visible) {
                        buttonsY = button2.getY();
                    }
                }
            }
            if (modsButtonIndex != -1 || !ModMenuEventHandler.buttonHasText((LayoutElement)button2, "fml.menu.mods")) continue;
            if (ModMenu.getConfig().MODS_BUTTON_STYLE.get() != ModMenuConfig.TitleMenuButtonStyle.CLASSIC) {
                buttonsY = button2.getY();
            }
            modsButtonIndex = i;
        }
        if (modsButtonIndex != -1) {
            boolean hasModMenuButton = buttons.stream().anyMatch(r -> r instanceof ModMenuButtonWidget);
            if (hasModMenuButton) {
                return;
            }
            if (ModMenu.getConfig().MODS_BUTTON_STYLE.get() == ModMenuConfig.TitleMenuButtonStyle.CLASSIC) {
                ModMenuEventHandler.add(screen, modsButtonIndex, (AbstractWidget)new ModMenuButtonWidget(screen.width / 2 - 100, buttonsY + 12, 200, 20, ModMenu.createModsButtonText(true), screen));
            } else if (ModMenu.getConfig().MODS_BUTTON_STYLE.get() == ModMenuConfig.TitleMenuButtonStyle.SHRINK) {
                ModMenuEventHandler.add(screen, modsButtonIndex, (AbstractWidget)new ModMenuButtonWidget(screen.width / 2 + 2, buttonsY, 98, 20, ModMenu.createModsButtonText(true), screen));
            } else if (ModMenu.getConfig().MODS_BUTTON_STYLE.get() == ModMenuConfig.TitleMenuButtonStyle.SHRINK_LEFT) {
                ModMenuEventHandler.add(screen, modsButtonIndex, (AbstractWidget)new ModMenuButtonWidget(screen.width / 2 - 100, buttonsY, 98, 20, ModMenu.createModsButtonText(true), screen));
            } else if (ModMenu.getConfig().MODS_BUTTON_STYLE.get() == ModMenuConfig.TitleMenuButtonStyle.ICON) {
                ModMenuEventHandler.add(screen, modsButtonIndex, (AbstractWidget)new UpdateCheckerTexturedButtonWidget(screen.width / 2 + 104, buttonsY, 20, 20, 0, 0, 20, MODS_BUTTON_TEXTURE, 32, 64, button -> Minecraft.getInstance().setScreen((Screen)new ModsScreen(screen)), ModMenu.createModsButtonText(true)));
            }
        }
    }

    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Post event) {
        if (MENU_KEY_BIND != null) {
            while (MENU_KEY_BIND.consumeClick()) {
                Minecraft.getInstance().setScreen((Screen)new ModsScreen(Minecraft.getInstance().screen));
            }
        }
    }

    public static boolean buttonHasText(LayoutElement element, String ... translationKeys) {
        if (element instanceof Button) {
            Button button = (Button)element;
            Component component = button.getMessage();
            ComponentContents textContent = component.getContents();
            if (textContent instanceof TranslatableContents) {
                String key = ((TranslatableContents)textContent).getKey();
                if (Arrays.stream(translationKeys).anyMatch(s -> key.equals(s))) {
                    return true;
                }
                if (key.equals("menu.mods") || key.equals("menu.modlist") || key.equals("menu.mod_menu")) {
                    return true;
                }
            }
            try {
                String rendered = component.getString();
                if (rendered != null && rendered.toLowerCase().contains("mods")) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
        return false;
    }

    public static void shiftButtons(LayoutElement element, boolean shiftUp, int spacing) {
        AbstractWidget button;
        if (shiftUp) {
            element.setY(element.getY() - spacing / 2);
        } else if (!(element instanceof AbstractWidget) || !(button = (AbstractWidget)element).getMessage().equals((Object)Component.translatable((String)"title.credits"))) {
            element.setY(element.getY() + spacing / 2);
        }
    }

    public static AbstractWidget set(Screen screen, int index, AbstractWidget element) {
        int drawableIndex = ModMenuEventHandler.translateIndex(screen.renderables, index, false);
        screen.renderables.set(drawableIndex, element);
        int selectableIndex = ModMenuEventHandler.translateIndex(screen.narratables, index, false);
        screen.narratables.set(selectableIndex, element);
        int childIndex = ModMenuEventHandler.translateIndex(screen.children, index, false);
        return screen.children.set(childIndex, element);
    }

    public static void add(Screen screen, int index, AbstractWidget element) {
        int duplicateIndex = screen.renderables.indexOf(element);
        if (duplicateIndex >= 0) {
            screen.renderables.remove(element);
            screen.narratables.remove(element);
            screen.children.remove(element);
            if (duplicateIndex <= ModMenuEventHandler.translateIndex(screen.renderables, index, true)) {
                --index;
            }
        }
        int drawableIndex = ModMenuEventHandler.translateIndex(screen.renderables, index, true);
        screen.renderables.add(drawableIndex, element);
        int selectableIndex = ModMenuEventHandler.translateIndex(screen.narratables, index, true);
        screen.narratables.add(selectableIndex, element);
        int childIndex = ModMenuEventHandler.translateIndex(screen.children, index, true);
        screen.children.add(childIndex, element);
    }

    private static int translateIndex(List<?> list, int index, boolean allowAfter) {
        int remaining = index;
        int max = list.size();
        for (int i = 0; i < max; ++i) {
            if (!(list.get(i) instanceof AbstractWidget)) continue;
            if (remaining == 0) {
                return i;
            }
            --remaining;
        }
        if (allowAfter && remaining == 0) {
            return list.size();
        }
        throw new IndexOutOfBoundsException(String.format("Index: %d, Size: %d", index, index - remaining));
    }

    @EventBusSubscriber(modid="mod_menu", value={Dist.CLIENT})
    public static class ModBusEvents {
        @SubscribeEvent
        public static void registerKeyBindings(RegisterKeyMappingsEvent event) {
            try {
                Class<KeyMapping> kmClass = KeyMapping.class;
                KeyMapping key = null;
                try {
                    key = (KeyMapping)kmClass.getConstructor(String.class, Integer.TYPE, String.class).newInstance("key.modmenu.open_menu", -1, "category.modmenu.name");
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                if (key == null) {
                    try {
                        key = (KeyMapping)kmClass.getConstructor(String.class, InputConstants.Type.class, Integer.TYPE, String.class).newInstance("key.modmenu.open_menu", InputConstants.Type.KEYSYM, -1, "category.modmenu.name");
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                }
                if ((MENU_KEY_BIND = key) != null) {
                    event.register(MENU_KEY_BIND);
                } else {
                    ModMenu.LOGGER.warn("Could not construct KeyMapping for Mod Menu; keybind disabled on this environment.");
                }
            }
            catch (Throwable t) {
                ModMenu.LOGGER.warn("Failed to register Mod Menu keybinding (reflection attempt)", t);
            }
        }
    }
}

