/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.mod_menu.gui.widget;

import com.terraformersmc.mod_menu.gui.widget.LegacyTexturedButtonWidget;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;

public class BadgeToogleButton
extends LegacyTexturedButtonWidget {
    private static final Identifier BADGE_TOGGLE_TEXTURE = Identifier.parse((String)"mod_menu:textures/gui/badge_toggle_button.png");
    private boolean hasBadge;

    public BadgeToogleButton(int x, int y, int width, int height, int u, int v, int hoveredVOffset, Button.OnPress pressAction, Component message, boolean hasBadge) {
        super(x, y, width, height, u, v, hoveredVOffset, BADGE_TOGGLE_TEXTURE, 22, 22, pressAction, message);
        this.hasBadge = hasBadge;
    }

    @Override
    public void renderContents(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        int v = this.v;
        int u = this.u;
        if (!this.isActive()) {
            v += this.hoveredVOffset * 2;
        } else if (this.isHovered()) {
            v += this.hoveredVOffset;
        }
        if (this.hasBadge) {
            u += 11;
        }
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, this.texture, this.getX(), this.getY(), (float)u, (float)v, this.width, this.height, this.textureWidth, this.textureHeight);
    }

    public void toggle() {
        this.hasBadge = !this.hasBadge;
    }

    public static Builder badgeButtonBuilder(Component message, Button.OnPress onPress, boolean hasBadge) {
        return new Builder(message, onPress, hasBadge);
    }

    public static class Builder {
        private final Component message;
        private final Button.OnPress onPress;
        private int x;
        private int y;
        private boolean hasBadge;
        private int width;
        private int height;
        private int u;
        private int v;
        private int hoveredVOffset;

        public Builder(Component message, Button.OnPress onPress, boolean hasBadge) {
            this.message = message;
            this.onPress = onPress;
            this.hasBadge = hasBadge;
        }

        public Builder position(int x, int y) {
            this.x = x;
            this.y = y;
            return this;
        }

        public Builder size(int width, int height) {
            this.width = width;
            this.height = height;
            return this;
        }

        public Builder uv(int u, int v, int hoveredVOffset) {
            this.u = u;
            this.v = v;
            this.hoveredVOffset = hoveredVOffset;
            return this;
        }

        public BadgeToogleButton build() {
            return new BadgeToogleButton(this.x, this.y, this.width, this.height, this.u, this.v, this.hoveredVOffset, this.onPress, this.message, this.hasBadge);
        }
    }
}

