/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.mod_menu.mixin;

import com.google.common.collect.Lists;
import com.terraformersmc.mod_menu.ModMenu;
import com.terraformersmc.mod_menu.config.ModMenuConfig;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.client.resources.language.I18n;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.internal.BrandingControl;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BrandingControl.class})
public abstract class MixinBrandingControl {
    @Shadow
    private static List<String> brandings;
    @Shadow
    private static List<String> brandingsNoMC;

    @Shadow
    private static void computeBranding() {
    }

    @Inject(method={"forEachLine"}, at={@At(value="HEAD")}, cancellable=true)
    private static void replaceBranding(boolean includeMC, boolean reverse, BiConsumer<Integer, String> lineConsumer, CallbackInfo ci) {
        if (((Boolean)ModMenu.getConfig().MODIFY_TITLE_SCREEN.get()).booleanValue()) {
            List<String> brandings = MixinBrandingControl.getBrandings(includeMC, reverse);
            String neoForge = brandings.getFirst();
            if (((ModMenuConfig.ModCountLocation)((Object)ModMenu.getConfig().MOD_COUNT_LOCATION.get())).isOnTitleScreen()) {
                Object replacementKey;
                String count = ModMenu.getDisplayedModCount();
                String specificKey = "mod_menu.mods." + count;
                Object object = replacementKey = I18n.exists((String)specificKey) ? specificKey : "mod_menu.mods.n";
                if (((Boolean)ModMenu.getConfig().EASTER_EGGS.get()).booleanValue() && I18n.exists((String)(specificKey + ".secret"))) {
                    replacementKey = specificKey + ".secret";
                }
                neoForge = neoForge.replace(I18n.get((String)"fml.menu.branding", (Object[])new Object[]{"", ModList.get().size()}), I18n.get((String)replacementKey, (Object[])new Object[]{count}));
            } else {
                neoForge = neoForge.replace(I18n.get((String)"fml.menu.branding", (Object[])new Object[]{"", ModList.get().size()}), I18n.get((String)"menu.modded", (Object[])new Object[0]));
            }
            lineConsumer.accept(0, neoForge);
            lineConsumer.accept(1, brandings.get(1));
            ci.cancel();
        }
    }

    @Unique
    private static List<String> getBrandings(boolean includeMC, boolean reverse) {
        MixinBrandingControl.computeBranding();
        if (includeMC) {
            return reverse ? Lists.reverse(brandings) : brandings;
        }
        return reverse ? Lists.reverse(brandingsNoMC) : brandingsNoMC;
    }
}

