/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.mod_menu.util.mod;

import com.terraformersmc.mod_menu.ModMenu;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.network.chat.Component;

public class ModBadge {
    private final String id;
    private final Component component;
    private final int fillColor;
    private final int outlineColor;
    private final int textColor;
    public static ModBadge LIBRARY = new ModBadge("library", "mod_menu.badge.library", -15698860, -16172759);
    public static Map<String, ModBadge> DEFAULT_BADGES = Map.of("library", LIBRARY, "client", new ModBadge("client", "mod_menu.badge.clientsideOnly", -13939844, -15848875), "deprecated", new ModBadge("deprecated", "mod_menu.badge.deprecated", -8121306, -11334633), "sinytra_fabric", new ModBadge("sinytra_fabric", "mod_menu.badge.fabric", -3689333, -8884904), "sinytra_neoforge", new ModBadge("sinytra_neoforge", "mod_menu.badge.neoforge", -1668041, -6009289), "modpack", new ModBadge("modpack", "mod_menu.badge.modpack", -8770692, -11465388), "minecraft", new ModBadge("minecraft", "mod_menu.badge.minecraft", -9474966, -13553617));
    public static Map<String, ModBadge> CUSTOM_BADGES = new LinkedHashMap<String, ModBadge>();
    public static List<Map<String, ModBadge>> BADGES = List.of(DEFAULT_BADGES, CUSTOM_BADGES);

    public ModBadge(String id, String displayName, int outlineColor, int fillColor) {
        this(id, displayName, outlineColor, fillColor, 0xCACACA);
    }

    public ModBadge(String id, String displayName, int outlineColor, int fillColor, int textColor) {
        this.id = id;
        this.component = Component.translatable((String)displayName);
        this.fillColor = fillColor;
        this.outlineColor = outlineColor;
        this.textColor = textColor;
    }

    public String getId() {
        return this.id;
    }

    public Component getComponent() {
        return this.component;
    }

    public int getOutlineColor() {
        return this.outlineColor;
    }

    public int getFillColor() {
        return this.fillColor;
    }

    public int getTextColor() {
        return this.textColor;
    }

    public static Set<ModBadge> convert(Set<String> badgeKeys, String modId) {
        return badgeKeys.stream().map(key -> {
            if (DEFAULT_BADGES.containsKey(key)) {
                return DEFAULT_BADGES.get(key);
            }
            if (CUSTOM_BADGES.containsKey(key)) {
                return CUSTOM_BADGES.get(key);
            }
            ModMenu.LOGGER.warn("Skipping unknown badge key '{}' specified by mod '{}'", key, (Object)modId);
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toCollection(LinkedHashSet::new));
    }
}

