/*
 * Decompiled with CFR 0.152.
 */
package xyz.faewulf.diversity;

import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.commands.CommandSourceStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import xyz.faewulf.diversity.CommonClass;
import xyz.faewulf.diversity.Constants;
import xyz.faewulf.diversity.command.emote;
import xyz.faewulf.diversity.event_handler.RegsitryDone;
import xyz.faewulf.diversity.platform.RegisterEnchantment;
import xyz.faewulf.lib.api.v1.config.ConfigScreenHelper;
import xyz.faewulf.lib.util.config.infoScreen.ModInfoScreen;

@Mod(value="diversity")
public class Diversity {
    public Diversity() {
        Constants.LOG.info("Loading");
        this.loadCommand();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.register(RegsitryDone.class);
        RegisterEnchantment.ENCHANTMENTS.register(modEventBus);
        RegisterEnchantment.init();
        CommonClass.init();
        Constants.LOG.info("Init done");
    }

    private void loadCommand() {
        Constants.LOG.info("Register commands...");
        MinecraftForge.EVENT_BUS.addListener(this::onServerStarting);
    }

    private void onServerStarting(RegisterCommandsEvent event) {
        emote.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ClientEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            ModLoadingContext.get().registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((client, parent) -> {
                ModInfoScreen modInfoScreen = (ModInfoScreen)ConfigScreenHelper.getConfigScreen((Screen)parent, (String)"diversity");
                modInfoScreen.setUrls(null, "https://faewulf.xyz/diversity", null, "https://github.com/FaeWulf/Diversity");
                return modInfoScreen;
            }));
        }
    }
}

