/*
 * Decompiled with CFR 0.152.
 */
package xyz.faewulf.diversity.mixin.general.bonemealCoral;

import java.util.Iterator;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseCoralPlantTypeBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CoralPlantBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.CoralClawFeature;
import net.minecraft.world.level.levelgen.feature.CoralMushroomFeature;
import net.minecraft.world.level.levelgen.feature.CoralTreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.material.MapColor;
import org.spongepowered.asm.mixin.Mixin;
import xyz.faewulf.diversity.inter.ICustomBonemealable;
import xyz.faewulf.diversity.mixin.general.bonemealCoral.CoralFeatureInvoker;
import xyz.faewulf.diversity.util.config.ModConfigs;
import xyz.faewulf.lib.util.Compare;

@Mixin(value={CoralPlantBlock.class})
public class CoralMixin
implements ICustomBonemealable {
    @Override
    public boolean Diversity$isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        if (!ModConfigs.bonemeal_coral_fan) {
            return false;
        }
        Holder currentBiome = level.m_204166_(pos);
        return !Compare.isHasTag((Block)state.m_60734_(), (String)"diversity:bonemeal_blacklist") && (Boolean)state.m_61143_((Property)BaseCoralPlantTypeBlock.f_49158_) != false && level.m_6425_(pos.m_7494_()).m_205070_(FluidTags.f_13131_) && currentBiome.m_203656_(BiomeTags.f_215804_);
    }

    @Override
    public boolean Diversity$isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return (double)level.f_46441_.m_188501_() < 0.12;
    }

    @Override
    public void Diversity$performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        Holder coral_block;
        CoralTreeFeature coral = switch (level.f_46441_.m_188503_(3)) {
            case 0 -> new CoralTreeFeature(NoneFeatureConfiguration.f_67815_);
            case 1 -> new CoralClawFeature(NoneFeatureConfiguration.f_67815_);
            default -> new CoralMushroomFeature(NoneFeatureConfiguration.f_67815_);
        };
        MapColor color = state.m_284242_((BlockGetter)level, pos);
        BlockState coralBlockMatchedColor = state;
        Optional coralBlocksRegistry = level.m_9598_().m_255025_(Registries.f_256747_).m_254901_(BlockTags.f_13051_);
        if (!coralBlocksRegistry.isPresent()) {
            return;
        }
        HolderSet.Named coralBlocks = (HolderSet.Named)coralBlocksRegistry.get();
        Iterator iterator = coralBlocks.iterator();
        while (iterator.hasNext() && (coralBlockMatchedColor = ((Block)(coral_block = (Holder)iterator.next()).m_203334_()).m_49966_()).m_284242_((BlockGetter)level, pos) != color) {
        }
        level.m_7731_(pos, Blocks.f_49990_.m_49966_(), 4);
        if (!((CoralFeatureInvoker)coral).generateCoral((LevelAccessor)level, level.f_46441_, pos, coralBlockMatchedColor)) {
            level.m_7731_(pos, state, 3);
        }
        level.m_8767_((ParticleOptions)ParticleTypes.f_123748_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 7, 0.3, 0.3, 0.3, 0.1);
    }
}

