/*
 * Decompiled with CFR 0.152.
 */
package xyz.faewulf.diversity.event;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BrushableBlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import xyz.faewulf.diversity.inter.ICustomBrushableBlockEntity;
import xyz.faewulf.diversity.util.config.ModConfigs;

public class putItemIntoBrushableBlocks {
    private static final List<Item> blackListItems = new ArrayList<Item>(){};

    public static InteractionResult run(Level world, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (!ModConfigs.usable_suspicious_block) {
            return InteractionResult.PASS;
        }
        if (hand.equals((Object)InteractionHand.MAIN_HAND) && player.isShiftKeyDown() && hitResult.getType().equals((Object)HitResult.Type.BLOCK)) {
            BlockEntity checkBlock = world.getBlockEntity(hitResult.getBlockPos());
            if (checkBlock == null) {
                return InteractionResult.PASS;
            }
            if (checkBlock instanceof BrushableBlockEntity) {
                BrushableBlockEntity brushableBlockEntity = (BrushableBlockEntity)checkBlock;
                ItemStack mainHand = player.getItemInHand(InteractionHand.MAIN_HAND);
                if (mainHand.isEmpty() || blackListItems.contains(mainHand.getItem())) {
                    return InteractionResult.PASS;
                }
                if (!brushableBlockEntity.getItem().isEmpty() || brushableBlockEntity.getItem().getItem() != Items.AIR) {
                    return InteractionResult.PASS;
                }
                ItemStack treasure = mainHand.copyWithCount(1);
                ((ICustomBrushableBlockEntity)brushableBlockEntity).diversity_Multiloader$setItem(treasure);
                player.swing(hand, true);
                mainHand.consume(1, (LivingEntity)player);
                world.playSound(null, player.blockPosition(), SoundEvents.SAND_PLACE, SoundSource.PLAYERS, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }
}

