/*
 * Decompiled with CFR 0.152.
 */
package xyz.faewulf.diversity.event;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CocoaBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import xyz.faewulf.diversity.util.config.ModConfigs;
import xyz.faewulf.lib.util.Compare;

public class rightClickCropBlocks {
    public static InteractionResult run(Level level, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (ModConfigs.hoe_harvest_crop == ModConfigs.allowHarvestType.DISABLE) {
            return InteractionResult.PASS;
        }
        if (hand == InteractionHand.MAIN_HAND && hitResult.getType().equals((Object)HitResult.Type.BLOCK) && level instanceof ServerLevel) {
            boolean usingHoe;
            ServerLevel serverLevel = (ServerLevel)level;
            ItemStack mainHandItem = player.getItemInHand(InteractionHand.MAIN_HAND);
            BlockPos targetBlock = hitResult.getBlockPos();
            BlockState blockState = level.getBlockState(targetBlock);
            boolean bl = usingHoe = Compare.isHasTag((Item)mainHandItem.getItem(), (String)"diversity:crop_harvester") && rightClickCropBlocks.enableRadius(blockState);
            if (ModConfigs.hoe_harvest_crop == ModConfigs.allowHarvestType.HAND_ONLY) {
                usingHoe = false;
            }
            if (ModConfigs.hoe_harvest_crop == ModConfigs.allowHarvestType.HOE_ONLY && !usingHoe) {
                return InteractionResult.PASS;
            }
            int radius = 1;
            if (usingHoe && Compare.isHasTag((Item)mainHandItem.getItem(), (String)"diversity:tier2_hoe")) {
                radius = 2;
            }
            if (!usingHoe) {
                radius = 0;
            }
            boolean shouldConsumeAction = false;
            if (rightClickCropBlocks.isCrop(blockState)) {
                for (int dx = -radius; dx <= radius; ++dx) {
                    for (int dz = -radius; dz <= radius; ++dz) {
                        int maxAge;
                        int age;
                        BlockPos currentBlock = hitResult.getBlockPos().offset(dx, 0, dz);
                        BlockState currentBlockState = level.getBlockState(currentBlock);
                        if (!rightClickCropBlocks.isCrop(currentBlockState) || (age = rightClickCropBlocks.getAge(currentBlockState)) != (maxAge = rightClickCropBlocks.getMaxAge(currentBlockState))) continue;
                        Vec3 center = currentBlock.getCenter();
                        List itemStacks = Block.getDrops((BlockState)currentBlockState, (ServerLevel)serverLevel, (BlockPos)currentBlock, null, (Entity)player, (ItemStack)mainHandItem);
                        if (ModConfigs.xp_crops) {
                            ExperienceOrb.award((ServerLevel)serverLevel, (Vec3)center, (int)level.random.nextIntBetweenInclusive(0, 1));
                        }
                        boolean alreadyTakeSeed = false;
                        for (ItemStack itemStack : itemStacks) {
                            if (rightClickCropBlocks.shouldNotDropSeed(currentBlockState.getBlock(), itemStack.getItem())) {
                                itemStack.setCount(0);
                            }
                            if (!alreadyTakeSeed && rightClickCropBlocks.isSeed(itemStack.getItem(), currentBlockState)) {
                                alreadyTakeSeed = true;
                                if (rightClickCropBlocks.shouldTakeSeed(currentBlockState.getBlock())) {
                                    itemStack.shrink(1);
                                }
                            }
                            if (itemStack.getCount() == 0) continue;
                            ItemEntity item = new ItemEntity((Level)serverLevel, center.x, center.y, center.z, itemStack);
                            item.setDefaultPickUpDelay();
                            serverLevel.addFreshEntity((Entity)item);
                        }
                        if (!alreadyTakeSeed) {
                            for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
                                ItemStack stack = player.getInventory().getItem(i);
                                if (stack.isEmpty() || !rightClickCropBlocks.isSeed(stack.getItem(), currentBlockState)) continue;
                                alreadyTakeSeed = true;
                                if (!rightClickCropBlocks.shouldTakeSeed(currentBlockState.getBlock())) break;
                                stack.shrink(1);
                                break;
                            }
                        }
                        if (alreadyTakeSeed) {
                            rightClickCropBlocks.replaceCrop(serverLevel, currentBlockState, currentBlock);
                        } else {
                            rightClickCropBlocks.replaceCrop(serverLevel, Blocks.AIR.defaultBlockState(), currentBlock);
                        }
                        serverLevel.playSound(null, targetBlock, currentBlockState.getSoundType().getBreakSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
                        serverLevel.sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, currentBlockState), center.x, center.y - (double)0.2f, center.z, 40, 0.25, 0.25, 0.25, 0.5);
                        player.causeFoodExhaustion(0.005f);
                        if (usingHoe) {
                            player.getItemInHand(hand).hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
                        }
                        shouldConsumeAction = true;
                    }
                }
                if (shouldConsumeAction) {
                    player.swing(hand, true);
                    return InteractionResult.CONSUME;
                }
            }
        }
        return InteractionResult.PASS;
    }

    private static boolean isCrop(BlockState blockState) {
        return blockState.getBlock() instanceof CropBlock || blockState.getBlock() instanceof NetherWartBlock || blockState.getBlock() instanceof CocoaBlock;
    }

    private static boolean enableRadius(BlockState blockState) {
        return blockState.getBlock() instanceof CropBlock || blockState.getBlock() instanceof NetherWartBlock;
    }

    private static boolean shouldTakeSeed(Block block) {
        return !Compare.isBlock((String)"farmersdelight:tomatoes", (Block)block);
    }

    private static boolean shouldNotDropSeed(Block block, Item item) {
        return Compare.isBlock((String)"farmersdelight:tomatoes", (Block)block) && Compare.isItem((String)"farmersdelight:tomato_seeds", (Item)item);
    }

    private static boolean isSeed(Item target, BlockState blockState) {
        BlockItem blockItem;
        if (Compare.isBlock((String)"farmersdelight:tomatoes", (Block)blockState.getBlock())) {
            return true;
        }
        return target instanceof BlockItem && (blockItem = (BlockItem)target).getBlock() == blockState.getBlock();
    }

    private static int getAge(BlockState blockState) {
        Block block = blockState.getBlock();
        if (block instanceof CropBlock) {
            CropBlock cropBlock = (CropBlock)block;
            return cropBlock.getAge(blockState);
        }
        if (blockState.getBlock() instanceof NetherWartBlock) {
            return (Integer)blockState.getValue((Property)BlockStateProperties.AGE_3);
        }
        if (blockState.getBlock() instanceof CocoaBlock) {
            return (Integer)blockState.getValue((Property)BlockStateProperties.AGE_2);
        }
        return -1;
    }

    private static int getMaxAge(BlockState blockState) {
        Block block = blockState.getBlock();
        if (block instanceof CropBlock) {
            CropBlock cropBlock = (CropBlock)block;
            return cropBlock.getMaxAge();
        }
        if (blockState.getBlock() instanceof NetherWartBlock) {
            return 3;
        }
        if (blockState.getBlock() instanceof CocoaBlock) {
            return 2;
        }
        return 0;
    }

    private static void replaceCrop(ServerLevel level, BlockState blockState, BlockPos blockPos) {
        BlockState result = blockState.getBlock().defaultBlockState();
        if (blockState.getBlock() instanceof CocoaBlock) {
            result = (BlockState)result.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)((Direction)blockState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)));
        }
        level.setBlock(blockPos, result, 3);
    }
}

