/*
 * Decompiled with CFR 0.152.
 */
package xyz.faewulf.diversity.feature.entity.fox;

import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import xyz.faewulf.diversity.inter.ICustomBrushableBlockEntity;
import xyz.faewulf.diversity.inter.entity.ICustomFoxEntity;
import xyz.faewulf.diversity.util.CustomLootTables;

public class BuryItemGoal
extends MoveToBlockGoal {
    private final Fox fox;
    private int timer = 0;
    private int type = 0;

    public BuryItemGoal(Fox fox, double speed, int range, int maxYDifference) {
        super((PathfinderMob)fox, speed, range, maxYDifference);
        this.fox = fox;
    }

    public boolean canUse() {
        return !this.fox.isSleeping() && super.canUse() && !this.fox.isBaby() && ((ICustomFoxEntity)this.fox).diversity_Multiloader$getBuryCoolDown() <= 0;
    }

    public void start() {
        this.timer = 0;
        this.type = 0;
        this.fox.setSitting(false);
        Block targetBlock = this.fox.level().getBlockState(this.blockPos.below()).getBlock();
        if (targetBlock == Blocks.SAND) {
            this.type = 1;
        }
        if (targetBlock == Blocks.GRAVEL) {
            this.type = 2;
        }
        super.start();
    }

    public double acceptedDistance() {
        return 2.0;
    }

    public void tick() {
        if (this.isReachedTarget()) {
            if (this.timer >= 80) {
                BlockState susBlock = this.type == 1 ? Blocks.SUSPICIOUS_SAND.defaultBlockState() : Blocks.SUSPICIOUS_GRAVEL.defaultBlockState();
                AtomicInteger multiplier = new AtomicInteger(1);
                this.fox.level().setBlockAndUpdate(this.blockPos.below(), susBlock);
                this.fox.level().gameEvent((Entity)this.fox, (Holder)GameEvent.BLOCK_CHANGE, this.blockPos.below());
                this.fox.level().getBlockEntity(this.blockPos.below(), BlockEntityType.BRUSHABLE_BLOCK).ifPresent(blockEntity -> {
                    ItemStack itemStack = this.fox.getMainHandItem();
                    if (itemStack.isEmpty()) {
                        blockEntity.setLootTable(CustomLootTables.FOX_BURY, this.fox.getRandom().nextLong());
                        multiplier.set(3);
                    } else {
                        ((ICustomBrushableBlockEntity)blockEntity).diversity_Multiloader$setItem(itemStack);
                        this.fox.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
                    }
                });
                if (this.type == 1) {
                    this.fox.playSound(SoundEvents.SAND_BREAK, 1.0f, 1.0f);
                } else {
                    this.fox.playSound(SoundEvents.GRAVEL_BREAK, 1.0f, 1.0f);
                }
                ((ICustomFoxEntity)this.fox).diversity_Multiloader$setBuryCoolDown(24000 * multiplier.get());
            } else {
                Level multiplier;
                if (this.timer % 10 == 0 && (multiplier = this.fox.level()) instanceof ServerLevel) {
                    ServerLevel serverWorld = (ServerLevel)multiplier;
                    BlockParticleOption blockStateParticleEffect = new BlockParticleOption(ParticleTypes.BLOCK, this.type == 1 ? Blocks.SAND.defaultBlockState() : Blocks.GRAVEL.defaultBlockState());
                    Vec3 particlePos = this.blockPos.getCenter();
                    serverWorld.sendParticles((ParticleOptions)blockStateParticleEffect, particlePos.x, particlePos.y - 0.4, particlePos.z, 10, 0.3, 0.1, 0.3, 1.0);
                    if (this.type == 1) {
                        this.fox.playSound(SoundEvents.SAND_HIT, 1.0f, 1.0f);
                    } else {
                        this.fox.playSound(SoundEvents.GRAVEL_HIT, 1.0f, 1.0f);
                    }
                }
                ++this.timer;
            }
        } else if (!this.isReachedTarget() && this.fox.getRandom().nextFloat() < 0.05f) {
            this.fox.playSound(SoundEvents.FOX_SNIFF, 1.0f, 1.0f);
        }
        super.tick();
    }

    public boolean shouldRecalculatePath() {
        return this.tryTicks % 100 == 0;
    }

    protected boolean isValidTarget(LevelReader world, @NotNull BlockPos pos) {
        BlockState blockState = world.getBlockState(pos);
        BlockState blockStateBelow = world.getBlockState(pos.below());
        if (blockState.isAir() && (blockStateBelow.is(Blocks.SAND) || blockStateBelow.is(Blocks.GRAVEL))) {
            this.blockPos = pos;
            return true;
        }
        return false;
    }
}

