/*
 * Decompiled with CFR 0.152.
 */
package xyz.faewulf.diversity.mixin.core.PseudoBlockEntity;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Display;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import xyz.faewulf.diversity.feature.entity.pseudoBlockEntity.PseudoBlockEntities;
import xyz.faewulf.diversity.feature.entity.pseudoBlockEntity.PseudoBlockEntity;
import xyz.faewulf.diversity.feature.entity.pseudoBlockEntity.PseudoBlockEntityBuilder;
import xyz.faewulf.lib.util.Compare;

@Mixin(value={Display.class})
public abstract class TextDisplayMixin
extends Entity
implements PseudoBlockEntity {
    @Unique
    private List<String> diversity_Multiloader$parent = new ArrayList<String>();
    @Unique
    private int diversity_Multiloader$tickDelay = 0;
    @Unique
    private String diversity_type;
    @Unique
    private Consumer<Display> diversity_Multiloader$blockTickFunction;
    @Unique
    private Function<Display, Boolean> diversity_Multiloader$discardWhenFunction;
    @Unique
    private List<String> diversity_Multiloader$parentTag = new ArrayList<String>();

    public TextDisplayMixin(EntityType<?> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Override
    public boolean diversity_Multiloader$isBlockEntityAlreadyExist() {
        BlockPos blockPos = this.blockPosition();
        AABB box = new AABB((double)((float)blockPos.getX() + 0.3f), (double)((float)blockPos.getY() + 0.3f), (double)((float)blockPos.getZ() + 0.3f), (double)((float)blockPos.getX() + 0.7f), (double)((float)blockPos.getY() + 0.7f), (double)((float)blockPos.getZ() + 0.7f));
        List entitiesWithinRadius = this.level().getEntitiesOfClass(Entity.class, box, entity -> entity.getType() == EntityType.TEXT_DISPLAY);
        return !entitiesWithinRadius.isEmpty() && entitiesWithinRadius.size() != 1;
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    private void addAdditionalSaveData(CompoundTag nbt, CallbackInfo ci) {
        if (this.diversity_type != null) {
            nbt.putString("diversity:pseudoType", this.diversity_type);
        }
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void readAdditionalSaveData(CompoundTag nbt, CallbackInfo ci) {
        if (nbt.contains("diversity:pseudoType", 8)) {
            this.diversity_type = nbt.getString("diversity:pseudoType");
            PseudoBlockEntityBuilder builder = PseudoBlockEntities.PseudoBlockEntityList.get(this.diversity_type);
            if (builder != null) {
                this.diversity_Multiloader$parent = new ArrayList<String>();
                for (Block block : builder.getParent()) {
                    this.diversity_Multiloader$parent.add(block.toString());
                }
                if (builder.getParentTag() != null) {
                    this.diversity_Multiloader$parentTag = List.of(builder.getParentTag());
                }
                this.diversity_Multiloader$blockTickFunction = builder.getBlockTickFunction();
                this.diversity_Multiloader$discardWhenFunction = builder.getDiscardWhenFunction();
            }
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void tickInject(CallbackInfo ci) {
        if (this.diversity_type == null || this.level().isClientSide) {
            return;
        }
        if (this.diversity_Multiloader$tickDelay < 20) {
            ++this.diversity_Multiloader$tickDelay;
            return;
        }
        this.diversity_Multiloader$tickDelay = 0;
        BlockPos pos = this.blockPosition();
        BlockState currentBlock = this.level().getBlockState(pos);
        boolean hasTagInList = false;
        for (String s : this.diversity_Multiloader$parentTag) {
            if (!Compare.isHasTag((Block)currentBlock.getBlock(), (String)s)) continue;
            hasTagInList = true;
        }
        boolean haveToDelete = true;
        if (this.diversity_Multiloader$parent.contains(currentBlock.getBlock().toString())) {
            haveToDelete = false;
        }
        if (haveToDelete && hasTagInList) {
            haveToDelete = false;
        }
        if (haveToDelete) {
            this.discard();
            return;
        }
        if (this.diversity_Multiloader$isBlockEntityAlreadyExist() || this.diversity_Multiloader$discardWhenFunction != null && this.diversity_Multiloader$discardWhenFunction.apply((Display)this).booleanValue()) {
            this.discard();
            return;
        }
        if (this.diversity_Multiloader$blockTickFunction != null) {
            this.diversity_Multiloader$blockTickFunction.accept((Display)this);
        }
    }

    @Override
    public void diversity_Multiloader$setBlockTickFunction(Consumer<Display> callback) {
        this.diversity_Multiloader$blockTickFunction = callback;
    }

    @Override
    public void diversity_Multiloader$setDiscardWhenFunction(Function<Display, Boolean> callback) {
        this.diversity_Multiloader$discardWhenFunction = callback;
    }

    @Override
    public void diversity_Multiloader$setParentBlockType(Block ... block) {
        this.diversity_Multiloader$parent = new ArrayList<String>();
        for (Block block1 : block) {
            this.diversity_Multiloader$parent.add(block1.toString());
        }
    }

    @Override
    public String diversity_Multiloader$getEntityType() {
        return this.diversity_type;
    }

    @Override
    public void diversity_Multiloader$setEntityType(String value) {
        this.diversity_type = value;
    }

    @Override
    public void diversity_Multiloader$setDelayTick(int value) {
        this.diversity_Multiloader$tickDelay = value;
    }

    @Override
    public List<String> diversity_Multiloader$getParentTag() {
        return this.diversity_Multiloader$parentTag;
    }

    @Override
    public void diversity_Multiloader$setParentTag(@NotNull String[] parentTag) {
        this.diversity_Multiloader$parentTag = List.of(parentTag);
    }
}

