/*
 * Decompiled with CFR 0.152.
 */
package xyz.faewulf.diversity.mixin.entity.featherOnBrush;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.animal.ShoulderRidingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import xyz.faewulf.diversity.inter.entity.ICustomParrotEntity;
import xyz.faewulf.diversity.util.config.ModConfigs;

@Mixin(value={Parrot.class})
public abstract class ParrotEntityMixin
extends ShoulderRidingEntity
implements VariantHolder<Parrot.Variant>,
FlyingAnimal,
ICustomParrotEntity {
    @Unique
    private int diversity_Multiloader$featherCoolDown = 0;

    protected ParrotEntityMixin(EntityType<? extends ShoulderRidingEntity> entityType, Level world) {
        super(entityType, world);
    }

    @Shadow
    public abstract boolean isBaby();

    @Inject(method={"mobInteract"}, at={@At(value="HEAD")}, cancellable=true)
    private void InjectInteractMod(Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        if (!ModConfigs.brushable_parrot_chicken) {
            return;
        }
        if (player.level().isClientSide || this.diversity_Multiloader$featherCoolDown > 0) {
            return;
        }
        if (this.isBaby() || !player.isShiftKeyDown() || player.getItemInHand(InteractionHand.MAIN_HAND).getItem() != Items.BRUSH) {
            return;
        }
        player.getItemInHand(InteractionHand.MAIN_HAND).hurtAndBreak(1, (LivingEntity)player, ParrotEntityMixin.getSlotForHand((InteractionHand)InteractionHand.MAIN_HAND));
        this.playSound(SoundEvents.ITEM_FRAME_REMOVE_ITEM, 0.8f, 1.0f);
        ItemStack drops = new ItemStack((ItemLike)Items.FEATHER);
        drops.setCount(this.random.nextIntBetweenInclusive(1, 2));
        this.spawnAtLocation((ServerLevel)player.level(), drops);
        player.swing(hand, true);
        this.diversity_Multiloader$featherCoolDown = 24000;
        cir.setReturnValue((Object)InteractionResult.SUCCESS);
        cir.cancel();
    }

    @Inject(method={"aiStep"}, at={@At(value="HEAD")})
    private void tickMovementMixin(CallbackInfo ci) {
        if (this.diversity_Multiloader$featherCoolDown > 0) {
            --this.diversity_Multiloader$featherCoolDown;
        }
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    private void addAdditionalSaveData(CompoundTag nbt, CallbackInfo ci) {
        nbt.putInt("diversity:featherCoolDown", this.diversity_Multiloader$featherCoolDown);
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void readAdditionalSaveData(CompoundTag nbt, CallbackInfo ci) {
        if (nbt.contains("diversity:featherCoolDown", 99)) {
            this.diversity_Multiloader$featherCoolDown = nbt.getInt("diversity:featherCoolDown");
        }
    }

    @Override
    public void diversity_Multiloader$setFeatherCoolDown(int value) {
        this.diversity_Multiloader$featherCoolDown = value;
    }

    @Override
    public int diversity_Multiloader$getFeatherCoolDown() {
        return this.diversity_Multiloader$featherCoolDown;
    }
}

