/*
 * Decompiled with CFR 0.152.
 */
package xyz.faewulf.diversity.mixin.general.bundleEnchantments;

import com.llamalad7.mixinextras.sugar.Local;
import java.util.ArrayList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.BundleContents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.math.Fraction;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import xyz.faewulf.diversity.inter.ICustomBundleVacuum;
import xyz.faewulf.lib.util.EnchantHelper;

@Mixin(value={ItemEntity.class})
public abstract class ItemEntityMixin
extends Entity
implements TraceableEntity {
    public ItemEntityMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Unique
    private static int diversity_Multiloader$getMaxSize(Level level, ItemStack itemStack) {
        int value = EnchantHelper.getEnchantLevelFromItem((Level)level, (ItemStack)itemStack, (String)"diversity", (String)"capacity");
        return 64 + value * 64;
    }

    @Inject(method={"playerTouch"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;onItemPickup(Lnet/minecraft/world/entity/item/ItemEntity;)V")}, cancellable=true)
    private void playerTouchInject(Player entity, CallbackInfo ci, @Local(ordinal=0) ItemStack itemstack, @Local(ordinal=0) int i) {
        if (itemstack.getMaxStackSize() <= 1 || itemstack.isEmpty()) {
            return;
        }
        ArrayList<ItemStack> bundles = new ArrayList<ItemStack>();
        ItemStack targetItemStack = null;
        for (int index = 0; index < entity.getInventory().getContainerSize(); ++index) {
            int value2;
            ItemStack item = entity.getInventory().getItem(index);
            if (item.isEmpty()) continue;
            int value1 = EnchantHelper.getEnchantLevelFromItem((Level)this.level(), (ItemStack)item, (String)"diversity", (String)"vacuum");
            if (value1 + (value2 = EnchantHelper.getEnchantLevelFromItem((Level)this.level(), (ItemStack)item, (String)"diversity", (String)"selective_vacuum")) > 0 && item.getItem() instanceof ICustomBundleVacuum) {
                if (value2 > 0) {
                    bundles.addFirst(item);
                    continue;
                }
                bundles.add(item);
                continue;
            }
            if (!ItemStack.isSameItemSameComponents((ItemStack)item, (ItemStack)itemstack)) continue;
            targetItemStack = item;
        }
        int insertAmount = i;
        for (ItemStack bundle : bundles) {
            int freeSlotInBundle;
            int numberOfItemWillPut;
            int maxBundleSize;
            Object object;
            if (insertAmount <= 0) break;
            if (bundle == null || targetItemStack == null || !((object = bundle.get(DataComponents.BUNDLE_CONTENTS)) instanceof BundleContents)) continue;
            BundleContents bundleContentsComponent = (BundleContents)object;
            boolean isSelective = false;
            ItemEnchantments itemEnchantmentsComponent = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)bundle);
            if (EnchantHelper.hasEnchantment((Level)this.level(), (ItemStack)bundle, (String)"diversity", (String)"selective_vacuum")) {
                isSelective = true;
            }
            ItemStack itemStackWillPutInto = targetItemStack;
            int stackMultiplier = 64 / itemStackWillPutInto.getMaxStackSize();
            int realStackSizeOfTheItemWillPutInto = stackMultiplier * itemStackWillPutInto.getCount();
            int usedSlotInBundle = Mth.mulAndTruncate((Fraction)bundleContentsComponent.weight(), (int)64);
            if (usedSlotInBundle >= (maxBundleSize = ItemEntityMixin.diversity_Multiloader$getMaxSize(this.level(), bundle)) || (numberOfItemWillPut = (int)Math.floor((float)Math.min(freeSlotInBundle = maxBundleSize - usedSlotInBundle, realStackSizeOfTheItemWillPutInto) * 1.0f / (float)stackMultiplier)) <= 0) continue;
            ArrayList itemStacksInBundle = new ArrayList(bundleContentsComponent.itemCopyStream().toList());
            boolean hasInsert = false;
            for (ItemStack itemStackInBundle : itemStacksInBundle) {
                if (!ItemStack.isSameItemSameComponents((ItemStack)itemStackInBundle, (ItemStack)itemStackWillPutInto)) continue;
                itemStackInBundle.grow(numberOfItemWillPut);
                hasInsert = true;
                break;
            }
            if (!hasInsert && !isSelective) {
                ItemStack newItemStack = itemStackWillPutInto.copy();
                newItemStack.setCount(numberOfItemWillPut);
                itemStacksInBundle.add(newItemStack);
                hasInsert = true;
            }
            if (!hasInsert) continue;
            itemStackWillPutInto.shrink(numberOfItemWillPut);
            insertAmount -= numberOfItemWillPut;
            bundleContentsComponent = new BundleContents(itemStacksInBundle);
            bundle.set(DataComponents.BUNDLE_CONTENTS, (Object)bundleContentsComponent);
        }
    }
}

