/*
 * Decompiled with CFR 0.152.
 */
package xyz.faewulf.diversity.mixin.general.fasterMineCart;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.VehicleEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import xyz.faewulf.diversity.util.config.ModConfigs;
import xyz.faewulf.lib.util.Compare;

@Mixin(value={AbstractMinecart.class})
public abstract class AbstractMinecartMixin
extends VehicleEntity {
    @Unique
    private BlockPos diversity$lastPos;
    @Unique
    private double diversity$lastMaxSpeedMult = 1.0;

    public AbstractMinecartMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @ModifyReturnValue(method={"getMaxSpeed", "getMaxSpeedWithRail"}, at={@At(value="RETURN")})
    private double getMaxSpeedModifyReturnValue(double original) {
        if (ModConfigs.faster_minecart) {
            if (this.blockPosition().equals((Object)this.diversity$lastPos)) {
                return original * this.diversity$lastMaxSpeedMult;
            }
            BlockState blockStateBelow = this.level().getBlockState(this.blockPosition().below());
            double multiplier = 1.0;
            if (Compare.isHasTag((Block)blockStateBelow.getBlock(), (String)"diversity:rail_supporter")) {
                multiplier = 2.0;
            }
            this.diversity$lastMaxSpeedMult = multiplier;
            this.diversity$lastPos = this.blockPosition();
            return original * multiplier;
        }
        return original;
    }
}

