/*
 * Decompiled with CFR 0.152.
 */
package xyz.faewulf.diversity.mixin.item.spyglassWhatIsThat;

import com.mojang.authlib.GameProfile;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import xyz.faewulf.diversity.util.config.ModConfigs;
import xyz.faewulf.diversity.util.hitResult2Infomations;

@Mixin(value={ServerPlayer.class})
public abstract class serverPlayerMixin
extends Player {
    @Unique
    private int diversity_Multiloader$spyGlassHUDcooldown = 0;

    public serverPlayerMixin(Level world, BlockPos pos, float yaw, GameProfile gameProfile) {
        super(world, pos, yaw, gameProfile);
    }

    @Shadow
    public abstract void sendSystemMessage(@NotNull Component var1);

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void tickInject(CallbackInfo ci) {
        if (ModConfigs.spyglass_what_is_that == ModConfigs.inspectType.DISABLE) {
            return;
        }
        Item handItem = this.getMainHandItem().getItem();
        Item offHandItem = this.getOffhandItem().getItem();
        if (handItem == Items.SPYGLASS || offHandItem == Items.SPYGLASS) {
            if (this.diversity_Multiloader$spyGlassHUDcooldown != 20) {
                ++this.diversity_Multiloader$spyGlassHUDcooldown;
                return;
            }
            this.diversity_Multiloader$spyGlassHUDcooldown = 0;
            int distance = this.isScoping() ? ModConfigs.spyglass_what_is_that_zoom_distance : ModConfigs.spyglass_what_is_that_normal_distance;
            HitResult hit = this.pick(distance, 0.0f, false);
            if (ModConfigs.spyglass_what_is_that == ModConfigs.inspectType.ALL || ModConfigs.spyglass_what_is_that == ModConfigs.inspectType.ENTITY_ONLY) {
                AABB box;
                Vec3 min = this.getEyePosition(0.0f);
                double sqrdDist = distance * distance;
                if (hit != null) {
                    sqrdDist = hit.getLocation().distanceToSqr(this.getEyePosition());
                }
                Vec3 vec3d2 = this.getViewVector(1.0f);
                Vec3 max = min.add(vec3d2.x * (double)distance, vec3d2.y * (double)distance, vec3d2.z * (double)distance);
                EntityHitResult hitResult = ProjectileUtil.getEntityHitResult((Entity)this, (Vec3)min, (Vec3)max, (AABB)(box = this.getBoundingBox().expandTowards(vec3d2.scale((double)distance)).inflate(1.0, 1.0, 1.0)), this::isTargetable_diversity, (double)sqrdDist);
                if (hitResult != null) {
                    hit = hitResult;
                }
            }
            if (hit == null) {
                return;
            }
            if (hit.getType() == HitResult.Type.ENTITY && (ModConfigs.spyglass_what_is_that == ModConfigs.inspectType.ALL || ModConfigs.spyglass_what_is_that == ModConfigs.inspectType.ENTITY_ONLY)) {
                EntityHitResult entityHitResult = (EntityHitResult)hit;
                this.displayClientMessage(hitResult2Infomations.parseLivingEntity(this.level(), this, entityHitResult.getEntity()), true);
            } else if (hit.getType() == HitResult.Type.BLOCK && (ModConfigs.spyglass_what_is_that == ModConfigs.inspectType.ALL || ModConfigs.spyglass_what_is_that == ModConfigs.inspectType.BLOCK_ONLY)) {
                BlockHitResult blockHit = (BlockHitResult)hit;
                this.displayClientMessage(hitResult2Infomations.parseBlockState(this.level(), this, blockHit.getBlockPos()), true);
            }
        }
    }

    @Unique
    private boolean isTargetable_diversity(Entity entity) {
        return !entity.isSpectator() && entity.isPickable() && !entity.isInvisibleTo((Player)this);
    }
}

