/*
 * Decompiled with CFR 0.152.
 */
package xyz.faewulf.diversity.mixin.item.waxedBlockIndicator;

import com.mojang.authlib.GameProfile;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import xyz.faewulf.diversity.util.config.ModConfigs;

@Mixin(value={ServerPlayer.class})
public abstract class serverPlayerMixin
extends Player {
    @Unique
    private int diversity_SpyglassUseTime = 0;

    @Shadow
    public abstract ServerLevel serverLevel();

    @Shadow
    public abstract void sendSystemMessage(Component var1);

    @Shadow
    public abstract void dismountTo(double var1, double var3, double var5);

    public serverPlayerMixin(Level world, BlockPos pos, float yaw, GameProfile gameProfile) {
        super(world, pos, yaw, gameProfile);
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void tickInject(CallbackInfo ci) {
        if (!ModConfigs.waxed_copper_indicator) {
            return;
        }
        Item handItem = this.getMainHandItem().getItem();
        Item offHandItem = this.getOffhandItem().getItem();
        if ((handItem == Items.SPYGLASS || offHandItem == Items.SPYGLASS) && this.isShiftKeyDown()) {
            if (this.diversity_SpyglassUseTime == 0) {
                BlockPos playerPos = this.blockPosition();
                int radius = 5;
                BlockPos minPos = new BlockPos(playerPos.getX() - 5, playerPos.getY() - 5, playerPos.getZ() - 5);
                BlockPos maxPos = new BlockPos(playerPos.getX() + 5, playerPos.getY() + 5, playerPos.getZ() + 5);
                for (BlockPos pos : BlockPos.betweenClosed((BlockPos)minPos, (BlockPos)maxPos)) {
                    Block currentBlock = this.serverLevel().getBlockState(pos).getBlock();
                    if (!currentBlock.getName().getString().toLowerCase().contains("waxed")) continue;
                    for (int i = 0; i < 10; ++i) {
                        double x = (double)pos.getX() + 0.5;
                        double y = (double)pos.getY() + 0.5;
                        double z = (double)pos.getZ() + 0.5;
                        Direction face = Direction.values()[this.random.nextInt(Direction.values().length)];
                        switch (face) {
                            case UP: {
                                y = (double)pos.getY() + 1.05;
                                x += this.random.nextDouble() - 0.55;
                                z += this.random.nextDouble() - 0.55;
                                break;
                            }
                            case DOWN: {
                                y = (double)pos.getY() - 0.05;
                                x += this.random.nextDouble() - 0.55;
                                z += this.random.nextDouble() - 0.55;
                                break;
                            }
                            case NORTH: {
                                z = (double)pos.getZ() - 0.05;
                                x += this.random.nextDouble() - 0.55;
                                y += this.random.nextDouble() - 0.55;
                                break;
                            }
                            case SOUTH: {
                                z = (double)pos.getZ() + 1.05;
                                x += this.random.nextDouble() - 0.55;
                                y += this.random.nextDouble() - 0.55;
                                break;
                            }
                            case WEST: {
                                x = (double)pos.getX() - 0.05;
                                y += this.random.nextDouble() - 0.55;
                                z += this.random.nextDouble() - 0.55;
                                break;
                            }
                            case EAST: {
                                x = (double)pos.getX() + 1.05;
                                y += this.random.nextDouble() - 0.55;
                                z += this.random.nextDouble() - 0.55;
                            }
                        }
                        this.serverLevel().sendParticles((ParticleOptions)ParticleTypes.WAX_ON, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
                    }
                }
            }
            this.diversity_SpyglassUseTime = this.diversity_SpyglassUseTime > 20 ? 0 : this.diversity_SpyglassUseTime + 1;
        }
    }
}

