/*
 * Decompiled with CFR 0.152.
 */
package xyz.faewulf.diversity.util.gameTests.entry.general;

import java.util.List;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import xyz.faewulf.diversity.util.config.ModConfigs;
import xyz.faewulf.lib.util.gameTests.TestGroup;

@TestGroup
public class invisibleItemFrame {
    @GameTest(template="faewulf_lib:default")
    public void test(GameTestHelper helper) {
        if (!ModConfigs.invisible_frame) {
            helper.setBlock(8, 8, 8, Blocks.RED_CONCRETE);
        }
        helper.setBlock(4, 1, 3, Blocks.GLASS);
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        ItemFrame itemFrame = (ItemFrame)helper.spawn(EntityType.ITEM_FRAME, 4, 1, 4);
        ItemStack itemStack = new ItemStack((ItemLike)Items.GLASS_PANE, 2);
        player.setItemInHand(InteractionHand.MAIN_HAND, itemStack);
        helper.startSequence().thenExecute(() -> {
            player.setShiftKeyDown(true);
            player.setPose(Pose.CROUCHING);
        }).thenExecute(() -> player.interactOn((Entity)itemFrame, InteractionHand.MAIN_HAND)).thenExecute(() -> {
            if (itemFrame.getItem().getItem() != Items.AIR) {
                helper.fail("Not trigger set visible mode.");
            }
        }).thenExecute(() -> {
            player.setShiftKeyDown(false);
            player.setPose(Pose.STANDING);
        }).thenExecute(() -> player.interactOn((Entity)itemFrame, InteractionHand.MAIN_HAND)).thenExecute(() -> {
            if (!itemFrame.isInvisible()) {
                helper.fail("Insert item not make ItemFrame invisible");
            }
        }).thenExecute(() -> {
            player.attack((Entity)itemFrame);
            player.attack((Entity)itemFrame);
        }).thenExecuteAfter(40, () -> {
            List itemEntities = helper.getEntities(EntityType.ITEM);
            boolean fail = true;
            for (ItemEntity itemEntity : itemEntities) {
                if (itemEntity.getItem().getItem() != Items.GLASS_PANE || itemEntity.getItem().getCount() != 2) continue;
                fail = false;
            }
            if (fail) {
                helper.fail(itemEntities.toString());
            }
        }).thenSucceed();
    }
}

