/*
 * Decompiled with CFR 0.152.
 */
package xyz.faewulf.diversity.util;

import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import java.text.DecimalFormat;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.animal.horse.AbstractChestedHorse;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HopperBlock;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BeaconBlockEntity;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BrewingStandBlockEntity;
import net.minecraft.world.level.block.entity.TrialSpawnerBlockEntity;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerData;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import xyz.faewulf.diversity.mixin.item.spyglassWhatIsThat.AbstractFurnaceBlockEntityMixin;
import xyz.faewulf.diversity.mixin.item.spyglassWhatIsThat.BeaconBlockEntityMixin;
import xyz.faewulf.diversity.mixin.item.spyglassWhatIsThat.BrewingStandBlockEntityMixin;
import xyz.faewulf.diversity.mixin.item.spyglassWhatIsThat.TrialSpawnerDataMixin;
import xyz.faewulf.diversity.util.config.ModConfigs;
import xyz.faewulf.lib.util.Converter;

public class hitResult2Infomations {
    public static Component parseBlockState(Level world, Player player, BlockPos blockPos) {
        Direction blockDirection;
        boolean showDistance = true;
        boolean showDirection = true;
        boolean showInfo = true;
        boolean showName = true;
        if (player.isScoping()) {
            showInfo = ModConfigs.spyglass_what_is_that_zoom_show_infos;
            showDirection = ModConfigs.spyglass_what_is_that_zoom_show_direction;
            showDistance = ModConfigs.spyglass_what_is_that_zoom_show_distance;
            showName = ModConfigs.spyglass_what_is_that_zoom_show_block_name;
        } else {
            showInfo = ModConfigs.spyglass_what_is_that_normal_show_infos;
            showDirection = ModConfigs.spyglass_what_is_that_normal_show_direction;
            showDistance = ModConfigs.spyglass_what_is_that_normal_show_distance;
            showName = ModConfigs.spyglass_what_is_that_normal_show_block_name;
        }
        Direction playerDirection = player.getDirection();
        BlockState blockState = world.getBlockState(blockPos);
        BlockEntity blockEntity = world.getBlockEntity(blockPos);
        Block block = blockState.getBlock();
        MutableComponent result = Component.empty();
        if (showName) {
            result.append((Component)Component.literal((String)block.getName().getString()));
        }
        if (blockState.hasProperty((Property)BlockStateProperties.FACING) && showDirection) {
            blockDirection = (Direction)blockState.getValue((Property)BlockStateProperties.FACING);
            result.append((Component)Component.literal((String)(" " + hitResult2Infomations.getRelativeFacing(playerDirection, blockDirection, false, false))).withStyle(ChatFormatting.AQUA));
        }
        if (blockState.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING) && showDirection) {
            blockDirection = (Direction)blockState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
            if (blockEntity != null) {
                result.append((Component)Component.literal((String)(" " + hitResult2Infomations.getRelativeFacing(playerDirection, blockDirection, false, false))).withStyle(ChatFormatting.AQUA));
            } else {
                result.append((Component)Component.literal((String)(" " + hitResult2Infomations.getRelativeFacing(playerDirection, blockDirection, true, true))).withStyle(ChatFormatting.AQUA));
            }
        }
        if (blockState.hasProperty((Property)HopperBlock.FACING) && showDirection) {
            blockDirection = (Direction)blockState.getValue((Property)HopperBlock.FACING);
            result.append((Component)Component.literal((String)(" " + hitResult2Infomations.getRelativeFacing(playerDirection, blockDirection, false, false))).withStyle(ChatFormatting.AQUA));
        }
        if (blockState.hasProperty((Property)BlockStateProperties.ENABLED) && showInfo && !((Boolean)blockState.getValue((Property)BlockStateProperties.ENABLED)).booleanValue()) {
            result.append((Component)Component.literal((String)" disabled").withStyle(ChatFormatting.DARK_RED));
        }
        if (blockState.hasProperty((Property)BlockStateProperties.WATERLOGGED) && showInfo && ((Boolean)blockState.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            result.append((Component)Component.literal((String)" waterlogged").withStyle(ChatFormatting.DARK_AQUA));
        }
        if (blockState.hasProperty((Property)BlockStateProperties.NOTE) && showInfo) {
            int note = (Integer)blockState.getValue((Property)BlockStateProperties.NOTE);
            NoteBlockInstrument instrument = (NoteBlockInstrument)blockState.getValue((Property)BlockStateProperties.NOTEBLOCK_INSTRUMENT);
            result.append((Component)Component.literal((String)(" " + Converter.getNoteCharacter((int)note))).withStyle(ChatFormatting.GOLD));
            result.append((Component)Component.literal((String)(" " + instrument.name())).withStyle(ChatFormatting.GOLD));
        }
        if (blockEntity instanceof TrialSpawnerBlockEntity) {
            TrialSpawnerData trialSpawnerData;
            TrialSpawnerBlockEntity trialSpawnerBlockEntity = (TrialSpawnerBlockEntity)blockEntity;
            if (showInfo && !(trialSpawnerData = trialSpawnerBlockEntity.getTrialSpawner().getData()).isCooldownFinished((ServerLevel)world)) {
                long cooldown = ((TrialSpawnerDataMixin)trialSpawnerData).getCooldownEndsAt();
                result.append((Component)Component.literal((String)(" \u231b" + Converter.tick2Time((long)(cooldown - world.getGameTime())))).withStyle(ChatFormatting.RED));
            }
        }
        if (blockEntity instanceof AbstractFurnaceBlockEntity) {
            AbstractFurnaceBlockEntity abstractFurnaceBlockEntity = (AbstractFurnaceBlockEntity)blockEntity;
            if (showInfo) {
                AtomicInteger totalExp = new AtomicInteger();
                for (Reference2IntMap.Entry entry : ((AbstractFurnaceBlockEntityMixin)abstractFurnaceBlockEntity).getRecipesUsed().reference2IntEntrySet()) {
                    ((ServerLevel)world).recipeAccess().byKey((ResourceKey)entry.getKey()).ifPresent(recipe -> {
                        int multiplier = entry.getIntValue();
                        float experience = ((AbstractCookingRecipe)recipe.value()).experience();
                        int i = Mth.floor((float)((float)multiplier * experience));
                        float f = Mth.frac((float)((float)multiplier * experience));
                        if (f != 0.0f && Math.random() < (double)f) {
                            ++i;
                        }
                        totalExp.addAndGet(i);
                    });
                }
                if (totalExp.get() > 0) {
                    result.append((Component)Component.literal((String)(" Exp: " + totalExp.get())).withStyle(ChatFormatting.GREEN));
                }
            }
        }
        if (blockState.hasProperty((Property)BlockStateProperties.POWER) && showInfo) {
            int power = (Integer)blockState.getValue((Property)BlockStateProperties.POWER);
            result.append((Component)Component.literal((String)(" \u26a1" + power)).withStyle(ChatFormatting.RED));
        }
        if (blockState.hasProperty((Property)BeehiveBlock.HONEY_LEVEL) && showInfo) {
            int level = (Integer)blockState.getValue((Property)BlockStateProperties.LEVEL_HONEY);
            result.append((Component)Component.literal((String)(" \ud83c\udf6f" + level)).withStyle(ChatFormatting.GOLD));
            if (blockEntity instanceof BeehiveBlockEntity) {
                BeehiveBlockEntity beehiveBlockEntity = (BeehiveBlockEntity)blockEntity;
                result.append((Component)Component.literal((String)(" \ud83d\udc1d" + beehiveBlockEntity.getOccupantCount())).withStyle(ChatFormatting.GOLD));
            }
        }
        if (blockEntity instanceof BrewingStandBlockEntity) {
            BrewingStandBlockEntity brewingStandBlockEntity = (BrewingStandBlockEntity)blockEntity;
            if (showInfo) {
                int fuel = ((BrewingStandBlockEntityMixin)brewingStandBlockEntity).getFuel();
                result.append((Component)Component.literal((String)(" Fuel: " + fuel)).withStyle(ChatFormatting.GOLD));
            }
        }
        if (blockEntity instanceof BeaconBlockEntity) {
            BeaconBlockEntity beaconBlockEntity = (BeaconBlockEntity)blockEntity;
            if (showInfo) {
                int level = ((BeaconBlockEntityMixin)beaconBlockEntity).getLevels();
                int range = level * 10 + 10;
                if (level > 4) {
                    range += (level - 4) * 10;
                }
                result.append((Component)Component.literal((String)(" Level: " + level)).withStyle(ChatFormatting.GREEN));
                result.append((Component)Component.literal((String)(" Radius: " + range)).withStyle(ChatFormatting.DARK_AQUA));
            }
        }
        if (showDistance) {
            BlockPos playerPos = player.blockPosition();
            BlockPos distance = blockPos.subtract((Vec3i)playerPos);
            result.append((Component)Component.literal((String)" \ud83d\udcd0("));
            result.append((Component)Component.literal((String)(distance.getX() + ", ")).withStyle(ChatFormatting.RED));
            result.append((Component)Component.literal((String)(distance.getY() + ", ")).withStyle(ChatFormatting.GREEN));
            result.append((Component)Component.literal((String)String.valueOf(distance.getZ())).withStyle(ChatFormatting.BLUE));
            result.append((Component)Component.literal((String)")"));
            double distanceGeometry = Math.sqrt(distance.getX() * distance.getX() + distance.getY() * distance.getY() + distance.getZ() * distance.getZ());
            distanceGeometry = (double)Math.round(distanceGeometry * 10.0) / 10.0;
            result.append((Component)Component.literal((String)(" \ud83d\udccf" + distanceGeometry)));
        }
        return result;
    }

    private static String getRelativeFacing(Direction player, Direction block, boolean inverseLeftRight, boolean inverseBackFront) {
        if (block == Direction.UP) {
            return "\u21a5";
        }
        if (block == Direction.DOWN) {
            return "\u21a7";
        }
        int turnValue = 0;
        while (player != block) {
            block = block.getClockWise();
            ++turnValue;
        }
        String arrow = switch (turnValue) {
            case 1 -> {
                if (inverseLeftRight) {
                    yield "\u27a1";
                }
                yield "\u2b05";
            }
            case 2 -> {
                if (inverseBackFront) {
                    yield "\u2b06";
                }
                yield "\u2b07";
            }
            case 3 -> {
                if (inverseLeftRight) {
                    yield "\u2b05";
                }
                yield "\u27a1";
            }
            default -> inverseBackFront ? "\u2b07" : "\u2b06";
        };
        return arrow;
    }

    public static Component parseLivingEntity(Level world, Player player, Entity entity) {
        boolean showDistance = true;
        boolean showInfo = true;
        boolean showName = true;
        if (player.isScoping()) {
            showInfo = ModConfigs.spyglass_what_is_that_zoom_show_infos;
            showDistance = ModConfigs.spyglass_what_is_that_zoom_show_distance;
            showName = ModConfigs.spyglass_what_is_that_zoom_show_block_name;
        } else {
            showInfo = ModConfigs.spyglass_what_is_that_normal_show_infos;
            showDistance = ModConfigs.spyglass_what_is_that_normal_show_distance;
            showName = ModConfigs.spyglass_what_is_that_normal_show_block_name;
        }
        MutableComponent result = Component.empty();
        DecimalFormat df = new DecimalFormat("#.#");
        if (entity instanceof Wolf) {
            Wolf wolfEntity = (Wolf)entity;
            if (showName) {
                result.append(Converter.UppercaseFirstLetter((String)wolfEntity.getVariant().getRegisteredName().replace("minecraft:", "").replace("_", " ")));
            }
        }
        if (entity instanceof Cat) {
            Cat catEntity = (Cat)entity;
            if (showName) {
                result.append(Converter.UppercaseFirstLetter((String)catEntity.getVariant().getRegisteredName().replace("minecraft:", "").replace("_", " ")));
            }
        }
        if (entity instanceof ZombieVillager) {
            ZombieVillager zombieVillagerEntity = (ZombieVillager)entity;
            if (showName) {
                result.append(Converter.UppercaseFirstLetter((String)zombieVillagerEntity.getVillagerData().getProfession().toString()));
            }
        }
        if (showName) {
            result.append(" ");
            result.append(entity.getName());
        }
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (showInfo) {
                float hp = (float)Math.round(livingEntity.getHealth() * 10.0f) / 10.0f;
                float maxHP = livingEntity.getMaxHealth();
                result.append(" |");
                result.append((Component)Component.literal((String)" \u2665").withStyle(ChatFormatting.RED));
                result.append((Component)Component.literal((String)(df.format(hp) + "/" + df.format(maxHP))));
            }
        }
        if (entity instanceof AbstractHorse) {
            AbstractHorse abstractHorseEntity = (AbstractHorse)entity;
            if (showInfo) {
                double speed = abstractHorseEntity.getAttributes().getValue(Attributes.MOVEMENT_SPEED);
                double jump = abstractHorseEntity.getAttributes().getValue(Attributes.JUMP_STRENGTH);
                result.append(" |");
                result.append((Component)Component.literal((String)" \u27a0").withStyle(ChatFormatting.BLUE));
                result.append((Component)Component.literal((String)df.format(Converter.genericSpeed2BlockPerSecond((double)speed))));
                result.append((Component)Component.literal((String)" \u21e1").withStyle(ChatFormatting.GREEN));
                result.append((Component)Component.literal((String)df.format(Converter.horseJumpStrength2JumpHeight((double)jump))));
            }
        }
        if (entity instanceof AbstractChestedHorse) {
            AbstractChestedHorse abstractDonkeyEntity = (AbstractChestedHorse)entity;
            if (showInfo) {
                String slot = df.format(3L * (long)abstractDonkeyEntity.getInventoryColumns());
                result.append(" |");
                result.append((Component)Component.literal((String)" Slots:").withStyle(ChatFormatting.GOLD));
                result.append(slot);
            }
        }
        if (entity instanceof OwnableEntity) {
            OwnableEntity tameable = (OwnableEntity)entity;
            if (showInfo && tameable.getOwnerUUID() != null) {
                result.append(" |");
                result.append((Component)Component.literal((String)" Tamed").withStyle(ChatFormatting.GREEN));
            }
        }
        if (entity instanceof Animal) {
            int breedAge;
            Animal animalEntity = (Animal)entity;
            if (showInfo && (breedAge = animalEntity.getAge()) > 0) {
                result.append(" |");
                result.append((Component)Component.literal((String)(" \u231bBreed:" + Converter.tick2Time((long)breedAge))).withStyle(ChatFormatting.GOLD));
            }
        }
        if (showDistance) {
            BlockPos playerPos = player.blockPosition();
            BlockPos distance = entity.blockPosition().subtract((Vec3i)playerPos);
            double distanceGeometry = Math.sqrt(distance.getX() * distance.getX() + distance.getY() * distance.getY() + distance.getZ() * distance.getZ());
            result.append(" |");
            result.append((Component)Component.literal((String)(" \ud83d\udccf" + df.format(distanceGeometry))));
        }
        return result;
    }
}

