/*
 * Decompiled with CFR 0.152.
 */
package xyz.faewulf.diversity.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import xyz.faewulf.diversity.util.config.ModConfigs;

public class slimechunk {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        if (!ModConfigs.slime_chunk_check) {
            return;
        }
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"slimechunkcheck").requires(CommandSourceStack::isPlayer)).executes(slimechunk::run));
    }

    private static int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        boolean isSlimeChunk;
        if (ModConfigs.permission_enable && !((CommandSourceStack)context.getSource()).hasPermission(1)) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"You don't have permission to use this command"), false);
            return 0;
        }
        ServerPlayer serverPlayerEntity = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        ServerLevel world = serverPlayerEntity.level();
        if (world.isClientSide()) {
            return 0;
        }
        ChunkPos chunkPos = new ChunkPos(serverPlayerEntity.blockPosition());
        long seed = ((WorldGenLevel)world).getSeed();
        boolean bl = isSlimeChunk = WorldgenRandom.seedSlimeChunk((int)chunkPos.x, (int)chunkPos.z, (long)seed, (long)987234911L).nextInt(10) == 0;
        if (isSlimeChunk) {
            serverPlayerEntity.displayClientMessage((Component)Component.literal((String)"You are standing in the slime chunk").withStyle(ChatFormatting.GREEN), true);
        } else {
            serverPlayerEntity.displayClientMessage((Component)Component.literal((String)"You are not standing in the slime chunk").withStyle(ChatFormatting.GRAY), true);
        }
        return 1;
    }
}

