/*
 * Decompiled with CFR 0.152.
 */
package xyz.faewulf.diversity.event;

import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Display;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import xyz.faewulf.diversity.feature.entity.pseudoBlockEntity.PseudoBlockEntities;
import xyz.faewulf.diversity.feature.entity.pseudoBlockEntity.PseudoBlockEntity;
import xyz.faewulf.diversity.util.config.ModConfigs;
import xyz.faewulf.lib.util.Converter;

public class useClockOnBlock {
    public static InteractionResult run(Level world, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (!ModConfigs.check_villager_schedule) {
            return InteractionResult.PASS;
        }
        if (world.isClientSide()) {
            return InteractionResult.PASS;
        }
        Item item = player.getItemInHand(hand).getItem();
        if (item == Items.CLOCK) {
            long worldTime = world.getDayTime();
            BlockState block = world.getBlockState(hitResult.getBlockPos());
            ArrayList<Block> workStations = new ArrayList<Block>();
            for (PoiType poiType : BuiltInRegistries.POINT_OF_INTEREST_TYPE) {
                for (BlockState blockState : poiType.matchingStates()) {
                    workStations.add(blockState.getBlock());
                }
            }
            if (block.getBlock() == Blocks.SUGAR_CANE) {
                PseudoBlockEntity pseudoBlockEntity;
                Display.TextDisplay display = PseudoBlockEntities.STOP_GROW.build(world);
                BlockPos pos = hitResult.getBlockPos();
                display.setPos(pos.getCenter().x, pos.getCenter().y, pos.getCenter().z);
                if (display instanceof PseudoBlockEntity && !(pseudoBlockEntity = (PseudoBlockEntity)display).diversity_Multiloader$isBlockEntityAlreadyExist()) {
                    world.addFreshEntity((Entity)display);
                }
            }
            if (workStations.contains(block.getBlock())) {
                MutableComponent next;
                MutableComponent current;
                long timeLeft = -1L;
                if (worldTime >= 12000L || worldTime < 10L) {
                    current = Component.literal((String)"Sleep").withStyle(ChatFormatting.DARK_BLUE);
                    next = Component.literal((String)"Wander").withStyle(ChatFormatting.LIGHT_PURPLE);
                } else if (worldTime < 2000L) {
                    current = Component.literal((String)"Wander").withStyle(ChatFormatting.LIGHT_PURPLE);
                    next = Component.literal((String)"Work").withStyle(ChatFormatting.GREEN);
                    timeLeft = 2000L - worldTime;
                } else if (worldTime < 9000L) {
                    current = Component.literal((String)"Work").withStyle(ChatFormatting.GREEN);
                    next = Component.literal((String)"Gather").withStyle(ChatFormatting.GOLD);
                    timeLeft = 9000L - worldTime;
                } else if (worldTime < 11000L) {
                    current = Component.literal((String)"Gather").withStyle(ChatFormatting.GOLD);
                    next = Component.literal((String)"Wander").withStyle(ChatFormatting.LIGHT_PURPLE);
                    timeLeft = 11000L - worldTime;
                } else {
                    current = Component.literal((String)"Wander").withStyle(ChatFormatting.LIGHT_PURPLE);
                    next = Component.literal((String)"Sleep").withStyle(ChatFormatting.DARK_BLUE);
                    timeLeft = 12000L - worldTime;
                }
                MutableComponent feedBack = Component.literal((String)"Current: ").append((Component)current);
                if (timeLeft != -1L) {
                    feedBack.append(" | Time left: ").append((Component)Component.literal((String)Converter.tick2Time((long)timeLeft)));
                }
                feedBack.append(" | Next: ").append((Component)next);
                player.swing(hand, true);
                player.displayClientMessage((Component)feedBack, true);
                return InteractionResult.CONSUME;
            }
        }
        return InteractionResult.PASS;
    }
}

