/*
 * Decompiled with CFR 0.152.
 */
package xyz.faewulf.diversity.event;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Display;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import xyz.faewulf.diversity.feature.entity.pseudoBlockEntity.PseudoBlockEntities;
import xyz.faewulf.diversity.feature.entity.pseudoBlockEntity.PseudoBlockEntity;
import xyz.faewulf.diversity.util.config.ModConfigs;
import xyz.faewulf.diversity.util.pseudoBlockEntityUtil;
import xyz.faewulf.lib.util.Compare;

public class useShearOnBlock {
    public static InteractionResult run(Level world, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockState block;
        if (!ModConfigs.shear_prevent_growing) {
            return InteractionResult.PASS;
        }
        if (world.isClientSide()) {
            return InteractionResult.PASS;
        }
        Item item = player.getItemInHand(hand).getItem();
        if (item == Items.SHEARS && (Compare.isHasTag((Block)(block = world.getBlockState(hitResult.getBlockPos())).getBlock(), (String)"diversity:trimmable") || Compare.isHasTag((Block)block.getBlock(), (String)"minecraft:saplings"))) {
            PseudoBlockEntity pseudoBlockEntity;
            if (pseudoBlockEntityUtil.getBlockEntity(world, hitResult.getBlockPos()) != null) {
                return InteractionResult.PASS;
            }
            Display.TextDisplay display = PseudoBlockEntities.STOP_GROW.build(world);
            BlockPos pos = hitResult.getBlockPos();
            display.setPos(pos.getCenter().x, pos.getCenter().y, pos.getCenter().z);
            if (display instanceof PseudoBlockEntity && !(pseudoBlockEntity = (PseudoBlockEntity)display).diversity_Multiloader$isBlockEntityAlreadyExist()) {
                world.addFreshEntity((Entity)display);
                world.playSound(null, pos, SoundEvents.GROWING_PLANT_CROP, SoundSource.PLAYERS, 1.0f, (1.0f + world.getRandom().nextFloat() * 0.2f) * 0.7f);
                player.getItemInHand(hand).hurtAndBreak(1, (LivingEntity)player, hand.asEquipmentSlot());
            }
            player.swing(hand, true);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }
}

