/*
 * Decompiled with CFR 0.152.
 */
package xyz.faewulf.diversity.mixin.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.random.WeightedList;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.sniffer.Sniffer;
import net.minecraft.world.entity.projectile.windcharge.AbstractWindCharge;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import xyz.faewulf.diversity.inter.ICustomSniffer;
import xyz.faewulf.diversity.inter.typeSnort;

@Mixin(value={Sniffer.class})
public abstract class SnifferSniffStuff
extends Animal
implements ICustomSniffer {
    @Unique
    private typeSnort diversity_Multiloader$snortType;
    @Unique
    private int diversity_Multiloader$snortState = 0;
    @Unique
    private int diversity_Multiloader$snortTimer = 0;

    protected SnifferSniffStuff(EntityType<? extends Animal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Shadow
    public abstract Sniffer transitionTo(Sniffer.State var1);

    @Inject(at={@At(value="HEAD")}, method={"tick"})
    private void tick(CallbackInfo ci) {
        if (this.diversity_Multiloader$snortType == null) {
            return;
        }
        if (this.level().isClientSide()) {
            return;
        }
        if (this.diversity_Multiloader$snortTimer >= 30) {
            this.diversity_Multiloader$snortTimer = 0;
            ++this.diversity_Multiloader$snortState;
            if (this.diversity_Multiloader$snortState % 2 == 0) {
                this.transitionTo(Sniffer.State.SNIFFING);
            } else {
                this.transitionTo(Sniffer.State.SCENTING);
            }
            this.playSound(SoundEvents.SNIFFER_IDLE, 1.0f, 1.0f);
            if (this.diversity_Multiloader$snortState > 5) {
                this.diversity_Multiloader$snortState = 0;
                Level level = this.level();
                if (level instanceof ServerLevel) {
                    ServerLevel serverWorld = (ServerLevel)level;
                    if (this.diversity_Multiloader$snortType != null) {
                        switch (this.diversity_Multiloader$snortType) {
                            case GUN_POWDER: {
                                serverWorld.explode(null, this.getX(), this.getY(), this.getZ(), 2.0f, Level.ExplosionInteraction.NONE);
                                break;
                            }
                            case BLAZE_POWDER: 
                            case GLOW_DUST: {
                                serverWorld.explode(null, this.getX(), this.getY(), this.getZ(), 1.0f, true, Level.ExplosionInteraction.NONE);
                                break;
                            }
                            case SUGAR: {
                                serverWorld.explode(null, this.getX(), this.getY(), this.getZ(), 0.0f, Level.ExplosionInteraction.NONE);
                                break;
                            }
                            case BONE_MEAL: {
                                ItemStack bonemeal = new ItemStack((ItemLike)Items.BONE_MEAL);
                                BlockPos bonemealPos = this.blockPosition().below();
                                BoneMealItem.growCrop((ItemStack)bonemeal, (Level)serverWorld, (BlockPos)bonemealPos);
                                serverWorld.levelEvent(1505, bonemealPos, 15);
                                serverWorld.explode(null, this.getX(), this.getY(), this.getZ(), 0.5f, Level.ExplosionInteraction.NONE);
                                break;
                            }
                            case REDSTONE: {
                                serverWorld.explode(null, null, AbstractWindCharge.EXPLOSION_DAMAGE_CALCULATOR, this.getX(), this.getY(), this.getZ(), 2.0f, false, Level.ExplosionInteraction.TRIGGER, (ParticleOptions)ParticleTypes.GUST_EMITTER_SMALL, (ParticleOptions)ParticleTypes.GUST_EMITTER_LARGE, WeightedList.of(), (Holder)SoundEvents.BREEZE_WIND_CHARGE_BURST);
                            }
                        }
                    }
                }
                this.diversity_Multiloader$snortType = null;
            }
        }
        ++this.diversity_Multiloader$snortTimer;
    }

    @Override
    public typeSnort diversity_Multiloader$getSnortType() {
        return this.diversity_Multiloader$snortType;
    }

    @Override
    public void diversity_Multiloader$setSnortType(typeSnort snortType) {
        this.diversity_Multiloader$snortType = snortType;
    }
}

