/*
 * Decompiled with CFR 0.152.
 */
package xyz.faewulf.diversity.mixin.entity.featherOnBrush;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import xyz.faewulf.diversity.inter.entity.ICustomChickenEntity;
import xyz.faewulf.diversity.util.config.ModConfigs;

@Mixin(value={Animal.class})
public class ChickenEntitySuperClassMixin {
    @Inject(method={"mobInteract"}, at={@At(value="HEAD")}, cancellable=true)
    private void InjectInteractMod(Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        if (!ModConfigs.brushable_parrot_chicken) {
            return;
        }
        ChickenEntitySuperClassMixin chickenEntitySuperClassMixin = this;
        if (chickenEntitySuperClassMixin instanceof Chicken) {
            Chicken chickenEntity = (Chicken)chickenEntitySuperClassMixin;
            if (player.level().isClientSide() || ((ICustomChickenEntity)chickenEntity).diversity_Multiloader$getFeatherCoolDown() > 0) {
                return;
            }
            if (chickenEntity.isBaby() || !player.isShiftKeyDown() || player.getItemInHand(InteractionHand.MAIN_HAND).getItem() != Items.BRUSH) {
                return;
            }
            player.getItemInHand(InteractionHand.MAIN_HAND).hurtAndBreak(1, (LivingEntity)player, InteractionHand.MAIN_HAND.asEquipmentSlot());
            chickenEntity.playSound(SoundEvents.ITEM_FRAME_REMOVE_ITEM, 0.8f, 1.0f);
            ItemStack drops = new ItemStack((ItemLike)Items.FEATHER);
            drops.setCount(chickenEntity.getRandom().nextIntBetweenInclusive(1, 2));
            chickenEntity.spawnAtLocation((ServerLevel)player.level(), drops);
            ((ICustomChickenEntity)chickenEntity).diversity_Multiloader$setFeatherCoolDown(12000);
            player.swing(hand, true);
            cir.setReturnValue((Object)InteractionResult.SUCCESS);
            cir.cancel();
        }
    }
}

