/*
 * Decompiled with CFR 0.152.
 */
package xyz.faewulf.diversity.mixin.entity;

import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import xyz.faewulf.diversity.util.config.ModConfigs;
import xyz.faewulf.lib.util.Compare;

@Mixin(value={ItemEntity.class})
public abstract class onGroundEggAutoHatch
extends Entity
implements TraceableEntity {
    public onGroundEggAutoHatch(EntityType<?> type, Level world) {
        super(type, world);
    }

    @Shadow
    public abstract ItemStack getItem();

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/item/ItemEntity;discard()V", ordinal=1)})
    private void tickInject(CallbackInfo ci) {
        if (!ModConfigs.chicken_egg_despawn_tryhatch) {
            return;
        }
        if (this.level().isClientSide()) {
            return;
        }
        if (this.getItem().getItem() == Items.EGG) {
            BlockState blockState = this.level().getBlockState(this.blockPosition().below());
            if (!Compare.isHasTag((Block)blockState.getBlock(), (String)"diversity:egg_hatchable")) {
                return;
            }
            int count = this.getItem().getCount();
            block0: for (int i = 0; i < count; ++i) {
                if (this.random.nextInt(8) != 0) continue;
                int chickenSpawnCount = 1;
                if (this.random.nextInt(32) == 0) {
                    chickenSpawnCount = 4;
                }
                EntityDimensions EMPTY_DIMENSIONS = EntityDimensions.fixed((float)0.0f, (float)0.0f);
                for (int j = 0; j < chickenSpawnCount; ++j) {
                    Chicken chickenEntity = (Chicken)EntityType.CHICKEN.create(this.level(), EntitySpawnReason.NATURAL);
                    if (chickenEntity == null) continue;
                    chickenEntity.setAge(-24000);
                    chickenEntity.snapTo(this.getX(), this.getY(), this.getZ(), this.getYRot(), 0.0f);
                    if (!chickenEntity.fudgePositionAfterSizeChange(EMPTY_DIMENSIONS)) continue block0;
                    this.level().addFreshEntity((Entity)chickenEntity);
                }
            }
            this.level().playSound(null, this.getOnPos(), SoundEvents.TURTLE_EGG_BREAK, SoundSource.BLOCKS, 1.0f, (1.0f + this.level().getRandom().nextFloat() * 0.2f) * 0.7f);
        }
    }
}

