/*
 * Decompiled with CFR 0.152.
 */
package xyz.faewulf.diversity.mixin.general.bonemealSmallFlower;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import xyz.faewulf.diversity.inter.ICustomBonemealable;
import xyz.faewulf.diversity.util.config.ModConfigs;
import xyz.faewulf.lib.util.Compare;

@Mixin(value={FlowerBlock.class})
public class FlowerBlockMixin
implements ICustomBonemealable {
    @Override
    public boolean Diversity$isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        if (!ModConfigs.bonemeal_small_flower) {
            return false;
        }
        return state.is(BlockTags.SMALL_FLOWERS) && !Compare.isHasTag((Block)state.getBlock(), (String)"diversity:bonemeal_blacklist") && Compare.isHasTag((Block)level.getBlockState(pos.below()).getBlock(), (String)"diversity:rich_soil");
    }

    @Override
    public boolean Diversity$isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return (double)random.nextFloat() < 0.5;
    }

    @Override
    public void Diversity$performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        int j = 1;
        int l = 0;
        int m = pos.getX() - 1;
        int n = 0;
        for (int o = 0; o < 3; ++o) {
            for (int p = 0; p < j; ++p) {
                int q = 2 + pos.getY() - 1;
                for (int r = q - 2; r < q; ++r) {
                    BlockPos blockPos = new BlockPos(m + o, r, pos.getZ() - n + p);
                    if (blockPos.equals((Object)pos) || random.nextInt(12) != 0 || !level.getBlockState(blockPos).is(Blocks.AIR)) continue;
                    BlockState blockState = level.getBlockState(blockPos.below());
                    if (Compare.isHasTag((Block)blockState.getBlock(), (String)"diversity:rich_soil")) {
                        level.setBlock(blockPos, state, 3);
                    }
                    level.sendParticles((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, (double)blockPos.getX() + 0.5, (double)blockPos.getY() + 0.5, (double)blockPos.getZ() + 0.5, 7, 0.3, 0.3, 0.3, 0.1);
                }
            }
            if (l < 2) {
                j += 2;
                ++n;
            } else {
                j -= 2;
                --n;
            }
            ++l;
        }
        level.sendParticles((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 7, 0.3, 0.3, 0.3, 0.1);
    }
}

