/*
 * Decompiled with CFR 0.152.
 */
package xyz.faewulf.diversity.mixin.item.tridentSummonLightning;

import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import xyz.faewulf.diversity.util.config.ModConfigs;
import xyz.faewulf.lib.util.EnchantHelper;

@Mixin(value={ThrownTrident.class})
public abstract class TridentEntityMixin
extends AbstractArrow {
    protected TridentEntityMixin(EntityType<? extends AbstractArrow> entityType, Level world) {
        super(entityType, world);
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void tickInject(CallbackInfo ci) {
        if (!ModConfigs.trident_call_thunder) {
            return;
        }
        if (this.level().isClientSide()) {
            return;
        }
        if (this.level().dimension() != Level.OVERWORLD) {
            return;
        }
        Entity entity = this.getOwner();
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayerEntity = (ServerPlayer)entity;
            entity = this.level();
            if (entity instanceof ServerLevel) {
                ItemEnchantments itemEnchantmentsComponent;
                ServerLevel serverWorld = (ServerLevel)entity;
                if (!serverWorld.getGameRules().getBoolean(GameRules.RULE_WEATHER_CYCLE)) {
                    return;
                }
                ItemStack itemStack = this.getPickupItemStackOrigin();
                if ((float)itemStack.getDamageValue() > (float)itemStack.getMaxDamage() * 1.0f / 2.0f) {
                    return;
                }
                if (this.getY() > 340.0 && !serverWorld.isThundering() && (itemEnchantmentsComponent = (ItemEnchantments)itemStack.get(DataComponents.ENCHANTMENTS)) != null && !itemEnchantmentsComponent.isEmpty()) {
                    int value;
                    Holder channeling = EnchantHelper.getEnchant((Level)this.level(), (String)"minecraft", (String)"channeling");
                    int n = value = channeling != null ? itemEnchantmentsComponent.getLevel(channeling) : 0;
                    if (value > 0) {
                        itemStack.setDamageValue(itemStack.getMaxDamage() - 1);
                        ItemEnchantments.Mutable builder = new ItemEnchantments.Mutable(itemEnchantmentsComponent);
                        builder.set(channeling, 0);
                        itemStack.set(DataComponents.ENCHANTMENTS, (Object)builder.toImmutable());
                        this.setPickupItemStack(itemStack);
                        LightningBolt lightningBolt = (LightningBolt)EntityType.LIGHTNING_BOLT.create((Level)serverWorld, EntitySpawnReason.TRIGGERED);
                        if (lightningBolt != null) {
                            lightningBolt.setPosRaw(this.getX(), this.getY(), this.getZ());
                            serverWorld.addFreshEntity((Entity)lightningBolt);
                        }
                        int duration = ServerLevel.THUNDER_DURATION.sample(serverWorld.random);
                        serverWorld.setWeatherParameters(15, duration, true, true);
                    }
                }
            }
        }
    }
}

