/*
 * Decompiled with CFR 0.152.
 */
package xyz.faewulf.diversity.util;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.LootTable;

public class CustomLootTables {
    private static final Set<ResourceKey<LootTable>> LOOT_TABLES = new HashSet<ResourceKey<LootTable>>();
    private static final Set<ResourceKey<LootTable>> LOOT_TABLES_READ_ONLY = Collections.unmodifiableSet(LOOT_TABLES);
    public static final ResourceKey<LootTable> FOX_BURY = CustomLootTables.register("entity/fox_bury_behavior");
    public static final ResourceKey<LootTable> SNIFFER_MOSS_BLOCK = CustomLootTables.register("entity/sniffer_moss");
    public static final ResourceKey<LootTable> HERO_GIFT = CustomLootTables.register("entity/hero_gift");
    public static final ResourceKey<LootTable> PICKPOCKET_ARMORER = CustomLootTables.register("villager/armorer");
    public static final ResourceKey<LootTable> PICKPOCKET_BUTCHER = CustomLootTables.register("villager/butcher");
    public static final ResourceKey<LootTable> PICKPOCKET_CARTOGRAPHER = CustomLootTables.register("villager/cartographer");
    public static final ResourceKey<LootTable> PICKPOCKET_CLERIC = CustomLootTables.register("villager/cleric");
    public static final ResourceKey<LootTable> PICKPOCKET_FARMER = CustomLootTables.register("villager/farmer");
    public static final ResourceKey<LootTable> PICKPOCKET_FISHERMAN = CustomLootTables.register("villager/fisherman");
    public static final ResourceKey<LootTable> PICKPOCKET_FLETCHER = CustomLootTables.register("villager/fletcher");
    public static final ResourceKey<LootTable> PICKPOCKET_LEATHERWORKER = CustomLootTables.register("villager/leatherworker");
    public static final ResourceKey<LootTable> PICKPOCKET_LIBRARIAN = CustomLootTables.register("villager/librarian");
    public static final ResourceKey<LootTable> PICKPOCKET_MASON = CustomLootTables.register("villager/mason");
    public static final ResourceKey<LootTable> PICKPOCKET_NITWIT = CustomLootTables.register("villager/nitwit");
    public static final ResourceKey<LootTable> PICKPOCKET_NONE = CustomLootTables.register("villager/none");
    public static final ResourceKey<LootTable> PICKPOCKET_SHEPHERD = CustomLootTables.register("villager/shepherd");
    public static final ResourceKey<LootTable> PICKPOCKET_TOOLSMITH = CustomLootTables.register("villager/toolsmith");
    public static final ResourceKey<LootTable> PICKPOCKET_WEAPONSMITH = CustomLootTables.register("villager/weaponsmith");

    private static ResourceKey<LootTable> register(String id) {
        return CustomLootTables.registerLootTable((ResourceKey<LootTable>)ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"diversity", (String)id)));
    }

    private static ResourceKey<LootTable> registerLootTable(ResourceKey<LootTable> key) {
        if (LOOT_TABLES.add(key)) {
            return key;
        }
        throw new IllegalArgumentException(String.valueOf(key.location()) + " is already a registered built-in loot table");
    }

    public static Set<ResourceKey<LootTable>> getAll() {
        return LOOT_TABLES_READ_ONLY;
    }
}

