/*
 * Decompiled with CFR 0.152.
 */
package xyz.faewulf.diversity.util.gameTests.entry.general;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import xyz.faewulf.diversity.util.config.ModConfigs;
import xyz.faewulf.lib.util.gameTests.TestGroup;

@TestGroup
public class shulkerLabel {
    public void test(GameTestHelper helper) {
        if (!ModConfigs.shulker_label) {
            helper.setBlock(8, 8, 8, Blocks.RED_CONCRETE);
        }
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        ItemStack itemStack = new ItemStack((ItemLike)Items.SHULKER_BOX, 2);
        itemStack.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)"Testing"));
        player.setItemInHand(InteractionHand.MAIN_HAND, itemStack);
        helper.startSequence().thenExecute(() -> helper.placeAt(player, itemStack, new BlockPos(4, 0, 4), Direction.UP)).thenExecuteAfter(20, () -> {
            List textDisplays = helper.getEntities(EntityType.TEXT_DISPLAY);
            if (textDisplays.size() != 1) {
                helper.fail((Component)Component.literal((String)textDisplays.toString()));
            }
        }).thenExecute(() -> helper.setBlock(4, 1, 4, Blocks.AIR)).thenExecuteAfter(20, () -> {
            List textDisplays = helper.getEntities(EntityType.TEXT_DISPLAY);
            if (!textDisplays.isEmpty()) {
                helper.fail((Component)Component.literal((String)"2nd test failed: break shulker not kill text entity"));
            }
        }).thenExecute(() -> {
            player.setShiftKeyDown(true);
            player.setPose(Pose.CROUCHING);
            helper.placeAt(player, itemStack, new BlockPos(4, 0, 4), Direction.UP);
        }).thenExecuteAfter(20, () -> {
            List textDisplays = helper.getEntities(EntityType.TEXT_DISPLAY);
            if (!textDisplays.isEmpty()) {
                helper.fail((Component)Component.literal((String)"3rd test failed: Sneak place not prevent spawn text entity"));
            }
        }).thenSucceed();
    }
}

