/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.globalMarketplace;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;
import org.texboobcat.globalMarketplace.commands.GMarketCommand;
import org.texboobcat.globalMarketplace.commands.TradeCommand;
import org.texboobcat.globalMarketplace.dao.BalanceDao;
import org.texboobcat.globalMarketplace.dao.DeliveryDao;
import org.texboobcat.globalMarketplace.dao.ListingDao;
import org.texboobcat.globalMarketplace.dao.LockDao;
import org.texboobcat.globalMarketplace.dao.LockProvider;
import org.texboobcat.globalMarketplace.dao.TransactionDao;
import org.texboobcat.globalMarketplace.economy.EconomyService;
import org.texboobcat.globalMarketplace.integrations.DiscordWebhookService;
import org.texboobcat.globalMarketplace.listeners.CreationListener;
import org.texboobcat.globalMarketplace.listeners.JoinListener;
import org.texboobcat.globalMarketplace.listeners.SearchListener;
import org.texboobcat.globalMarketplace.repo.BalanceRepository;
import org.texboobcat.globalMarketplace.repo.DeliveryQueue;
import org.texboobcat.globalMarketplace.repo.ListingRepository;
import org.texboobcat.globalMarketplace.repo.TransactionLog;
import org.texboobcat.globalMarketplace.repo.adapters.CompositeTransactionLog;
import org.texboobcat.globalMarketplace.repo.adapters.JdbcBalanceRepository;
import org.texboobcat.globalMarketplace.repo.adapters.JdbcDeliveryQueue;
import org.texboobcat.globalMarketplace.repo.adapters.JdbcListingRepository;
import org.texboobcat.globalMarketplace.repo.adapters.JdbcTransactionLog;
import org.texboobcat.globalMarketplace.service.MarketplaceService;
import org.texboobcat.globalMarketplace.service.TradeService;
import org.texboobcat.globalMarketplace.session.MoneyInputSessionManager;
import org.texboobcat.globalMarketplace.storage.DatabaseManager;
import org.texboobcat.globalMarketplace.storage.MigrationRunner;
import org.texboobcat.globalMarketplace.storage.file.FileBalanceRepository;
import org.texboobcat.globalMarketplace.storage.file.FileDeliveryQueue;
import org.texboobcat.globalMarketplace.storage.file.FileListingRepository;
import org.texboobcat.globalMarketplace.storage.file.FileTransactionLog;
import org.texboobcat.globalMarketplace.storage.file.InMemoryLockProvider;
import org.texboobcat.globalMarketplace.sync.RedisLockProvider;
import org.texboobcat.globalMarketplace.sync.RedisSync;
import org.texboobcat.globalMarketplace.ui.GuiListener;

public class GlobalMarketplacePlugin
extends JavaPlugin {
    private static GlobalMarketplacePlugin instance;
    private Economy economy;
    private DatabaseManager database;
    private RedisSync redisSync;
    private EconomyService economyService;
    private MarketplaceService marketplaceService;
    private TradeService tradeService;
    private DiscordWebhookService discordService;
    private static final int CONFIG_VERSION = 4;

    public static GlobalMarketplacePlugin getInstance() {
        return instance;
    }

    public void onEnable() {
        LockProvider lockProvider;
        DeliveryQueue deliveryQueue;
        TransactionLog txLog;
        BalanceRepository balanceRepo;
        ListingRepository listingRepo;
        String storageType;
        boolean useMySql;
        instance = this;
        this.saveDefaultConfig();
        try {
            this.checkAndMergeConfig();
        }
        catch (Exception e) {
            this.getLogger().warning("Config merge failed: " + e.getMessage());
        }
        this.saveResource("messages.yml", false);
        this.saveResource("gui/default.yml", false);
        this.setupVault();
        if (this.economy != null) {
            this.economyService = new EconomyService(this.economy);
        }
        if (useMySql = (storageType = this.getConfig().getString("database.type", "file").toLowerCase()).equals("mysql")) {
            try {
                this.initDatabase();
                MigrationRunner.runMigrations(this.database);
            }
            catch (Exception e) {
                this.getLogger().severe("Failed to initialize database: " + e.getMessage());
                e.printStackTrace();
                this.getServer().getPluginManager().disablePlugin((Plugin)this);
                return;
            }
        } else if (storageType.equals("file")) {
            this.getLogger().info("Using file-based storage backend (JSON). Initializing repositories...");
        } else {
            this.getLogger().severe("Unknown storage type: " + storageType + ". Valid options: mysql, file");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        if (useMySql) {
            TransactionLog fileTx;
            ListingDao listingDao = new ListingDao(this.database);
            BalanceDao balanceDao = new BalanceDao(this.database);
            TransactionDao transactionDao = new TransactionDao(this.database);
            DeliveryDao deliveryDao = new DeliveryDao(this.database);
            LockDao lockDao = new LockDao(this.database);
            listingRepo = new JdbcListingRepository(listingDao);
            balanceRepo = new JdbcBalanceRepository(balanceDao);
            try {
                if (!this.getDataFolder().exists()) {
                    this.getDataFolder().mkdirs();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            Path dataPath = this.getDataFolder().toPath();
            JdbcTransactionLog dbTx = new JdbcTransactionLog(transactionDao);
            try {
                fileTx = new FileTransactionLog(dataPath.resolve("transactions.json"));
            }
            catch (Exception e) {
                this.getLogger().warning("Failed to init file transaction log: " + e.getMessage());
                fileTx = dbTx;
            }
            txLog = new CompositeTransactionLog(Arrays.asList(dbTx, fileTx));
            deliveryQueue = new JdbcDeliveryQueue(deliveryDao);
            lockProvider = lockDao;
        } else {
            try {
                if (!this.getDataFolder().exists()) {
                    this.getDataFolder().mkdirs();
                }
                Path data = this.getDataFolder().toPath();
                listingRepo = new FileListingRepository(data.resolve("listings.json"));
                balanceRepo = new FileBalanceRepository(data.resolve("balances.json"));
                deliveryQueue = new FileDeliveryQueue(data.resolve("deliveries.json"));
                txLog = new FileTransactionLog(data.resolve("transactions.json"));
                lockProvider = new InMemoryLockProvider();
            }
            catch (Exception e) {
                this.getLogger().severe("Failed to initialize file-based storage: " + e.getMessage());
                e.printStackTrace();
                this.getServer().getPluginManager().disablePlugin((Plugin)this);
                return;
            }
        }
        if (this.getConfig().getBoolean("redis.locks.enabled", false)) {
            String rHost = this.getConfig().getString("redis.host", "localhost");
            int rPort = this.getConfig().getInt("redis.port", 6379);
            String rPass = this.getConfig().getString("redis.password", "");
            String keyPrefix = this.getConfig().getString("redis.locks.keyPrefix", "gmarket:lock:");
            try {
                lockProvider = new RedisLockProvider(rHost, rPort, rPass, keyPrefix);
                this.getLogger().info("Using Redis-based distributed locks at " + rHost + ":" + rPort);
            }
            catch (Exception e) {
                this.getLogger().severe("Failed to initialize Redis lock provider: " + e.getMessage());
            }
        }
        ArrayList<DiscordWebhookService.Webhook> hooks = new ArrayList<DiscordWebhookService.Webhook>();
        try {
            if (this.getConfig().isList("discord.webhooks")) {
                for (Object o : this.getConfig().getList("discord.webhooks")) {
                    if (!(o instanceof Map)) continue;
                    Map m = (Map)o;
                    String name = this.asString(m.get("name"));
                    String url = this.asString(m.get("url"));
                    String username = this.asString(m.getOrDefault("username", "GlobalMarket"));
                    String avatar = this.asString(m.getOrDefault("avatar_url", ""));
                    ArrayList<String> mentions = new ArrayList<String>();
                    Object ment = m.get("mentions");
                    if (ment instanceof List) {
                        for (Object it : (List)ment) {
                            if (it == null) continue;
                            mentions.add(String.valueOf(it));
                        }
                    }
                    String threadId = this.asString(m.get("thread_id"));
                    HashSet<DiscordWebhookService.EventType> events = new HashSet<DiscordWebhookService.EventType>();
                    Object ev = m.get("events");
                    if (ev instanceof List) {
                        for (Object e : (List)ev) {
                            if (e == null) continue;
                            try {
                                events.add(DiscordWebhookService.EventType.valueOf(e.toString().toUpperCase(Locale.ROOT)));
                            }
                            catch (IllegalArgumentException illegalArgumentException) {}
                        }
                    }
                    Boolean formatEmbed = null;
                    Boolean formatContent = null;
                    Object fmtObj = m.get("format");
                    if (fmtObj instanceof Map) {
                        Object fe = ((Map)fmtObj).get("embed");
                        Object fc = ((Map)fmtObj).get("content");
                        if (fe instanceof Boolean) {
                            formatEmbed = (Boolean)fe;
                        }
                        if (fc instanceof Boolean) {
                            formatContent = (Boolean)fc;
                        }
                    }
                    HashMap<DiscordWebhookService.EventType, Integer> colors = new HashMap<DiscordWebhookService.EventType, Integer>();
                    Object colObj = m.get("colors");
                    if (colObj instanceof Map) {
                        for (Map.Entry en : ((Map)colObj).entrySet()) {
                            if (en.getKey() == null || en.getValue() == null) continue;
                            try {
                                DiscordWebhookService.EventType et = DiscordWebhookService.EventType.valueOf(en.getKey().toString().toUpperCase(Locale.ROOT));
                                String vs = en.getValue().toString().trim();
                                if (vs.startsWith("#")) {
                                    vs = vs.substring(1);
                                }
                                int rgb = vs.matches("[0-9A-Fa-f]{6}") ? Integer.parseInt(vs, 16) : Integer.parseInt(vs);
                                colors.put(et, rgb);
                            }
                            catch (Exception exception) {}
                        }
                    }
                    if (colors.isEmpty()) {
                        colors = null;
                    }
                    HashMap<DiscordWebhookService.EventType, String> cooldowns = new HashMap<DiscordWebhookService.EventType, String>();
                    Object cdObj = m.get("cooldowns");
                    if (cdObj instanceof Map) {
                        for (Map.Entry en : ((Map)cdObj).entrySet()) {
                            if (en.getKey() == null || en.getValue() == null) continue;
                            try {
                                DiscordWebhookService.EventType et = DiscordWebhookService.EventType.valueOf(en.getKey().toString().toUpperCase(Locale.ROOT));
                                cooldowns.put(et, en.getValue().toString());
                            }
                            catch (Exception exception) {}
                        }
                    }
                    if (cooldowns.isEmpty()) {
                        cooldowns = null;
                    }
                    if (url == null || url.isEmpty()) continue;
                    hooks.add(new DiscordWebhookService.Webhook(name != null ? name : "webhook", url, events, username, avatar, mentions, threadId, formatEmbed, formatContent, colors, cooldowns));
                }
            }
        }
        catch (Exception e) {
            this.getLogger().warning("Failed to parse discord.webhooks: " + e.getMessage());
        }
        if (!hooks.isEmpty()) {
            this.discordService = new DiscordWebhookService(hooks);
            this.getLogger().info("Discord webhooks enabled: " + hooks.size());
        }
        this.marketplaceService = new MarketplaceService(listingRepo, balanceRepo, txLog, this.economyService, deliveryQueue, lockProvider, this.discordService);
        this.tradeService = new TradeService(balanceRepo, this.economyService);
        if (this.getConfig().getBoolean("redis.enabled", false)) {
            String rHost = this.getConfig().getString("redis.host", "localhost");
            int rPort = this.getConfig().getInt("redis.port", 6379);
            String rPass = this.getConfig().getString("redis.password", "");
            String rChannel = this.getConfig().getString("redis.channel", "gmarket-sync");
            this.redisSync = new RedisSync(rHost, rPort, rPass, rChannel);
            this.redisSync.start();
            this.getLogger().info("Redis sync enabled on channel '" + rChannel + "'.");
        }
        if (this.getCommand("gmarket") != null) {
            GMarketCommand gmarketCmd = new GMarketCommand();
            this.getCommand("gmarket").setExecutor((CommandExecutor)gmarketCmd);
            this.getCommand("gmarket").setTabCompleter((TabCompleter)gmarketCmd);
            TradeCommand tradeCommand = new TradeCommand();
            this.getCommand("trade").setExecutor((CommandExecutor)tradeCommand);
            this.getCommand("trade").setTabCompleter((TabCompleter)tradeCommand);
        } else {
            this.getLogger().warning("Command 'gmarket' not found in plugin.yml");
        }
        this.getServer().getPluginManager().registerEvents((Listener)new GuiListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new CreationListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new JoinListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new SearchListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)MoneyInputSessionManager.get(), (Plugin)this);
        long periodTicks = 600L;
        this.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this, () -> {
            try {
                int b;
                int a;
                if (this.marketplaceService != null && (a = this.marketplaceService.processExpiredAuctions(50)) + (b = this.marketplaceService.processExpiredListings(100)) > 0) {
                    this.getLogger().fine("Processed expirations - auctions: " + a + ", listings: " + b);
                }
                if (this.tradeService != null) {
                    this.tradeService.cleanupExpiredRequests();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }, periodTicks, periodTicks);
        this.getLogger().info("GlobalMarketplace enabled. Vault=" + (this.economy != null));
    }

    public void onDisable() {
        if (this.discordService != null) {
            try {
                this.discordService.shutdown();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.database != null) {
            this.database.close();
        }
        if (this.redisSync != null) {
            this.redisSync.stop();
        }
        this.getLogger().info("GlobalMarketplace disabled.");
    }

    public EconomyService getEconomyService() {
        return this.economyService;
    }

    public MarketplaceService getMarketplaceService() {
        return this.marketplaceService;
    }

    public TradeService getTradeService() {
        return this.tradeService;
    }

    private void setupVault() {
        if (Bukkit.getPluginManager().getPlugin("Vault") == null) {
            this.getLogger().warning("Vault not found. Economy features will be disabled until Vault is installed.");
            return;
        }
        RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            this.getLogger().warning("No Economy provider found via Vault.");
            return;
        }
        this.economy = (Economy)rsp.getProvider();
    }

    private void initDatabase() {
        String host = this.getConfig().getString("database.host", "localhost");
        int port = this.getConfig().getInt("database.port", 3306);
        String dbName = this.getConfig().getString("database.database", "global_marketplace");
        String user = this.getConfig().getString("database.username", "root");
        String pass = this.getConfig().getString("database.password", "");
        int maxPool = this.getConfig().getInt("database.pool.maximumPoolSize", 10);
        int minIdle = this.getConfig().getInt("database.pool.minimumIdle", 2);
        long timeout = this.getConfig().getLong("database.pool.connectionTimeout", 30000L);
        this.database = new DatabaseManager(host, port, dbName, user, pass, maxPool, minIdle, timeout);
    }

    public Economy getEconomy() {
        return this.economy;
    }

    public DatabaseManager getDatabase() {
        return this.database;
    }

    private String asString(Object o) {
        return o == null ? null : String.valueOf(o);
    }

    private void checkAndMergeConfig() throws Exception {
        File configFile = new File(this.getDataFolder(), "config.yml");
        if (!configFile.exists()) {
            return;
        }
        YamlConfiguration current = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader((InputStream)new FileInputStream(configFile), StandardCharsets.UTF_8));
        int curVer = current.getInt("config-version", 0);
        InputStream defStream = this.getResource("config.yml");
        if (defStream == null) {
            return;
        }
        YamlConfiguration defCfg = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defStream, StandardCharsets.UTF_8));
        int defVer = defCfg.getInt("config-version", 4);
        if (curVer >= defVer) {
            return;
        }
        this.backupConfig(configFile, curVer);
        this.mergeSections(current, defCfg, "");
        current.set("config-version", (Object)defVer);
        current.save(configFile);
        this.reloadConfig();
        this.getLogger().info("Config updated from version " + curVer + " to " + defVer + ". A backup was created.");
    }

    private void mergeSections(YamlConfiguration target, YamlConfiguration defaults, String pathPrefix) {
        YamlConfiguration defSec;
        Object object = defSec = pathPrefix.isEmpty() ? defaults : defaults.getConfigurationSection(pathPrefix);
        if (defSec == null) {
            return;
        }
        for (String key : defSec.getKeys(false)) {
            Object full = pathPrefix.isEmpty() ? key : pathPrefix + "." + key;
            Object defVal = defaults.get((String)full);
            if (defVal instanceof ConfigurationSection) {
                if (target.get((String)full) == null) {
                    target.createSection((String)full);
                }
                this.mergeSections(target, defaults, (String)full);
                continue;
            }
            if (target.isSet((String)full)) continue;
            target.set((String)full, defVal);
        }
    }

    private void backupConfig(File configFile, int curVersion) {
        try {
            String stamp = new SimpleDateFormat("yyyyMMdd-HHmmss").format(new Date());
            File backupDir = new File(this.getDataFolder(), "backup");
            if (!backupDir.exists()) {
                backupDir.mkdirs();
            }
            File backup = new File(backupDir, "config-v" + curVersion + "-" + stamp + ".yml");
            Files.copy(configFile.toPath(), backup.toPath(), new CopyOption[0]);
        }
        catch (Exception e) {
            this.getLogger().warning("Failed to backup config.yml: " + e.getMessage());
        }
    }
}

