/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.globalMarketplace.integrations;

import java.lang.invoke.CallSite;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.URL;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.texboobcat.globalMarketplace.GlobalMarketplacePlugin;
import org.texboobcat.globalMarketplace.integrations.GeyserIntegration;
import org.texboobcat.globalMarketplace.model.Listing;
import org.texboobcat.globalMarketplace.model.ListingType;
import org.texboobcat.globalMarketplace.service.MarketplaceService;
import org.texboobcat.globalMarketplace.session.CreationSessionManager;
import org.texboobcat.globalMarketplace.session.SearchSessionManager;
import org.texboobcat.globalMarketplace.ui.ListMenu;
import org.texboobcat.globalMarketplace.ui.MainMenu;
import org.texboobcat.globalMarketplace.util.ItemSerializer;

public final class BedrockMenuAdapter {
    private static final Map<String, String> IMAGE_URL_CACHE = new ConcurrentHashMap<String, String>();

    private BedrockMenuAdapter() {
    }

    public static void openMainMenu(Player player) {
        BedrockMenuAdapter.openMainMenu(player, 0, null);
    }

    private static void showConfirmPurchaseModal(UUID playerUuid, UUID listingUuid, int returnPage, String returnQuery) {
        block7: {
            try {
                Class<?> modalFormClass = Class.forName("org.geysermc.cumulus.form.ModalForm");
                Class<?> modalBuilderClass = Class.forName("org.geysermc.cumulus.form.ModalForm$Builder");
                Object builder = modalFormClass.getMethod("builder", new Class[0]).invoke(null, new Object[0]);
                modalBuilderClass.getMethod("title", String.class).invoke(builder, "Confirm Purchase");
                MarketplaceService svc = GlobalMarketplacePlugin.getInstance().getMarketplaceService();
                if (svc == null) {
                    return;
                }
                Optional<Listing> opt = svc.getListing(listingUuid);
                if (opt.isEmpty()) {
                    Player p = Bukkit.getPlayer((UUID)playerUuid);
                    if (p != null) {
                        p.sendMessage("\u00a7cListing unavailable.");
                    }
                    BedrockMenuAdapter.sendBedrockMainMenu(playerUuid, returnPage, returnQuery);
                    return;
                }
                Listing l = opt.get();
                String itemName = BedrockMenuAdapter.friendlyItemName(l);
                String content = itemName + "\nPurchase for $" + String.valueOf(l.getPrice()) + "?";
                modalBuilderClass.getMethod("content", String.class).invoke(builder, content);
                modalBuilderClass.getMethod("button1", String.class).invoke(builder, "Confirm");
                modalBuilderClass.getMethod("button2", String.class).invoke(builder, "Cancel");
                BedrockMenuAdapter.attachSimpleFormSubmitHandler(builder, response -> {
                    Integer idx = BedrockMenuAdapter.getClickedIndex(response);
                    Bukkit.getScheduler().runTask((Plugin)GlobalMarketplacePlugin.getInstance(), () -> {
                        Player p = Bukkit.getPlayer((UUID)playerUuid);
                        if (p == null || !p.isOnline() || idx == null) {
                            return;
                        }
                        if (idx == 0) {
                            boolean ok;
                            MarketplaceService svc2 = GlobalMarketplacePlugin.getInstance().getMarketplaceService();
                            boolean bl = ok = svc2 != null && svc2.purchaseFixed(playerUuid, listingUuid);
                            if (ok) {
                                int delivered = svc2.claimDeliveries(p, 36);
                                if (delivered > 0) {
                                    p.sendMessage("\u00a7aPurchase successful! Item delivered to your inventory.");
                                } else {
                                    p.sendMessage("\u00a7ePurchase successful, but your inventory was full. Use /gmarket claim to receive.");
                                }
                                BedrockMenuAdapter.sendBedrockMainMenu(playerUuid, returnPage, returnQuery);
                            } else {
                                p.sendMessage("\u00a7cPurchase failed. The listing might be unavailable or you lack funds.");
                                BedrockMenuAdapter.openListingDetail(playerUuid, listingUuid, returnPage, returnQuery);
                            }
                        } else {
                            BedrockMenuAdapter.openListingDetail(playerUuid, listingUuid, returnPage, returnQuery);
                        }
                    });
                });
                Object form = builder.getClass().getMethod("build", new Class[0]).invoke(builder, new Object[0]);
                GeyserIntegration.sendForm(playerUuid, form);
            }
            catch (Throwable t) {
                boolean ok;
                Player p = Bukkit.getPlayer((UUID)playerUuid);
                if (p == null || !p.isOnline()) break block7;
                MarketplaceService svc = GlobalMarketplacePlugin.getInstance().getMarketplaceService();
                boolean bl = ok = svc != null && svc.purchaseFixed(playerUuid, listingUuid);
                if (ok) {
                    p.sendMessage("\u00a7aPurchase placed.");
                } else {
                    p.sendMessage("\u00a7cPurchase failed.");
                }
                BedrockMenuAdapter.sendBedrockMainMenu(playerUuid, returnPage, returnQuery);
            }
        }
    }

    private static List<?> tryExtractResponseList(Object response) {
        if (response == null) {
            return null;
        }
        try {
            Object h;
            Method hasNext = response.getClass().getMethod("hasNext", new Class[0]);
            Method next = response.getClass().getMethod("next", new Class[0]);
            ArrayList<Object> out = new ArrayList<Object>();
            for (int i = 0; i < 16 && (h = hasNext.invoke(response, new Object[0])) instanceof Boolean && ((Boolean)h).booleanValue(); ++i) {
                out.add(next.invoke(response, new Object[0]));
            }
            return out;
        }
        catch (Throwable hasNext) {
            try {
                Method values = response.getClass().getMethod("values", new Class[0]);
                Object v = values.invoke(response, new Object[0]);
                if (v instanceof List) {
                    return (List)v;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return null;
        }
    }

    private static String sanitizeNumber(String s) {
        int nextDot;
        if (s == null) {
            return "";
        }
        String cleaned = s.replace(',', '.');
        int firstDot = (cleaned = cleaned.replaceAll("[^0-9.\\-]", "")).indexOf(46);
        if (firstDot >= 0 && (nextDot = cleaned.indexOf(46, firstDot + 1)) > 0) {
            cleaned = cleaned.substring(0, nextDot).replace("..", ".");
        }
        return cleaned.trim();
    }

    private static void sendBedrockSearchForm(UUID uuid, int returnPage, String returnQuery) {
        block4: {
            try {
                Class<?> customFormClass = Class.forName("org.geysermc.cumulus.form.CustomForm");
                Class<?> customBuilderClass = Class.forName("org.geysermc.cumulus.form.CustomForm$Builder");
                Object builder = customFormClass.getMethod("builder", new Class[0]).invoke(null, new Object[0]);
                customBuilderClass.getMethod("title", String.class).invoke(builder, "Search Listings");
                customBuilderClass.getMethod("input", String.class, String.class, String.class).invoke(builder, "Query", "diamond, seller:Steve", returnQuery == null ? "" : returnQuery);
                try {
                    customBuilderClass.getMethod("dropdown", String.class, String[].class).invoke(builder, "Type", new String[]{"Any", "Fixed", "Auction"});
                }
                catch (NoSuchMethodException e) {
                    customBuilderClass.getMethod("dropdown", String.class, String.class, String.class, String.class).invoke(builder, "Type", "Any", "Fixed", "Auction");
                }
                customBuilderClass.getMethod("input", String.class, String.class, String.class).invoke(builder, "Min Price", "0", "");
                customBuilderClass.getMethod("input", String.class, String.class, String.class).invoke(builder, "Max Price", "", "");
                BedrockMenuAdapter.attachSimpleFormSubmitHandler(builder, response -> {
                    try {
                        Object r = response;
                        try {
                            Object t = r.getClass().getMethod("getResult", new Class[0]).invoke(r, new Object[0]);
                            if (t != null) {
                                r = t;
                            }
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                        Method next = null;
                        try {
                            next = r.getClass().getMethod("next", new Class[0]);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        Object fr = r;
                        Method fnext = next;
                        try {
                            GlobalMarketplacePlugin.getInstance().getLogger().info("Bedrock list fixed: respClass=" + (fr != null ? fr.getClass().getName() : "null"));
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        Bukkit.getScheduler().runTask((Plugin)GlobalMarketplacePlugin.getInstance(), () -> {
                            Player p = Bukkit.getPlayer((UUID)uuid);
                            if (p == null || !p.isOnline()) {
                                return;
                            }
                            String q = "";
                            try {
                                Object v1 = fnext != null ? fnext.invoke(fr, new Object[0]) : null;
                                Object v2 = fnext != null ? fnext.invoke(fr, new Object[0]) : null;
                                Object v3 = fnext != null ? fnext.invoke(fr, new Object[0]) : null;
                                Object v4 = fnext != null ? fnext.invoke(fr, new Object[0]) : null;
                                String query = v1 instanceof String ? (String)v1 : "";
                                int typeIdx = 0;
                                if (v2 instanceof Number) {
                                    typeIdx = ((Number)v2).intValue();
                                } else if (v2 instanceof String) {
                                    String s = ((String)v2).toLowerCase(Locale.ROOT);
                                    typeIdx = s.contains("fixed") ? 1 : (s.contains("auction") ? 2 : 0);
                                }
                                String min = v3 instanceof String ? (String)v3 : "";
                                String max = v4 instanceof String ? (String)v4 : "";
                                ArrayList<Object> parts = new ArrayList<Object>();
                                if (query != null && !query.isBlank()) {
                                    parts.add(query.trim());
                                }
                                if (typeIdx == 1) {
                                    parts.add("type:fixed");
                                } else if (typeIdx == 2) {
                                    parts.add("type:auction");
                                }
                                if (min != null && !min.isBlank()) {
                                    parts.add("min:" + min.trim());
                                }
                                if (max != null && !max.isBlank()) {
                                    parts.add("max:" + max.trim());
                                }
                                q = String.join((CharSequence)" ", parts);
                            }
                            catch (Throwable ex) {
                                GlobalMarketplacePlugin.getInstance().getLogger().warning("Failed to parse search form: " + ex.getMessage());
                            }
                            BedrockMenuAdapter.sendBedrockMainMenu(uuid, 0, q);
                        });
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                });
                Object form = builder.getClass().getMethod("build", new Class[0]).invoke(builder, new Object[0]);
                GeyserIntegration.sendForm(uuid, form);
            }
            catch (Throwable t) {
                Player p = Bukkit.getPlayer((UUID)uuid);
                if (p == null) break block4;
                SearchSessionManager.get().start(p.getUniqueId());
                p.sendMessage("\u00a7eType your search in chat. Examples: \u00a77diamond\u00a7e, \u00a77seller:Steve\u00a7e, \u00a77type:auction min:100 max:500");
            }
        }
    }

    private static void openListItemMenu(UUID uuid, int returnPage, String returnQuery) {
        block2: {
            try {
                Class<?> simpleFormClass = Class.forName("org.geysermc.cumulus.form.SimpleForm");
                Class<?> simpleBuilderClass = Class.forName("org.geysermc.cumulus.form.SimpleForm$Builder");
                Class<?> buttonClass = Class.forName("org.geysermc.cumulus.component.ButtonComponent");
                Class<?> formImageClass = Class.forName("org.geysermc.cumulus.util.FormImage");
                Class<?> formImageTypeClass = Class.forName("org.geysermc.cumulus.util.FormImage$Type");
                Object builder = simpleFormClass.getMethod("builder", new Class[0]).invoke(null, new Object[0]);
                simpleBuilderClass.getMethod("title", String.class).invoke(builder, "List Item");
                simpleBuilderClass.getMethod("content", String.class).invoke(builder, "Choose listing type");
                Object btnFixed = buttonClass.getMethod("of", String.class).invoke(null, "Fixed Price");
                Object btnAuction = buttonClass.getMethod("of", String.class).invoke(null, "Auction");
                simpleBuilderClass.getMethod("button", buttonClass).invoke(builder, btnFixed);
                simpleBuilderClass.getMethod("button", buttonClass).invoke(builder, btnAuction);
                BedrockMenuAdapter.attachSimpleFormSubmitHandler(builder, response -> {
                    Integer idx = BedrockMenuAdapter.getClickedIndex(response);
                    Bukkit.getScheduler().runTask((Plugin)GlobalMarketplacePlugin.getInstance(), () -> {
                        if (idx == null) {
                            return;
                        }
                        if (idx == 0) {
                            BedrockMenuAdapter.openListFixedForm(uuid, returnPage, returnQuery);
                        } else if (idx == 1) {
                            BedrockMenuAdapter.openListAuctionForm(uuid, returnPage, returnQuery);
                        }
                    });
                });
                Object form = builder.getClass().getMethod("build", new Class[0]).invoke(builder, new Object[0]);
                GeyserIntegration.sendForm(uuid, form);
            }
            catch (Throwable t) {
                Player p = Bukkit.getPlayer((UUID)uuid);
                if (p == null) break block2;
                p.sendMessage("\u00a7eUse /gmarket list fixed <price> or /gmarket list auction <startPrice> <minutes>");
            }
        }
    }

    private static String describeItemInHand(Player p) {
        ItemStack is = p.getInventory().getItemInMainHand();
        if (is == null || is.getType() == Material.AIR) {
            return "(no item in hand)";
        }
        String name = is.hasItemMeta() && is.getItemMeta().hasDisplayName() ? is.getItemMeta().getDisplayName() : BedrockMenuAdapter.prettify(is.getType().name());
        int amt = is.getAmount();
        return name + (String)(amt > 1 ? " x" + amt : "");
    }

    private static void openListFixedForm(UUID uuid, int returnPage, String returnQuery) {
        block2: {
            try {
                Class<?> customFormClass = Class.forName("org.geysermc.cumulus.form.CustomForm");
                Class<?> customBuilderClass = Class.forName("org.geysermc.cumulus.form.CustomForm$Builder");
                Object builder = customFormClass.getMethod("builder", new Class[0]).invoke(null, new Object[0]);
                customBuilderClass.getMethod("title", String.class).invoke(builder, "List Fixed Price");
                Player p = Bukkit.getPlayer((UUID)uuid);
                String label = p != null ? "Item: " + BedrockMenuAdapter.describeItemInHand(p) : "Item from your hand";
                customBuilderClass.getMethod("label", String.class).invoke(builder, label);
                customBuilderClass.getMethod("input", String.class, String.class, String.class).invoke(builder, "Price", "100", "");
                BedrockMenuAdapter.attachSimpleFormSubmitHandler(builder, response -> {
                    try {
                        Object r = response;
                        try {
                            Object t = r.getClass().getMethod("getResult", new Class[0]).invoke(r, new Object[0]);
                            if (t != null) {
                                r = t;
                            }
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                        Method next = null;
                        try {
                            next = r.getClass().getMethod("next", new Class[0]);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        Object fr = r;
                        Method fnext = next;
                        Bukkit.getScheduler().runTask((Plugin)GlobalMarketplacePlugin.getInstance(), () -> {
                            Player pl = Bukkit.getPlayer((UUID)uuid);
                            if (pl == null || !pl.isOnline()) {
                                return;
                            }
                            try {
                                Optional created;
                                String ser;
                                BigDecimal price;
                                Object vPrice = null;
                                if (fnext != null) {
                                    vPrice = fnext.invoke(fr, new Object[0]);
                                } else {
                                    List<?> valsEarly = BedrockMenuAdapter.tryExtractResponseList(fr);
                                    if (valsEarly != null && valsEarly.size() >= 1) {
                                        vPrice = valsEarly.get(0);
                                    }
                                }
                                String priceStr = vPrice != null ? String.valueOf(vPrice).trim() : "";
                                priceStr = BedrockMenuAdapter.sanitizeNumber(priceStr);
                                try {
                                    GlobalMarketplacePlugin.getInstance().getLogger().info("Bedrock list fixed: raw=" + String.valueOf(vPrice) + " str=" + priceStr);
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                                try {
                                    price = new BigDecimal(priceStr);
                                }
                                catch (Throwable ex) {
                                    price = null;
                                }
                                if (price == null || price.signum() <= 0) {
                                    try {
                                        List<?> vals = BedrockMenuAdapter.tryExtractResponseList(fr);
                                        try {
                                            GlobalMarketplacePlugin.getInstance().getLogger().info("Bedrock list fixed: vals=" + String.valueOf(vals));
                                        }
                                        catch (Throwable throwable) {
                                            // empty catch block
                                        }
                                        if (vals != null && vals.size() >= 1) {
                                            String alt = BedrockMenuAdapter.sanitizeNumber(String.valueOf(vals.get(0)).trim());
                                            try {
                                                price = new BigDecimal(alt);
                                            }
                                            catch (Throwable ignored2) {
                                                price = null;
                                            }
                                        }
                                    }
                                    catch (Throwable vals) {
                                        // empty catch block
                                    }
                                }
                                if (price == null || price.signum() <= 0) {
                                    BedrockMenuAdapter.showInfoModal(uuid, "Invalid Price", "Please enter a valid positive price.", () -> BedrockMenuAdapter.openListFixedForm(uuid, returnPage, returnQuery));
                                    return;
                                }
                                ItemStack is = pl.getInventory().getItemInMainHand();
                                if (is == null || is.getType() == Material.AIR) {
                                    BedrockMenuAdapter.showInfoModal(uuid, "No Item", "Hold the item you want to list in your hand.", () -> BedrockMenuAdapter.openListFixedForm(uuid, returnPage, returnQuery));
                                    return;
                                }
                                try {
                                    ser = ItemSerializer.toBase64(is);
                                }
                                catch (Throwable ex) {
                                    ser = null;
                                }
                                if (ser == null || ser.isEmpty()) {
                                    BedrockMenuAdapter.showInfoModal(uuid, "Error", "Couldn't serialize item. Try again.", () -> BedrockMenuAdapter.openListFixedForm(uuid, returnPage, returnQuery));
                                    return;
                                }
                                MarketplaceService svc = GlobalMarketplacePlugin.getInstance().getMarketplaceService();
                                Optional<Object> optional = created = svc != null ? svc.createFixedListing(uuid, ser, price) : Optional.empty();
                                if (created.isPresent()) {
                                    pl.getInventory().setItemInMainHand(new ItemStack(Material.AIR));
                                    BedrockMenuAdapter.showInfoModal(uuid, "Listed", "Your fixed listing has been created!", () -> BedrockMenuAdapter.sendBedrockMainMenu(uuid, returnPage, returnQuery));
                                } else {
                                    BedrockMenuAdapter.showInfoModal(uuid, "Failed", "Couldn't create listing. Try again later.", () -> BedrockMenuAdapter.openListFixedForm(uuid, returnPage, returnQuery));
                                }
                            }
                            catch (Throwable ex) {
                                BedrockMenuAdapter.showInfoModal(uuid, "Error", "Unexpected error: " + ex.getMessage(), () -> BedrockMenuAdapter.openListFixedForm(uuid, returnPage, returnQuery));
                            }
                        });
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                });
                Object form = builder.getClass().getMethod("build", new Class[0]).invoke(builder, new Object[0]);
                GeyserIntegration.sendForm(uuid, form);
            }
            catch (Throwable t) {
                Player p = Bukkit.getPlayer((UUID)uuid);
                if (p == null) break block2;
                p.sendMessage("\u00a7eUse /gmarket list fixed <price> with the item in your hand.");
            }
        }
    }

    private static void openListAuctionForm(UUID uuid, int returnPage, String returnQuery) {
        block2: {
            try {
                Class<?> customFormClass = Class.forName("org.geysermc.cumulus.form.CustomForm");
                Class<?> customBuilderClass = Class.forName("org.geysermc.cumulus.form.CustomForm$Builder");
                Object builder = customFormClass.getMethod("builder", new Class[0]).invoke(null, new Object[0]);
                customBuilderClass.getMethod("title", String.class).invoke(builder, "List Auction");
                Player p = Bukkit.getPlayer((UUID)uuid);
                String label = p != null ? "Item: " + BedrockMenuAdapter.describeItemInHand(p) : "Item from your hand";
                customBuilderClass.getMethod("label", String.class).invoke(builder, label);
                customBuilderClass.getMethod("input", String.class, String.class, String.class).invoke(builder, "Start Price", "50", "");
                customBuilderClass.getMethod("input", String.class, String.class, String.class).invoke(builder, "Duration (minutes)", "60", "");
                BedrockMenuAdapter.attachSimpleFormSubmitHandler(builder, response -> {
                    try {
                        Object r = response;
                        try {
                            Object t = r.getClass().getMethod("getResult", new Class[0]).invoke(r, new Object[0]);
                            if (t != null) {
                                r = t;
                            }
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                        Method next = null;
                        try {
                            next = r.getClass().getMethod("next", new Class[0]);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        Object fr = r;
                        Method fnext = next;
                        Bukkit.getScheduler().runTask((Plugin)GlobalMarketplacePlugin.getInstance(), () -> {
                            Player pl = Bukkit.getPlayer((UUID)uuid);
                            if (pl == null || !pl.isOnline()) {
                                return;
                            }
                            try {
                                Optional created;
                                String ser;
                                int minutes;
                                BigDecimal start;
                                block33: {
                                    Object vStart = null;
                                    Object vDur = null;
                                    if (fnext != null) {
                                        vStart = fnext.invoke(fr, new Object[0]);
                                        vDur = fnext.invoke(fr, new Object[0]);
                                    } else {
                                        List<?> valsEarly = BedrockMenuAdapter.tryExtractResponseList(fr);
                                        if (valsEarly != null) {
                                            if (valsEarly.size() >= 1) {
                                                vStart = valsEarly.get(0);
                                            }
                                            if (valsEarly.size() >= 2) {
                                                vDur = valsEarly.get(1);
                                            }
                                        }
                                    }
                                    String startStr = vStart != null ? String.valueOf(vStart).trim() : "";
                                    String durStr = vDur != null ? String.valueOf(vDur).trim() : "";
                                    startStr = BedrockMenuAdapter.sanitizeNumber(startStr);
                                    durStr = BedrockMenuAdapter.sanitizeNumber(durStr);
                                    try {
                                        GlobalMarketplacePlugin.getInstance().getLogger().info("Bedrock list auction: rawStart=" + String.valueOf(vStart) + " rawDur=" + String.valueOf(vDur) + " startStr=" + startStr + " durStr=" + durStr);
                                    }
                                    catch (Throwable throwable) {
                                        // empty catch block
                                    }
                                    try {
                                        start = new BigDecimal(startStr);
                                    }
                                    catch (Throwable ex) {
                                        start = null;
                                    }
                                    try {
                                        minutes = Integer.parseInt(durStr);
                                    }
                                    catch (Throwable ex) {
                                        minutes = -1;
                                    }
                                    if (start == null || start.signum() <= 0 || minutes <= 0) {
                                        try {
                                            List<?> vals = BedrockMenuAdapter.tryExtractResponseList(fr);
                                            try {
                                                GlobalMarketplacePlugin.getInstance().getLogger().info("Bedrock list auction: vals=" + String.valueOf(vals));
                                            }
                                            catch (Throwable throwable) {
                                                // empty catch block
                                            }
                                            if (vals == null) break block33;
                                            if ((start == null || start.signum() <= 0) && vals.size() >= 1) {
                                                String alt = BedrockMenuAdapter.sanitizeNumber(String.valueOf(vals.get(0)).trim());
                                                try {
                                                    start = new BigDecimal(alt);
                                                }
                                                catch (Throwable ignored2) {
                                                    start = null;
                                                }
                                            }
                                            if (minutes <= 0 && vals.size() >= 2) {
                                                String altD = BedrockMenuAdapter.sanitizeNumber(String.valueOf(vals.get(1)).trim());
                                                try {
                                                    minutes = Integer.parseInt(altD);
                                                }
                                                catch (Throwable ignored2) {
                                                    minutes = -1;
                                                }
                                            }
                                        }
                                        catch (Throwable vals) {
                                            // empty catch block
                                        }
                                    }
                                }
                                if (start == null || start.signum() <= 0) {
                                    BedrockMenuAdapter.showInfoModal(uuid, "Invalid Price", "Please enter a valid positive start price.", () -> BedrockMenuAdapter.openListAuctionForm(uuid, returnPage, returnQuery));
                                    return;
                                }
                                if (minutes <= 0) {
                                    BedrockMenuAdapter.showInfoModal(uuid, "Invalid Duration", "Please enter a valid duration in minutes.", () -> BedrockMenuAdapter.openListAuctionForm(uuid, returnPage, returnQuery));
                                    return;
                                }
                                ItemStack is = pl.getInventory().getItemInMainHand();
                                if (is == null || is.getType() == Material.AIR) {
                                    BedrockMenuAdapter.showInfoModal(uuid, "No Item", "Hold the item you want to list in your hand.", () -> BedrockMenuAdapter.openListAuctionForm(uuid, returnPage, returnQuery));
                                    return;
                                }
                                try {
                                    ser = ItemSerializer.toBase64(is);
                                }
                                catch (Throwable ex) {
                                    ser = null;
                                }
                                if (ser == null || ser.isEmpty()) {
                                    BedrockMenuAdapter.showInfoModal(uuid, "Error", "Couldn't serialize item. Try again.", () -> BedrockMenuAdapter.openListAuctionForm(uuid, returnPage, returnQuery));
                                    return;
                                }
                                Instant expiry = Instant.now().plus(Duration.ofMinutes(minutes));
                                MarketplaceService svc = GlobalMarketplacePlugin.getInstance().getMarketplaceService();
                                Optional<Object> optional = created = svc != null ? svc.createAuctionListing(uuid, ser, start, expiry) : Optional.empty();
                                if (created.isPresent()) {
                                    pl.getInventory().setItemInMainHand(new ItemStack(Material.AIR));
                                    BedrockMenuAdapter.showInfoModal(uuid, "Listed", "Your auction has been created!", () -> BedrockMenuAdapter.sendBedrockMainMenu(uuid, returnPage, returnQuery));
                                } else {
                                    BedrockMenuAdapter.showInfoModal(uuid, "Failed", "Couldn't create auction. Try again later.", () -> BedrockMenuAdapter.openListAuctionForm(uuid, returnPage, returnQuery));
                                }
                            }
                            catch (Throwable ex) {
                                BedrockMenuAdapter.showInfoModal(uuid, "Error", "Unexpected error: " + ex.getMessage(), () -> BedrockMenuAdapter.openListAuctionForm(uuid, returnPage, returnQuery));
                            }
                        });
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                });
                Object form = builder.getClass().getMethod("build", new Class[0]).invoke(builder, new Object[0]);
                GeyserIntegration.sendForm(uuid, form);
            }
            catch (Throwable t) {
                Player p = Bukkit.getPlayer((UUID)uuid);
                if (p == null) break block2;
                p.sendMessage("\u00a7eUse /gmarket list auction <startPrice> <minutes> with the item in your hand.");
            }
        }
    }

    private static void showInfoModal(UUID uuid, String title, String message, Runnable after) {
        block3: {
            try {
                Class<?> modalFormClass = Class.forName("org.geysermc.cumulus.form.ModalForm");
                Class<?> modalBuilderClass = Class.forName("org.geysermc.cumulus.form.ModalForm$Builder");
                Object builder = modalFormClass.getMethod("builder", new Class[0]).invoke(null, new Object[0]);
                modalBuilderClass.getMethod("title", String.class).invoke(builder, title);
                modalBuilderClass.getMethod("content", String.class).invoke(builder, message);
                modalBuilderClass.getMethod("button1", String.class).invoke(builder, "OK");
                modalBuilderClass.getMethod("button2", String.class).invoke(builder, "Close");
                BedrockMenuAdapter.attachSimpleFormSubmitHandler(builder, resp -> Bukkit.getScheduler().runTask((Plugin)GlobalMarketplacePlugin.getInstance(), after));
                Object form = builder.getClass().getMethod("build", new Class[0]).invoke(builder, new Object[0]);
                GeyserIntegration.sendForm(uuid, form);
            }
            catch (Throwable t) {
                Player p = Bukkit.getPlayer((UUID)uuid);
                if (p != null) {
                    p.sendMessage(message);
                }
                if (after == null) break block3;
                after.run();
            }
        }
    }

    private static void attachSimpleFormSubmitHandler(Object builder, Consumer<Object> consumer) {
        try {
            String n;
            Method target = null;
            String bcn = builder.getClass().getName();
            boolean isSimple = bcn.toLowerCase(Locale.ROOT).contains("simpleform");
            if (isSimple) {
                for (Method m2 : builder.getClass().getMethods()) {
                    n = m2.getName();
                    if (!n.equals("responseHandler") || m2.getParameterCount() != 1) continue;
                    target = m2;
                    break;
                }
            }
            if (target == null) {
                for (Method m2 : builder.getClass().getMethods()) {
                    n = m2.getName();
                    if (!n.equals("validResultHandler") || m2.getParameterCount() != 1) continue;
                    target = m2;
                    break;
                }
            }
            if (target == null) {
                for (Method m2 : builder.getClass().getMethods()) {
                    n = m2.getName();
                    if (!n.equals("onSubmit") && !n.equals("onValidResult") && !n.equals("responseHandler") || m2.getParameterCount() != 1) continue;
                    target = m2;
                    break;
                }
            }
            if (target == null) {
                try {
                    Method m3 = builder.getClass().getMethod("closedResultHandler", Runnable.class);
                    m3.invoke(builder, () -> consumer.accept(null));
                }
                catch (Throwable m3) {
                    // empty catch block
                }
            }
            if (target == null) {
                return;
            }
            Class<?> funcType = target.getParameterTypes()[0];
            Object proxy = Proxy.newProxyInstance(BedrockMenuAdapter.class.getClassLoader(), new Class[]{funcType}, (p, m, args) -> {
                try {
                    String rn;
                    if (args == null) {
                        return null;
                    }
                    Object resp = null;
                    for (Object a : args) {
                        if (a == null) continue;
                        Class<?> ac = a.getClass();
                        String cn = ac.getName().toLowerCase(Locale.ROOT);
                        boolean looksLikeResponse = cn.contains("response");
                        boolean hasIndexAccessor = false;
                        try {
                            ac.getMethod("getClickedButtonId", new Class[0]);
                            hasIndexAccessor = true;
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        try {
                            ac.getMethod("clickedButtonId", new Class[0]);
                            hasIndexAccessor = true;
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        try {
                            ac.getMethod("getSelected", new Class[0]);
                            hasIndexAccessor = true;
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        try {
                            ac.getMethod("selected", new Class[0]);
                            hasIndexAccessor = true;
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        try {
                            ac.getMethod("isFirstOption", new Class[0]);
                            hasIndexAccessor = true;
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        try {
                            ac.getMethod("firstOption", new Class[0]);
                            hasIndexAccessor = true;
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        if (!looksLikeResponse && !hasIndexAccessor) continue;
                        resp = a;
                        break;
                    }
                    if (resp == null && args.length == 2) {
                        boolean a1Form;
                        Object a0 = args[0];
                        Object a1 = args[1];
                        String n0 = a0 != null ? a0.getClass().getName().toLowerCase(Locale.ROOT) : "";
                        String n1 = a1 != null ? a1.getClass().getName().toLowerCase(Locale.ROOT) : "";
                        boolean a0Form = n0.contains("form") && !n0.contains("response");
                        boolean bl = a1Form = n1.contains("form") && !n1.contains("response");
                        if (a0Form && !a1Form) {
                            resp = a1;
                        } else if (a1Form && !a0Form) {
                            resp = a0;
                        }
                    }
                    if (resp != null && (rn = resp.getClass().getName().toLowerCase(Locale.ROOT)).contains("form") && !rn.contains("response")) {
                        try {
                            Object r2 = resp.getClass().getMethod("getResult", new Class[0]).invoke(resp, new Object[0]);
                            if (r2 != null) {
                                resp = r2;
                            }
                        }
                        catch (Throwable r2) {
                            // empty catch block
                        }
                        try {
                            Object r3 = resp.getClass().getMethod("result", new Class[0]).invoke(resp, new Object[0]);
                            if (r3 != null) {
                                resp = r3;
                            }
                        }
                        catch (Throwable r3) {
                            // empty catch block
                        }
                        try {
                            Object r4 = resp.getClass().getMethod("getResponse", new Class[0]).invoke(resp, new Object[0]);
                            if (r4 != null) {
                                resp = r4;
                            }
                        }
                        catch (Throwable r4) {
                            // empty catch block
                        }
                        try {
                            Object r5 = resp.getClass().getMethod("response", new Class[0]).invoke(resp, new Object[0]);
                            if (r5 != null) {
                                resp = r5;
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    if (resp == null && args.length > 0) {
                        resp = args[0];
                    }
                    try {
                        GlobalMarketplacePlugin.getInstance().getLogger().info("Bedrock handler resp class=" + (resp != null ? resp.getClass().getName() : "null"));
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (resp != null) {
                        consumer.accept(resp);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return null;
            });
            try {
                GlobalMarketplacePlugin.getInstance().getLogger().info("Bedrock binding handler method=" + target.getName() + " on " + bcn);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            target.invoke(builder, proxy);
            try {
                Method closed = builder.getClass().getMethod("closedOrInvalidResultHandler", Runnable.class);
                closed.invoke(builder, () -> {});
            }
            catch (Throwable throwable) {}
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static Integer getClickedIndex(Object response) {
        Object b2;
        Object sel2;
        Object target;
        block51: {
            if (response == null) {
                return null;
            }
            target = response;
            try {
                String cn = response.getClass().getName();
                if (!cn.endsWith("ValidFormResponseResult")) break block51;
                try {
                    target = response.getClass().getMethod("getResponse", new Class[0]).invoke(response, new Object[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                if (target == null) {
                    try {
                        target = response.getClass().getMethod("response", new Class[0]).invoke(response, new Object[0]);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (target == null) {
                    try {
                        target = response.getClass().getMethod("getResult", new Class[0]).invoke(response, new Object[0]);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (target == null) {
                    try {
                        target = response.getClass().getMethod("result", new Class[0]).invoke(response, new Object[0]);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (target == null) {
                    target = response;
                }
            }
            catch (Throwable cn) {
                // empty catch block
            }
        }
        try {
            sel2 = target.getClass().getMethod("getClickedButtonId", new Class[0]).invoke(target, new Object[0]);
            if (sel2 instanceof Integer) {
                return (Integer)sel2;
            }
        }
        catch (Throwable sel2) {
            // empty catch block
        }
        try {
            sel2 = target.getClass().getMethod("clickedButtonId", new Class[0]).invoke(target, new Object[0]);
            if (sel2 instanceof Integer) {
                return (Integer)sel2;
            }
        }
        catch (Throwable sel3) {
            // empty catch block
        }
        try {
            sel2 = target.getClass().getMethod("getSelectedButtonId", new Class[0]).invoke(target, new Object[0]);
            if (sel2 instanceof Integer) {
                return (Integer)sel2;
            }
        }
        catch (Throwable sel4) {
            // empty catch block
        }
        try {
            sel2 = target.getClass().getMethod("selectedButtonId", new Class[0]).invoke(target, new Object[0]);
            if (sel2 instanceof Integer) {
                return (Integer)sel2;
            }
        }
        catch (Throwable sel5) {
            // empty catch block
        }
        try {
            sel2 = target.getClass().getMethod("getSelected", new Class[0]).invoke(target, new Object[0]);
            if (sel2 instanceof Integer) {
                return (Integer)sel2;
            }
        }
        catch (Throwable sel6) {
            // empty catch block
        }
        try {
            sel2 = target.getClass().getMethod("selected", new Class[0]).invoke(target, new Object[0]);
            if (sel2 instanceof Integer) {
                return (Integer)sel2;
            }
        }
        catch (Throwable sel7) {
            // empty catch block
        }
        try {
            sel2 = target.getClass().getMethod("getIndex", new Class[0]).invoke(target, new Object[0]);
            if (sel2 instanceof Integer) {
                return (Integer)sel2;
            }
        }
        catch (Throwable sel8) {
            // empty catch block
        }
        try {
            sel2 = target.getClass().getMethod("index", new Class[0]).invoke(target, new Object[0]);
            if (sel2 instanceof Integer) {
                return (Integer)sel2;
            }
        }
        catch (Throwable sel9) {
            // empty catch block
        }
        try {
            b2 = target.getClass().getMethod("isFirstOption", new Class[0]).invoke(target, new Object[0]);
            if (b2 instanceof Boolean) {
                return (Boolean)b2 != false ? 0 : 1;
            }
        }
        catch (Throwable b2) {
            // empty catch block
        }
        try {
            b2 = target.getClass().getMethod("firstOption", new Class[0]).invoke(target, new Object[0]);
            if (b2 instanceof Boolean) {
                return (Boolean)b2 != false ? 0 : 1;
            }
        }
        catch (Throwable b3) {
            // empty catch block
        }
        try {
            sel2 = target.getClass().getMethod("getButtonId", new Class[0]).invoke(target, new Object[0]);
            if (sel2 instanceof Integer) {
                return (Integer)sel2;
            }
        }
        catch (Throwable sel10) {
            // empty catch block
        }
        try {
            sel2 = target.getClass().getMethod("buttonId", new Class[0]).invoke(target, new Object[0]);
            if (sel2 instanceof Integer) {
                return (Integer)sel2;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private static void tryAttachButtonImage(Object button, String imagePath) {
        try {
            if (button == null || imagePath == null || imagePath.isEmpty()) {
                return;
            }
            Class<?> imageType = Class.forName("org.geysermc.cumulus.util.ImageType");
            Object urlEnum = null;
            for (Object c : imageType.getEnumConstants()) {
                if (!c.toString().equalsIgnoreCase("URL")) continue;
                urlEnum = c;
                break;
            }
            if (urlEnum == null) {
                return;
            }
            try {
                Method image = button.getClass().getMethod("image", imageType, String.class);
                image.invoke(button, urlEnum, imagePath);
            }
            catch (NoSuchMethodException e) {
                Method image = button.getClass().getMethod("withImage", imageType, String.class);
                image.invoke(button, urlEnum, imagePath);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void openMainMenu(Player player, int page, String query) {
        boolean bedrock;
        UUID uuid = player.getUniqueId();
        boolean bl = bedrock = GeyserIntegration.isBedrockPlayer(uuid) && GlobalMarketplacePlugin.getInstance().getConfig().getBoolean("geyser.bedrock-menus", true);
        if (!bedrock) {
            new MainMenu().open(player, page, query);
            return;
        }
        BedrockMenuAdapter.sendBedrockMainMenu(uuid, page, query);
    }

    public static void openListMenu(Player player) {
        block3: {
            boolean bedrock;
            UUID uuid = player.getUniqueId();
            boolean bl = bedrock = GeyserIntegration.isBedrockPlayer(uuid) && GlobalMarketplacePlugin.getInstance().getConfig().getBoolean("geyser.bedrock-menus", true);
            if (!bedrock) {
                new ListMenu().open(player);
                return;
            }
            try {
                Class<?> simpleFormClass = Class.forName("org.geysermc.cumulus.form.SimpleForm");
                Class<?> simpleBuilderClass = Class.forName("org.geysermc.cumulus.form.SimpleForm$Builder");
                Object builder = simpleFormClass.getMethod("builder", new Class[0]).invoke(null, new Object[0]);
                simpleBuilderClass.getMethod("title", String.class).invoke(builder, "List an Item");
                simpleBuilderClass.getMethod("content", String.class).invoke(builder, "Choose how you want to list your item.");
                Class<?> buttonClass = Class.forName("org.geysermc.cumulus.component.ButtonComponent");
                Object btnFixed = buttonClass.getMethod("of", String.class).invoke(null, "Fixed Price");
                Object btnAuction = buttonClass.getMethod("of", String.class).invoke(null, "Auction");
                simpleBuilderClass.getMethod("button", buttonClass).invoke(builder, btnFixed);
                simpleBuilderClass.getMethod("button", buttonClass).invoke(builder, btnAuction);
                BedrockMenuAdapter.attachSimpleFormSubmitHandler(builder, response -> {
                    Integer index = BedrockMenuAdapter.getClickedIndex(response);
                    Player p = Bukkit.getPlayer((UUID)uuid);
                    if (p != null && p.isOnline() && index != null) {
                        if (index == 0) {
                            CreationSessionManager.get().start(p.getUniqueId(), CreationSessionManager.Mode.FIXED);
                            p.closeInventory();
                            p.sendMessage("\u00a7eEnter price in chat (e.g., 100 or 99.99)");
                        } else if (index == 1) {
                            CreationSessionManager.get().start(p.getUniqueId(), CreationSessionManager.Mode.AUCTION);
                            p.closeInventory();
                            p.sendMessage("\u00a7eEnter start price and minutes in chat (e.g., 100 60)");
                        }
                    }
                });
                Object form = builder.getClass().getMethod("build", new Class[0]).invoke(builder, new Object[0]);
                GeyserIntegration.sendForm(uuid, form);
            }
            catch (Throwable t) {
                Player p = Bukkit.getPlayer((UUID)uuid);
                if (p == null || !p.isOnline()) break block3;
                new ListMenu().open(p);
            }
        }
    }

    private static void sendBedrockMainMenu(UUID uuid, int page, String query) {
        block15: {
            try {
                Class<?> simpleFormClass = Class.forName("org.geysermc.cumulus.form.SimpleForm");
                Class<?> simpleBuilderClass = Class.forName("org.geysermc.cumulus.form.SimpleForm$Builder");
                Class<?> buttonClass = Class.forName("org.geysermc.cumulus.component.ButtonComponent");
                Object builder = simpleFormClass.getMethod("builder", new Class[0]).invoke(null, new Object[0]);
                simpleBuilderClass.getMethod("title", String.class).invoke(builder, "Global Marketplace");
                ArrayList<UUID> ids = new ArrayList<UUID>();
                MarketplaceService svc = GlobalMarketplacePlugin.getInstance().getMarketplaceService();
                int pageSize = 10;
                List<Object> listings = svc != null ? (query == null || query.isEmpty() ? svc.getActiveListings(page, pageSize) : svc.searchActiveListings(query, page, pageSize)) : Collections.emptyList();
                String summary = query == null || query.isEmpty() ? "Browse listings" : "Search: " + query;
                simpleBuilderClass.getMethod("content", String.class).invoke(builder, summary);
                for (Listing listing : listings) {
                    String label;
                    String itemName = BedrockMenuAdapter.friendlyItemName(listing);
                    if (listing.getType() == ListingType.AUCTION) {
                        BigDecimal cur = listing.getCurrentBid() != null ? listing.getCurrentBid() : listing.getPrice();
                        label = "[Auction] $" + String.valueOf(cur) + " \u2022 " + itemName;
                    } else {
                        label = "[Fixed] $" + String.valueOf(listing.getPrice()) + " \u2022 " + itemName;
                    }
                    String img = BedrockMenuAdapter.imageUrlForListing(listing);
                    if (img != null) {
                        try {
                            GlobalMarketplacePlugin.getInstance().getLogger().fine("Bedrock image url: " + img);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    boolean added = false;
                    if (img != null) {
                        try {
                            Class<?> formImage = Class.forName("org.geysermc.cumulus.util.FormImage");
                            Class<?> typeEnum = Class.forName("org.geysermc.cumulus.util.FormImage$Type");
                            Object urlType = null;
                            for (Object c : typeEnum.getEnumConstants()) {
                                if (!c.toString().equalsIgnoreCase("URL")) continue;
                                urlType = c;
                                break;
                            }
                            if (urlType != null) {
                                Method buttonWithImg = simpleBuilderClass.getMethod("button", String.class, typeEnum, String.class);
                                buttonWithImg.invoke(builder, label, urlType, img);
                                added = true;
                            }
                        }
                        catch (Throwable formImage) {
                            // empty catch block
                        }
                    }
                    if (!added) {
                        Object btn = buttonClass.getMethod("of", String.class).invoke(null, label);
                        if (img != null) {
                            BedrockMenuAdapter.tryAttachButtonImage(btn, img);
                        }
                        simpleBuilderClass.getMethod("button", buttonClass).invoke(builder, btn);
                    }
                    ids.add(listing.getUuid());
                }
                int controlsStart = ids.size();
                Object object = buttonClass.getMethod("of", String.class).invoke(null, "Search (type in chat)");
                Object btnPrev = buttonClass.getMethod("of", String.class).invoke(null, "Previous Page");
                Object btnNext = buttonClass.getMethod("of", String.class).invoke(null, "Next Page");
                Object btnList = buttonClass.getMethod("of", String.class).invoke(null, "List Item");
                Object btnClose = buttonClass.getMethod("of", String.class).invoke(null, "Close");
                simpleBuilderClass.getMethod("button", buttonClass).invoke(builder, object);
                simpleBuilderClass.getMethod("button", buttonClass).invoke(builder, btnPrev);
                simpleBuilderClass.getMethod("button", buttonClass).invoke(builder, btnNext);
                simpleBuilderClass.getMethod("button", buttonClass).invoke(builder, btnList);
                simpleBuilderClass.getMethod("button", buttonClass).invoke(builder, btnClose);
                int finalControlsStart = controlsStart;
                BedrockMenuAdapter.attachSimpleFormSubmitHandler(builder, response -> {
                    Integer choice = BedrockMenuAdapter.getClickedIndex(response);
                    Logger log = GlobalMarketplacePlugin.getInstance().getLogger();
                    if (choice != null) {
                        log.info("Bedrock main click index=" + choice);
                    }
                    Bukkit.getScheduler().runTask((Plugin)GlobalMarketplacePlugin.getInstance(), () -> {
                        Player p = Bukkit.getPlayer((UUID)uuid);
                        if (p == null || !p.isOnline() || choice == null) {
                            log.info("Bedrock main click ignored; choice=" + choice);
                            return;
                        }
                        if (choice < finalControlsStart) {
                            UUID lid = (UUID)ids.get(choice);
                            BedrockMenuAdapter.openListingDetail(p.getUniqueId(), lid, page, query);
                        } else {
                            int offset = choice - finalControlsStart;
                            switch (offset) {
                                case 0: {
                                    BedrockMenuAdapter.sendBedrockSearchForm(uuid, page, query);
                                    break;
                                }
                                case 1: {
                                    if (page > 0) {
                                        BedrockMenuAdapter.sendBedrockMainMenu(uuid, page - 1, query);
                                        break;
                                    }
                                    BedrockMenuAdapter.sendBedrockMainMenu(uuid, 0, query);
                                    break;
                                }
                                case 2: {
                                    BedrockMenuAdapter.sendBedrockMainMenu(uuid, page + 1, query);
                                    break;
                                }
                                case 3: {
                                    BedrockMenuAdapter.openListItemMenu(uuid, page, query);
                                    break;
                                }
                            }
                        }
                    });
                });
                Object form = builder.getClass().getMethod("build", new Class[0]).invoke(builder, new Object[0]);
                GeyserIntegration.sendForm(uuid, form);
            }
            catch (Throwable t) {
                Player p = Bukkit.getPlayer((UUID)uuid);
                if (p == null || !p.isOnline()) break block15;
                new MainMenu().open(p, page, query);
            }
        }
    }

    private static void openListingDetail(UUID playerUuid, UUID listingUuid, int returnPage, String returnQuery) {
        block15: {
            try {
                boolean canAdminRemove;
                String content;
                Class<?> simpleFormClass = Class.forName("org.geysermc.cumulus.form.SimpleForm");
                Class<?> simpleBuilderClass = Class.forName("org.geysermc.cumulus.form.SimpleForm$Builder");
                Class<?> buttonClass = Class.forName("org.geysermc.cumulus.component.ButtonComponent");
                Object builder = simpleFormClass.getMethod("builder", new Class[0]).invoke(null, new Object[0]);
                simpleBuilderClass.getMethod("title", String.class).invoke(builder, "Listing Detail");
                MarketplaceService svc = GlobalMarketplacePlugin.getInstance().getMarketplaceService();
                if (svc == null) {
                    return;
                }
                Optional<Listing> opt = svc.getListing(listingUuid);
                if (opt.isEmpty()) {
                    Player p = Bukkit.getPlayer((UUID)playerUuid);
                    if (p != null) {
                        p.sendMessage("\u00a7cListing unavailable.");
                    }
                    BedrockMenuAdapter.sendBedrockMainMenu(playerUuid, returnPage, returnQuery);
                    return;
                }
                Listing l = opt.get();
                String itemName = BedrockMenuAdapter.friendlyItemName(l);
                if (l.getType() == ListingType.AUCTION) {
                    BigDecimal cur = l.getCurrentBid() != null ? l.getCurrentBid() : l.getPrice();
                    content = itemName + "\nAuction\nCurrent: $" + String.valueOf(cur) + (String)(l.getExpiresAt() != null ? "\nEnds: " + String.valueOf(l.getExpiresAt()) : "");
                } else {
                    content = itemName + "\nFixed Price\nPrice: $" + String.valueOf(l.getPrice());
                }
                simpleBuilderClass.getMethod("content", String.class).invoke(builder, content);
                boolean isOwner = l.getSellerUuid() != null && l.getSellerUuid().equals(playerUuid);
                Player permPlayer = Bukkit.getPlayer((UUID)playerUuid);
                boolean canCancel = isOwner && permPlayer != null && permPlayer.hasPermission("globalmarketplace.cancel");
                boolean bl = canAdminRemove = !isOwner && permPlayer != null && permPlayer.hasPermission("globalmarketplace.admin.remove");
                if (l.getType() == ListingType.AUCTION) {
                    int idxBid1 = 0;
                    int idxBid10 = 1;
                    int idxBid50 = 2;
                    Integer idxCancel = null;
                    Integer idxAdmin = null;
                    Object b1 = buttonClass.getMethod("of", String.class).invoke(null, "Bid +1");
                    Object b2 = buttonClass.getMethod("of", String.class).invoke(null, "Bid +10");
                    Object b3 = buttonClass.getMethod("of", String.class).invoke(null, "Bid +50");
                    simpleBuilderClass.getMethod("button", buttonClass).invoke(builder, b1);
                    simpleBuilderClass.getMethod("button", buttonClass).invoke(builder, b2);
                    simpleBuilderClass.getMethod("button", buttonClass).invoke(builder, b3);
                    int next = 3;
                    if (canCancel) {
                        Object btnCancel = buttonClass.getMethod("of", String.class).invoke(null, "\u00a76Cancel Listing (return item)");
                        simpleBuilderClass.getMethod("button", buttonClass).invoke(builder, btnCancel);
                        idxCancel = next++;
                    } else if (canAdminRemove) {
                        Object btnAdmin = buttonClass.getMethod("of", String.class).invoke(null, "\u00a7cAdmin Remove (return to seller)");
                        simpleBuilderClass.getMethod("button", buttonClass).invoke(builder, btnAdmin);
                        idxAdmin = next++;
                    }
                    Object back = buttonClass.getMethod("of", String.class).invoke(null, "Back");
                    simpleBuilderClass.getMethod("button", buttonClass).invoke(builder, back);
                    Integer idxBack = next;
                    Integer fIdxCancel = idxCancel;
                    Integer fIdxAdmin = idxAdmin;
                    Integer fIdxBack = idxBack;
                    BedrockMenuAdapter.attachSimpleFormSubmitHandler(builder, response -> {
                        Integer choice = BedrockMenuAdapter.getClickedIndex(response);
                        Logger log = GlobalMarketplacePlugin.getInstance().getLogger();
                        if (choice != null) {
                            log.fine("Bedrock auction detail click index=" + choice);
                        }
                        Bukkit.getScheduler().runTask((Plugin)GlobalMarketplacePlugin.getInstance(), () -> {
                            Player p = Bukkit.getPlayer((UUID)playerUuid);
                            if (p == null || !p.isOnline() || choice == null) {
                                return;
                            }
                            if (choice == idxBid1 || choice == idxBid10 || choice == idxBid50) {
                                int inc = choice == idxBid1 ? 1 : (choice == idxBid10 ? 10 : 50);
                                Optional<Listing> lo = GlobalMarketplacePlugin.getInstance().getMarketplaceService().getListing(listingUuid);
                                if (lo.isPresent()) {
                                    Listing ll = lo.get();
                                    BigDecimal base = ll.getCurrentBid() != null ? ll.getCurrentBid() : ll.getPrice();
                                    BigDecimal amount = base.add(new BigDecimal(inc));
                                    boolean ok = GlobalMarketplacePlugin.getInstance().getMarketplaceService().placeBid(listingUuid, playerUuid, amount);
                                    p.sendMessage((String)(ok ? "\u00a7aBid placed for $" + String.valueOf(amount) : "\u00a7cBid rejected."));
                                    BedrockMenuAdapter.openListingDetail(playerUuid, listingUuid, returnPage, returnQuery);
                                } else {
                                    p.sendMessage("\u00a7cListing not found.");
                                    BedrockMenuAdapter.sendBedrockMainMenu(playerUuid, returnPage, returnQuery);
                                }
                            } else if (fIdxCancel != null && choice == fIdxCancel) {
                                boolean ok;
                                MarketplaceService svc2 = GlobalMarketplacePlugin.getInstance().getMarketplaceService();
                                boolean bl = ok = svc2 != null && svc2.cancelListing(playerUuid, listingUuid);
                                if (ok) {
                                    int delivered = svc2.claimDeliveries(p, 36);
                                    if (delivered > 0) {
                                        p.sendMessage("\u00a7aListing cancelled. Item returned to your inventory.");
                                    } else {
                                        p.sendMessage("\u00a7aListing cancelled. \u00a7eUse /gmarket claim to retrieve the item.");
                                    }
                                    BedrockMenuAdapter.sendBedrockMainMenu(playerUuid, returnPage, returnQuery);
                                } else {
                                    p.sendMessage("\u00a7cFailed to cancel listing (not active or not owner).");
                                    BedrockMenuAdapter.openListingDetail(playerUuid, listingUuid, returnPage, returnQuery);
                                }
                            } else if (fIdxAdmin != null && choice == fIdxAdmin) {
                                MarketplaceService svc2 = GlobalMarketplacePlugin.getInstance().getMarketplaceService();
                                boolean ok = svc2 != null && svc2.adminRemoveListingReturn(listingUuid);
                                p.sendMessage(ok ? "\u00a7aListing removed and returned to seller." : "\u00a7cFailed to remove listing.");
                                BedrockMenuAdapter.sendBedrockMainMenu(playerUuid, returnPage, returnQuery);
                            } else if (choice == fIdxBack) {
                                BedrockMenuAdapter.sendBedrockMainMenu(playerUuid, returnPage, returnQuery);
                            }
                        });
                    });
                } else {
                    int idxBuy = 0;
                    Integer idxCancel = null;
                    Integer idxAdmin = null;
                    Object buy = buttonClass.getMethod("of", String.class).invoke(null, "Buy Now");
                    simpleBuilderClass.getMethod("button", buttonClass).invoke(builder, buy);
                    int next = 1;
                    if (canCancel) {
                        Object btnCancel = buttonClass.getMethod("of", String.class).invoke(null, "\u00a76Cancel Listing (return item)");
                        simpleBuilderClass.getMethod("button", buttonClass).invoke(builder, btnCancel);
                        idxCancel = next++;
                    } else if (canAdminRemove) {
                        Object btnAdmin = buttonClass.getMethod("of", String.class).invoke(null, "\u00a7cAdmin Remove (return to seller)");
                        simpleBuilderClass.getMethod("button", buttonClass).invoke(builder, btnAdmin);
                        idxAdmin = next++;
                    }
                    Object back = buttonClass.getMethod("of", String.class).invoke(null, "Back");
                    simpleBuilderClass.getMethod("button", buttonClass).invoke(builder, back);
                    Integer idxBack = next;
                    Integer fIdxCancel = idxCancel;
                    Integer fIdxAdmin = idxAdmin;
                    Integer fIdxBack = idxBack;
                    BedrockMenuAdapter.attachSimpleFormSubmitHandler(builder, response -> {
                        Integer choice = BedrockMenuAdapter.getClickedIndex(response);
                        Bukkit.getScheduler().runTask((Plugin)GlobalMarketplacePlugin.getInstance(), () -> {
                            Player p = Bukkit.getPlayer((UUID)playerUuid);
                            if (p == null || !p.isOnline() || choice == null) {
                                return;
                            }
                            if (choice == idxBuy) {
                                BedrockMenuAdapter.showConfirmPurchaseModal(p.getUniqueId(), listingUuid, returnPage, returnQuery);
                            } else if (fIdxCancel != null && choice == fIdxCancel) {
                                boolean ok;
                                MarketplaceService svc2 = GlobalMarketplacePlugin.getInstance().getMarketplaceService();
                                boolean bl = ok = svc2 != null && svc2.cancelListing(playerUuid, listingUuid);
                                if (ok) {
                                    int delivered = svc2.claimDeliveries(p, 36);
                                    if (delivered > 0) {
                                        p.sendMessage("\u00a7aListing cancelled. Item returned to your inventory.");
                                    } else {
                                        p.sendMessage("\u00a7aListing cancelled. \u00a7eUse /gmarket claim to retrieve the item.");
                                    }
                                    BedrockMenuAdapter.sendBedrockMainMenu(playerUuid, returnPage, returnQuery);
                                } else {
                                    p.sendMessage("\u00a7cFailed to cancel listing (not active or not owner).");
                                    BedrockMenuAdapter.openListingDetail(playerUuid, listingUuid, returnPage, returnQuery);
                                }
                            } else if (fIdxAdmin != null && choice == fIdxAdmin) {
                                MarketplaceService svc2 = GlobalMarketplacePlugin.getInstance().getMarketplaceService();
                                boolean ok = svc2 != null && svc2.adminRemoveListingReturn(listingUuid);
                                p.sendMessage(ok ? "\u00a7aListing removed and returned to seller." : "\u00a7cFailed to remove listing.");
                                BedrockMenuAdapter.sendBedrockMainMenu(playerUuid, returnPage, returnQuery);
                            } else if (choice == fIdxBack) {
                                BedrockMenuAdapter.sendBedrockMainMenu(playerUuid, returnPage, returnQuery);
                            }
                        });
                    });
                }
                Object form = builder.getClass().getMethod("build", new Class[0]).invoke(builder, new Object[0]);
                GeyserIntegration.sendForm(playerUuid, form);
            }
            catch (Throwable t) {
                Player p = Bukkit.getPlayer((UUID)playerUuid);
                if (p == null || !p.isOnline()) break block15;
                new MainMenu().open(p, returnPage, returnQuery);
            }
        }
    }

    private static String shortUuid(UUID id) {
        String s = id.toString();
        return s.substring(0, 8);
    }

    private static String friendlyItemName(Listing l) {
        block12: {
            try {
                String baseName;
                int amt;
                ItemStack is;
                block13: {
                    String ser = (String)l.getClass().getMethod("getItemSerialized", new Class[0]).invoke((Object)l, new Object[0]);
                    if (ser == null || ser.isEmpty() || (is = ItemSerializer.fromBase64(ser)) == null) break block12;
                    amt = is.getAmount();
                    baseName = null;
                    try {
                        ItemMeta meta = is.getItemMeta();
                        if (meta == null) break block13;
                        try {
                            Object comp = meta.getClass().getMethod("displayName", new Class[0]).invoke((Object)meta, new Object[0]);
                            if (comp != null) {
                                baseName = comp.toString();
                            }
                        }
                        catch (Throwable comp) {
                            // empty catch block
                        }
                        if (baseName == null && meta.hasDisplayName()) {
                            baseName = meta.getDisplayName();
                        }
                    }
                    catch (Throwable meta) {
                        // empty catch block
                    }
                }
                if (baseName == null || baseName.isEmpty()) {
                    Material m = is.getType();
                    String mat = m != null ? m.name() : "item";
                    baseName = BedrockMenuAdapter.prettify(mat);
                }
                if (amt > 1) {
                    return baseName + " x" + amt;
                }
                return baseName;
            }
            catch (Throwable ser) {
                // empty catch block
            }
        }
        try {
            return BedrockMenuAdapter.shortUuid(l.getUuid());
        }
        catch (Throwable ignored) {
            return "item";
        }
    }

    private static String prettify(String mat) {
        String s = mat.toLowerCase(Locale.ROOT).replace('_', ' ');
        StringBuilder b = new StringBuilder(s.length());
        boolean up = true;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (up && Character.isLetter(c)) {
                b.append(Character.toUpperCase(c));
                up = false;
            } else {
                b.append(c);
            }
            if (c != ' ') continue;
            up = true;
        }
        return b.toString();
    }

    private static String imageUrlForListing(Listing l) {
        try {
            String stripped;
            String folder;
            String mat;
            String base;
            FileConfiguration cfg;
            block49: {
                cfg = GlobalMarketplacePlugin.getInstance().getConfig();
                if (!cfg.getBoolean("geyser.images.enabled", false)) {
                    return null;
                }
                base = cfg.getString("geyser.images.base-url", "");
                mat = null;
                folder = "item";
                try {
                    Object m = l.getClass().getMethod("getItemMaterial", new Class[0]).invoke((Object)l, new Object[0]);
                    if (m != null) {
                        mat = m.toString();
                    }
                }
                catch (NoSuchMethodException m) {
                    // empty catch block
                }
                if (mat == null) {
                    Object stack = null;
                    try {
                        stack = l.getClass().getMethod("getItem", new Class[0]).invoke((Object)l, new Object[0]);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                    if (stack == null) {
                        try {
                            stack = l.getClass().getMethod("getItemStack", new Class[0]).invoke((Object)l, new Object[0]);
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            // empty catch block
                        }
                    }
                    if (stack != null && stack.getClass().getName().endsWith("ItemStack")) {
                        try {
                            Object type = stack.getClass().getMethod("getType", new Class[0]).invoke(stack, new Object[0]);
                            if (type != null) {
                                mat = type.toString();
                            }
                            try {
                                Method isItem = type.getClass().getMethod("isItem", new Class[0]);
                                Object r = isItem.invoke(type, new Object[0]);
                                if (r instanceof Boolean && !((Boolean)r).booleanValue()) {
                                    folder = "block";
                                }
                            }
                            catch (NoSuchMethodException ignored2) {
                                try {
                                    Method isBlock = type.getClass().getMethod("isBlock", new Class[0]);
                                    Object r2 = isBlock.invoke(type, new Object[0]);
                                    if (r2 instanceof Boolean && ((Boolean)r2).booleanValue()) {
                                        folder = "block";
                                    }
                                }
                                catch (Throwable isBlock) {}
                            }
                        }
                        catch (Throwable type) {
                            // empty catch block
                        }
                    }
                }
                if (mat == null) {
                    try {
                        Material t;
                        ItemStack is;
                        String ser = (String)l.getClass().getMethod("getItemSerialized", new Class[0]).invoke((Object)l, new Object[0]);
                        if (ser == null || ser.isEmpty() || (is = ItemSerializer.fromBase64(ser)) == null || (t = is.getType()) == null) break block49;
                        mat = t.name();
                        try {
                            if (!t.isItem()) {
                                folder = "block";
                            }
                        }
                        catch (Throwable isBlock) {}
                    }
                    catch (Throwable ser) {
                        // empty catch block
                    }
                }
            }
            if (mat == null) {
                return null;
            }
            String key = mat.toLowerCase(Locale.ROOT).replace(' ', '_');
            boolean probe = cfg.getBoolean("geyser.images.probe", false);
            List<String> suffixes = cfg.getStringList("geyser.images.fallback-suffixes");
            if (suffixes == null || suffixes.isEmpty()) {
                suffixes = Arrays.asList("", "_top", "_side", "_front");
            }
            Map aliasSec = null;
            try {
                ConfigurationSection sec = cfg.getConfigurationSection("geyser.images.aliases");
                if (sec != null) {
                    aliasSec = sec.getValues(false);
                }
            }
            catch (Throwable sec) {
                // empty catch block
            }
            HashMap<String, String> aliases = new HashMap<String, String>();
            if (aliasSec != null) {
                for (Map.Entry e : aliasSec.entrySet()) {
                    if (e.getValue() == null) continue;
                    aliases.put(((String)e.getKey()).toLowerCase(Locale.ROOT), e.getValue().toString());
                }
            }
            try {
                GlobalMarketplacePlugin.getInstance().getLogger().fine("Bedrock material key: " + key + " folder=" + folder);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            String cached = IMAGE_URL_CACHE.get(key);
            if (cached != null) {
                return cached;
            }
            List<String> templates = cfg.getStringList("geyser.images.templates");
            if (templates == null || templates.isEmpty()) {
                templates = Arrays.asList("https://raw.githubusercontent.com/PrismarineJS/minecraft-assets/1.21.1/assets/minecraft/textures/{folder}/{material}.png", "https://raw.githubusercontent.com/PrismarineJS/minecraft-assets/master/assets/minecraft/textures/{folder}/{material}.png", "https://assets.mcasset.cloud/1.21.1/assets/minecraft/textures/{folder}/{material}.png");
            }
            LinkedHashSet<Object> keys = new LinkedHashSet<Object>();
            String alias = (String)aliases.get(key);
            if (alias != null && !alias.isEmpty()) {
                keys.add(alias);
            }
            keys.add(key);
            String wood = BedrockMenuAdapter.woodBase(key);
            if (wood != null) {
                keys.add(wood + "_planks");
            }
            if ((stripped = BedrockMenuAdapter.stripCommonVariant(key)) != null) {
                keys.add(stripped);
            }
            ArrayList<CallSite> materialCandidates = new ArrayList<CallSite>();
            for (String string : keys) {
                for (String string2 : suffixes) {
                    materialCandidates.add((CallSite)((Object)(string + string2)));
                }
            }
            if (base != null && !base.isEmpty()) {
                for (String string : materialCandidates) {
                    String url = base.replace("{material}", string).replace("{folder}", folder);
                    if (probe && !BedrockMenuAdapter.urlExists(url)) continue;
                    IMAGE_URL_CACHE.put(key, url);
                    return url;
                }
                return null;
            }
            for (String string : templates) {
                if (string == null || string.isEmpty()) continue;
                for (String string3 : materialCandidates) {
                    String url = string.replace("{material}", string3).replace("{folder}", folder);
                    if (probe && !BedrockMenuAdapter.urlExists(url)) continue;
                    IMAGE_URL_CACHE.put(key, url);
                    return url;
                }
            }
            return null;
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    private static String woodBase(String key) {
        String[] woods;
        for (String w : woods = new String[]{"oak", "spruce", "birch", "jungle", "acacia", "dark_oak", "mangrove", "cherry", "bamboo", "crimson", "warped"}) {
            String tail;
            if (!key.startsWith(w + "_") || !(tail = key.substring(w.length() + 1)).matches("(stairs|slab|fence(_gate)?|door|trapdoor|button|pressure_plate|sign|hanging_sign)")) continue;
            return w;
        }
        return null;
    }

    private static String stripCommonVariant(String key) {
        String[] vars;
        for (String v : vars = new String[]{"_stairs", "_slab", "_wall", "_pane", "_door", "_trapdoor", "_fence_gate", "_fence", "_pressure_plate", "_button", "_carpet", "_banner", "_candle", "_sign", "_hanging_sign"}) {
            if (!key.endsWith(v)) continue;
            return key.substring(0, key.length() - v.length());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean urlExists(String urlStr) {
        HttpURLConnection conn = null;
        try {
            URL url = new URL(urlStr);
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("HEAD");
            conn.setConnectTimeout(1500);
            conn.setReadTimeout(1500);
            int code = conn.getResponseCode();
            boolean bl = code >= 200 && code < 300;
            return bl;
        }
        catch (Throwable ignored) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }
}

