/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.globalMarketplace.storage.file;

import java.sql.SQLException;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.texboobcat.globalMarketplace.dao.LockProvider;

public class InMemoryLockProvider
implements LockProvider {
    private final Map<String, Instant> locks = new ConcurrentHashMap<String, Instant>();

    @Override
    public boolean tryAcquire(String key, Duration ttl) throws SQLException {
        Instant now = Instant.now();
        Instant until = now.plus(ttl);
        return this.locks.compute(key, (k, v) -> {
            if (v == null || v.isBefore(now)) {
                return until;
            }
            return v;
        }).equals(until);
    }

    @Override
    public void release(String key) throws SQLException {
        this.locks.remove(key);
    }
}

