/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.globalMarketplace.ui;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.texboobcat.globalMarketplace.GlobalMarketplacePlugin;
import org.texboobcat.globalMarketplace.ui.GuiConfig;

public class PriceSelectionMenu {
    private static final Map<UUID, BigDecimal> playerPrices = new ConcurrentHashMap<UUID, BigDecimal>();

    private static GuiConfig.GuiSection getConfig() {
        return GuiConfig.getInstance().getSection("price_selection_menu");
    }

    public static String getTitle() {
        return PriceSelectionMenu.getConfig().getTitle();
    }

    public void open(Player player, BigDecimal startingPrice) {
        if (startingPrice == null || startingPrice.compareTo(BigDecimal.ZERO) < 0) {
            startingPrice = BigDecimal.valueOf(100L);
        }
        playerPrices.put(player.getUniqueId(), startingPrice);
        this.openWithCurrentPrice(player);
    }

    public void open(Player player) {
        this.open(player, BigDecimal.valueOf(100L));
    }

    private void openWithCurrentPrice(Player player) {
        GuiConfig.ButtonConfig priceDisplayBtn;
        GuiConfig.ButtonConfig confirmBtn;
        ItemStack inHand;
        GuiConfig.ButtonConfig itemDisplayBtn;
        GuiConfig.GuiSection config = PriceSelectionMenu.getConfig();
        int rows = config.getRows();
        Inventory inv = Bukkit.createInventory((InventoryHolder)player, (int)(rows * 9), (String)PriceSelectionMenu.getTitle());
        BigDecimal currentPrice = playerPrices.getOrDefault(player.getUniqueId(), BigDecimal.valueOf(100L));
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("price", currentPrice.toString());
        GuiConfig.FillerConfig fillerCfg = config.getFiller();
        ItemStack filler = new ItemStack(fillerCfg.getMaterial());
        ItemMeta fm = filler.getItemMeta();
        if (fm != null) {
            fm.setDisplayName(fillerCfg.getName());
            filler.setItemMeta(fm);
        }
        for (int i = 0; i < inv.getSize(); ++i) {
            inv.setItem(i, filler);
        }
        GuiConfig.ButtonConfig backBtn = config.getButton("back");
        if (backBtn != null && backBtn.getSlot() >= 0) {
            inv.setItem(backBtn.getSlot(), this.createButton(backBtn.getMaterial(), backBtn.getName(), backBtn.getLore(), "back"));
        }
        if ((itemDisplayBtn = config.getButton("item_display")) != null && itemDisplayBtn.getSlot() >= 0 && (inHand = player.getInventory().getItemInMainHand()) != null && inHand.getType() != Material.AIR) {
            ItemStack display = inHand.clone();
            ItemMeta dm = display.getItemMeta();
            if (dm != null) {
                String itemName = dm.hasDisplayName() ? dm.getDisplayName() : PriceSelectionMenu.prettify(display.getType().name());
                dm.setDisplayName("\u00a7e" + itemName);
                ArrayList<Object> lore = new ArrayList<Object>();
                lore.add("\u00a77Item to list");
                lore.add("\u00a77Amount: \u00a7f" + display.getAmount());
                dm.setLore(lore);
                display.setItemMeta(dm);
            }
            inv.setItem(itemDisplayBtn.getSlot(), display);
        }
        if ((confirmBtn = config.getButton("confirm")) != null && confirmBtn.getSlot() >= 0) {
            inv.setItem(confirmBtn.getSlot(), this.createButton(confirmBtn.getMaterial(), confirmBtn.getName(placeholders), confirmBtn.getLore(placeholders), "confirm"));
        }
        if ((priceDisplayBtn = config.getButton("price_display")) != null && priceDisplayBtn.getSlot() >= 0) {
            ItemStack priceDisplay = new ItemStack(priceDisplayBtn.getMaterial());
            ItemMeta pm = priceDisplay.getItemMeta();
            if (pm != null) {
                pm.setDisplayName(priceDisplayBtn.getName(placeholders));
                pm.setLore(priceDisplayBtn.getLore(placeholders));
                priceDisplay.setItemMeta(pm);
            }
            inv.setItem(priceDisplayBtn.getSlot(), priceDisplay);
        }
        this.addAdjustButton(inv, "adjust_minus_100");
        this.addAdjustButton(inv, "adjust_minus_50");
        this.addAdjustButton(inv, "adjust_minus_10");
        this.addAdjustButton(inv, "adjust_minus_1");
        this.addAdjustButton(inv, "adjust_plus_1");
        this.addAdjustButton(inv, "adjust_plus_10");
        this.addAdjustButton(inv, "adjust_plus_50");
        this.addAdjustButton(inv, "adjust_plus_100");
        player.openInventory(inv);
    }

    private void addAdjustButton(Inventory inv, String buttonName) {
        GuiConfig.GuiSection config = PriceSelectionMenu.getConfig();
        GuiConfig.ButtonConfig btn = config.getButton(buttonName);
        if (btn != null && btn.getSlot() >= 0) {
            inv.setItem(btn.getSlot(), this.createAdjustButton(btn.getMaterial(), btn.getName(), btn.getLore(), btn.getAdjustment()));
        }
    }

    private ItemStack createButton(Material material, String name, List<String> lore, String action) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(name);
            if (lore != null) {
                meta.setLore(lore);
            }
            NamespacedKey key = new NamespacedKey((Plugin)GlobalMarketplacePlugin.getInstance(), "gmarket_action");
            meta.getPersistentDataContainer().set(key, PersistentDataType.STRING, (Object)action);
            item.setItemMeta(meta);
        }
        return item;
    }

    private ItemStack createAdjustButton(Material material, String name, List<String> lore, int adjustment) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(name);
            if (lore != null && !lore.isEmpty()) {
                meta.setLore(lore);
            }
            NamespacedKey key = new NamespacedKey((Plugin)GlobalMarketplacePlugin.getInstance(), "gmarket_action");
            meta.getPersistentDataContainer().set(key, PersistentDataType.STRING, (Object)("adjust_price:" + adjustment));
            item.setItemMeta(meta);
        }
        return item;
    }

    public void adjustPrice(Player player, int adjustment) {
        BigDecimal current = playerPrices.getOrDefault(player.getUniqueId(), BigDecimal.valueOf(100L));
        BigDecimal newPrice = current.add(BigDecimal.valueOf(adjustment));
        if (newPrice.compareTo(BigDecimal.ZERO) < 0) {
            newPrice = BigDecimal.ZERO;
        }
        playerPrices.put(player.getUniqueId(), newPrice);
        this.openWithCurrentPrice(player);
    }

    public BigDecimal getCurrentPrice(UUID playerId) {
        return playerPrices.get(playerId);
    }

    public void clearPrice(UUID playerId) {
        playerPrices.remove(playerId);
    }

    private static String prettify(String enumName) {
        String lower = enumName.toLowerCase(Locale.ROOT).replace('_', ' ');
        String[] parts = lower.split(" ");
        StringBuilder sb = new StringBuilder();
        for (String p : parts) {
            if (p.isEmpty()) continue;
            sb.append(Character.toUpperCase(p.charAt(0))).append(p.substring(1)).append(' ');
        }
        return sb.toString().trim();
    }
}

