/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.globalMarketplace.service;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.texboobcat.globalMarketplace.model.Listing;
import org.texboobcat.globalMarketplace.repo.ListingRepository;
import org.texboobcat.globalMarketplace.util.ItemSerializer;

public class ItemValueService {
    private static final String VALUE_LORE_PREFIX = ChatColor.stripColor((String)ChatColor.translateAlternateColorCodes((char)'&', (String)"Value: $"));
    private final ListingRepository listingRepo;
    private final boolean enabled;
    private final String format;
    private final int minSales;
    private final int recentSalesLimit;
    private final ConcurrentHashMap<Material, CachedPrice> priceCache = new ConcurrentHashMap();
    private static final long CACHE_DURATION_MS = TimeUnit.MINUTES.toMillis(5L);

    public ItemValueService(ListingRepository listingRepo, boolean enabled, String format, int minSales, int recentSalesLimit) {
        this.listingRepo = listingRepo;
        this.enabled = enabled;
        this.format = format;
        this.minSales = Math.max(1, minSales);
        this.recentSalesLimit = recentSalesLimit > 0 ? recentSalesLimit : 1000;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public BigDecimal getAveragePrice(Material material) {
        if (!this.enabled || material == null) {
            return null;
        }
        CachedPrice cached = this.priceCache.get(material);
        if (cached != null && System.currentTimeMillis() - cached.timestamp < CACHE_DURATION_MS) {
            return cached.price;
        }
        BigDecimal avgPrice = this.calculateAverageFromHistory(material);
        if (avgPrice != null) {
            this.priceCache.put(material, new CachedPrice(avgPrice, System.currentTimeMillis()));
        }
        return avgPrice;
    }

    public boolean addValueLore(ItemStack item) {
        if (!this.enabled || item == null || item.getType() == Material.AIR) {
            return false;
        }
        BigDecimal avgPrice = this.getAveragePrice(item.getType());
        if (avgPrice == null) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return false;
        }
        ArrayList<String> lore = meta.hasLore() ? new ArrayList<String>(meta.getLore()) : new ArrayList();
        lore.removeIf(line -> ChatColor.stripColor((String)line).startsWith(VALUE_LORE_PREFIX.trim()));
        String formattedPrice = String.format("%.2f", avgPrice.doubleValue());
        String valueLine = ChatColor.translateAlternateColorCodes((char)'&', (String)this.format.replace("{value}", formattedPrice));
        lore.add(valueLine);
        meta.setLore(lore);
        item.setItemMeta(meta);
        return true;
    }

    public boolean hasValueLore(ItemStack item) {
        if (item == null || item.getType() == Material.AIR) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null || !meta.hasLore()) {
            return false;
        }
        return meta.getLore().stream().anyMatch(line -> ChatColor.stripColor((String)line).startsWith(VALUE_LORE_PREFIX.trim()));
    }

    public boolean removeValueLore(ItemStack item) {
        if (item == null || item.getType() == Material.AIR) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null || !meta.hasLore()) {
            return false;
        }
        ArrayList<String> lore = new ArrayList<String>(meta.getLore());
        boolean removed = lore.removeIf(line -> ChatColor.stripColor((String)line).startsWith(VALUE_LORE_PREFIX.trim()));
        if (removed) {
            if (lore.isEmpty()) {
                meta.setLore(null);
            } else {
                meta.setLore(lore);
            }
            item.setItemMeta(meta);
        }
        return removed;
    }

    private BigDecimal calculateAverageFromHistory(Material material) {
        try {
            List<Listing> recentListings = this.listingRepo.findRecentSoldListings(this.recentSalesLimit);
            ArrayList<BigDecimal> prices = new ArrayList<BigDecimal>();
            for (Listing listing : recentListings) {
                try {
                    BigDecimal salePrice;
                    ItemStack item = ItemSerializer.fromBase64(listing.getItemSerialized());
                    if (item == null || item.getType() != material || (salePrice = listing.getCurrentBid() != null ? listing.getCurrentBid() : listing.getPrice()) == null || salePrice.compareTo(BigDecimal.ZERO) <= 0) continue;
                    BigDecimal perItemPrice = salePrice.divide(BigDecimal.valueOf(item.getAmount()), 2, RoundingMode.HALF_UP);
                    prices.add(perItemPrice);
                }
                catch (Exception e) {}
            }
            if (prices.size() < this.minSales) {
                return null;
            }
            BigDecimal sum = prices.stream().reduce(BigDecimal.ZERO, BigDecimal::add);
            return sum.divide(BigDecimal.valueOf(prices.size()), 2, RoundingMode.HALF_UP);
        }
        catch (SQLException e) {
            return null;
        }
    }

    public void clearCache() {
        this.priceCache.clear();
    }

    public int updateAllItemsInInventory(Inventory inventory) {
        if (!this.enabled || inventory == null) {
            return 0;
        }
        int updated = 0;
        for (ItemStack item : inventory.getContents()) {
            if (item == null || item.getType() == Material.AIR || !this.hasValueLore(item) || !this.addValueLore(item)) continue;
            ++updated;
        }
        return updated;
    }

    private static class CachedPrice {
        final BigDecimal price;
        final long timestamp;

        CachedPrice(BigDecimal price, long timestamp) {
            this.price = price;
            this.timestamp = timestamp;
        }
    }
}

