/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.globalMarketplace.ui;

import java.math.BigDecimal;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.texboobcat.globalMarketplace.GlobalMarketplacePlugin;
import org.texboobcat.globalMarketplace.integrations.BedrockMenuAdapter;
import org.texboobcat.globalMarketplace.model.Listing;
import org.texboobcat.globalMarketplace.model.ListingType;
import org.texboobcat.globalMarketplace.model.TradeSession;
import org.texboobcat.globalMarketplace.service.MarketplaceService;
import org.texboobcat.globalMarketplace.service.TradeService;
import org.texboobcat.globalMarketplace.session.MoneyInputSessionManager;
import org.texboobcat.globalMarketplace.session.SearchSessionManager;
import org.texboobcat.globalMarketplace.ui.AuctionDurationMenu;
import org.texboobcat.globalMarketplace.ui.AuctionMenu;
import org.texboobcat.globalMarketplace.ui.GuiConfig;
import org.texboobcat.globalMarketplace.ui.ListMenu;
import org.texboobcat.globalMarketplace.ui.MainMenu;
import org.texboobcat.globalMarketplace.ui.PriceSelectionMenu;
import org.texboobcat.globalMarketplace.ui.TradeMenu;
import org.texboobcat.globalMarketplace.util.ItemSerializer;

public class GuiListener
implements Listener {
    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        String action;
        NamespacedKey keyAction;
        NamespacedKey keyAction2;
        ItemMeta meta;
        ItemStack item;
        Player player;
        if (event.getView() == null) {
            return;
        }
        String title = event.getView().getTitle();
        if (MainMenu.getTitle().equals(title)) {
            event.setCancelled(true);
            if (event.isShiftClick() || event.getClick().isKeyboardClick() || event.getClick().isCreativeAction() || event.getClick() == ClickType.DOUBLE_CLICK || event.getHotbarButton() >= 0) {
                return;
            }
            if (!(event.getWhoClicked() instanceof Player)) {
                return;
            }
            player = (Player)event.getWhoClicked();
            item = event.getCurrentItem();
            if (item == null) {
                return;
            }
            meta = item.getItemMeta();
            if (meta == null) {
                return;
            }
            NamespacedKey key = new NamespacedKey((Plugin)GlobalMarketplacePlugin.getInstance(), "gmarket_listing");
            keyAction2 = new NamespacedKey((Plugin)GlobalMarketplacePlugin.getInstance(), "gmarket_action");
            NamespacedKey keyPage = new NamespacedKey((Plugin)GlobalMarketplacePlugin.getInstance(), "gmarket_page");
            NamespacedKey keyQuery = new NamespacedKey((Plugin)GlobalMarketplacePlugin.getInstance(), "gmarket_query");
            PersistentDataContainer pdc = meta.getPersistentDataContainer();
            String action2 = (String)pdc.get(keyAction2, PersistentDataType.STRING);
            if ("open_list_menu".equals(action2)) {
                BedrockMenuAdapter.openListMenu(player);
                return;
            }
            if ("page_prev".equals(action2) || "page_next".equals(action2)) {
                Integer page = (Integer)pdc.get(keyPage, PersistentDataType.INTEGER);
                String query = (String)pdc.get(keyQuery, PersistentDataType.STRING);
                if (page == null) {
                    page = 0;
                }
                BedrockMenuAdapter.openMainMenu(player, Math.max(0, page), query);
                return;
            }
            if ("open_search".equals(action2)) {
                SearchSessionManager.get().start(player.getUniqueId());
                player.closeInventory();
                player.sendMessage("\u00a7eType your search in chat. Examples: \u00a77diamond\u00a7e, \u00a77seller:Steve\u00a7e, \u00a77type:auction min:100 max:500");
                return;
            }
            String uuidStr = (String)pdc.get(key, PersistentDataType.STRING);
            if (uuidStr == null) {
                return;
            }
            try {
                UUID listingUuid2 = UUID.fromString(uuidStr);
                MarketplaceService svc = GlobalMarketplacePlugin.getInstance().getMarketplaceService();
                if (svc == null) {
                    return;
                }
                Optional<Listing> opt = svc.getListing(listingUuid2);
                if (opt.isEmpty()) {
                    player.sendMessage("\u00a7cListing unavailable.");
                    return;
                }
                Listing l = opt.get();
                if (event.getClick() == ClickType.RIGHT) {
                    if (l.getSellerUuid().equals(player.getUniqueId())) {
                        if (!player.hasPermission("globalmarketplace.cancel")) {
                            player.sendMessage("\u00a7cYou do not have permission to cancel listings.");
                            return;
                        }
                        boolean cancelled = svc.cancelListing(player.getUniqueId(), listingUuid2);
                        if (cancelled) {
                            int delivered = svc.claimDeliveries(player, 36);
                            if (delivered > 0) {
                                player.sendMessage("\u00a7aYour listing was cancelled and the item was returned to your inventory.");
                            } else {
                                player.sendMessage("\u00a7aYour listing was cancelled. \u00a7eUse /gmarket claim to retrieve the item.");
                            }
                            BedrockMenuAdapter.openMainMenu(player);
                        } else {
                            player.sendMessage("\u00a7cFailed to cancel listing. It may no longer be active.");
                        }
                        return;
                    }
                    if (player.hasPermission("globalmarketplace.admin.remove")) {
                        boolean removed = svc.adminRemoveListingReturn(listingUuid2);
                        if (removed) {
                            player.sendMessage("\u00a7aListing removed and returned to the seller.");
                        } else {
                            player.sendMessage("\u00a7cFailed to remove listing (ensure it is ACTIVE).");
                        }
                        BedrockMenuAdapter.openMainMenu(player);
                        return;
                    }
                    player.sendMessage("\u00a7cYou cannot remove this listing.");
                    return;
                }
                if (l.getType() == ListingType.FIXED) {
                    boolean ok = svc.purchaseFixed(player.getUniqueId(), listingUuid2);
                    if (ok) {
                        int delivered = svc.claimDeliveries(player, 36);
                        if (delivered > 0) {
                            player.sendMessage("\u00a7aPurchase successful! Item delivered to your inventory.");
                        } else {
                            player.sendMessage("\u00a7ePurchase successful, but your inventory was full. Use /gmarket claim to receive.");
                        }
                        player.closeInventory();
                    } else {
                        player.sendMessage("\u00a7cPurchase failed. The listing might be unavailable or you lack funds.");
                    }
                } else if (l.getType() == ListingType.AUCTION) {
                    new AuctionMenu().open(player, listingUuid2);
                } else {
                    player.sendMessage("\u00a7eThis listing cannot be purchased from the main menu.");
                }
            }
            catch (IllegalArgumentException listingUuid2) {
                // empty catch block
            }
        }
        if (title != null && title.startsWith("Auction: ")) {
            event.setCancelled(true);
            if (event.isShiftClick() || event.getClick().isKeyboardClick() || event.getClick().isCreativeAction() || event.getClick() == ClickType.DOUBLE_CLICK || event.getHotbarButton() >= 0) {
                return;
            }
            if (!(event.getWhoClicked() instanceof Player)) {
                return;
            }
            player = (Player)event.getWhoClicked();
            item = event.getCurrentItem();
            if (item == null) {
                return;
            }
            meta = item.getItemMeta();
            if (meta == null) {
                return;
            }
            NamespacedKey keyListing = new NamespacedKey((Plugin)GlobalMarketplacePlugin.getInstance(), "gmarket_listing");
            keyAction2 = new NamespacedKey((Plugin)GlobalMarketplacePlugin.getInstance(), "gmarket_action");
            PersistentDataContainer pdc = meta.getPersistentDataContainer();
            String uuidStr = (String)pdc.get(keyListing, PersistentDataType.STRING);
            String action3 = (String)pdc.get(keyAction2, PersistentDataType.STRING);
            if (uuidStr == null || action3 == null) {
                return;
            }
            try {
                UUID listingUuid = UUID.fromString(uuidStr);
                int inc = 0;
                if (action3.startsWith("bid:+")) {
                    try {
                        inc = Integer.parseInt(action3.substring(5));
                    }
                    catch (NumberFormatException listingUuid2) {
                        // empty catch block
                    }
                }
                if (inc <= 0) {
                    return;
                }
                MarketplaceService svc = GlobalMarketplacePlugin.getInstance().getMarketplaceService();
                if (svc == null) {
                    return;
                }
                Optional<Listing> opt = svc.getListing(listingUuid);
                if (opt.isEmpty()) {
                    player.sendMessage("\u00a7cListing not found.");
                    return;
                }
                Listing l = opt.get();
                BigDecimal base = l.getCurrentBid() != null ? l.getCurrentBid() : l.getPrice();
                BigDecimal amount = base.add(new BigDecimal(inc));
                boolean ok = svc.placeBid(listingUuid, player.getUniqueId(), amount);
                String currencySymbol = GuiConfig.getInstance().getCurrencySymbol();
                player.sendMessage((String)(ok ? "\u00a7aBid placed for " + currencySymbol + String.valueOf(amount) : "\u00a7cBid rejected."));
                new AuctionMenu().open(player, listingUuid);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (ListMenu.getTitle().equals(title)) {
            event.setCancelled(true);
            if (event.isShiftClick() || event.getClick().isKeyboardClick() || event.getClick().isCreativeAction() || event.getClick() == ClickType.DOUBLE_CLICK || event.getHotbarButton() >= 0) {
                return;
            }
            if (!(event.getWhoClicked() instanceof Player)) {
                return;
            }
            player = (Player)event.getWhoClicked();
            item = event.getCurrentItem();
            if (item == null) {
                return;
            }
            meta = item.getItemMeta();
            if (meta == null) {
                return;
            }
            keyAction = new NamespacedKey((Plugin)GlobalMarketplacePlugin.getInstance(), "gmarket_action");
            action = (String)meta.getPersistentDataContainer().get(keyAction, PersistentDataType.STRING);
            if (action == null) {
                return;
            }
            if (action.equals("list_fixed")) {
                inHand = player.getInventory().getItemInMainHand();
                if (inHand == null || inHand.getType() == Material.AIR) {
                    player.closeInventory();
                    player.sendMessage("\u00a7cHold the item you want to list in your main hand.");
                    return;
                }
                new PriceSelectionMenu().open(player);
            } else if (action.equals("list_auction")) {
                inHand = player.getInventory().getItemInMainHand();
                if (inHand == null || inHand.getType() == Material.AIR) {
                    player.closeInventory();
                    player.sendMessage("\u00a7cHold the item you want to auction in your main hand.");
                    return;
                }
                new AuctionDurationMenu().open(player);
            }
        }
        if (PriceSelectionMenu.getTitle().equals(title)) {
            event.setCancelled(true);
            if (event.isShiftClick() || event.getClick().isKeyboardClick() || event.getClick().isCreativeAction() || event.getClick() == ClickType.DOUBLE_CLICK || event.getHotbarButton() >= 0) {
                return;
            }
            if (!(event.getWhoClicked() instanceof Player)) {
                return;
            }
            player = (Player)event.getWhoClicked();
            item = event.getCurrentItem();
            if (item == null) {
                return;
            }
            meta = item.getItemMeta();
            if (meta == null) {
                return;
            }
            keyAction = new NamespacedKey((Plugin)GlobalMarketplacePlugin.getInstance(), "gmarket_action");
            action = (String)meta.getPersistentDataContainer().get(keyAction, PersistentDataType.STRING);
            if (action == null) {
                return;
            }
            if (action.equals("back")) {
                new PriceSelectionMenu().clearPrice(player.getUniqueId());
                new ListMenu().open(player);
                return;
            }
            if (action.equals("confirm")) {
                this.handlePriceConfirm(player);
                return;
            }
            if (action.startsWith("adjust_price:")) {
                try {
                    int adjustment = Integer.parseInt(action.substring(13));
                    new PriceSelectionMenu().adjustPrice(player, adjustment);
                }
                catch (NumberFormatException adjustment) {
                    // empty catch block
                }
                return;
            }
        }
        if (AuctionDurationMenu.getTitle().equals(title)) {
            event.setCancelled(true);
            if (event.isShiftClick() || event.getClick().isKeyboardClick() || event.getClick().isCreativeAction() || event.getClick() == ClickType.DOUBLE_CLICK || event.getHotbarButton() >= 0) {
                return;
            }
            if (!(event.getWhoClicked() instanceof Player)) {
                return;
            }
            player = (Player)event.getWhoClicked();
            item = event.getCurrentItem();
            if (item == null) {
                return;
            }
            meta = item.getItemMeta();
            if (meta == null) {
                return;
            }
            keyAction = new NamespacedKey((Plugin)GlobalMarketplacePlugin.getInstance(), "gmarket_action");
            action = (String)meta.getPersistentDataContainer().get(keyAction, PersistentDataType.STRING);
            if (action == null) {
                return;
            }
            if (action.equals("back")) {
                new AuctionDurationMenu().clearSettings(player.getUniqueId());
                new ListMenu().open(player);
                return;
            }
            if (action.equals("confirm")) {
                this.handleAuctionConfirm(player);
                return;
            }
            if (action.startsWith("adjust_duration:")) {
                try {
                    int adjustment = Integer.parseInt(action.substring(16));
                    new AuctionDurationMenu().adjustDuration(player, adjustment);
                }
                catch (NumberFormatException adjustment) {
                    // empty catch block
                }
                return;
            }
            if (action.startsWith("adjust_price:")) {
                try {
                    int adjustment = Integer.parseInt(action.substring(13));
                    new AuctionDurationMenu().adjustPrice(player, adjustment);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                return;
            }
        }
        if (title != null && title.startsWith("Trade: ")) {
            if (!(event.getWhoClicked() instanceof Player)) {
                return;
            }
            player = (Player)event.getWhoClicked();
            int topSize = event.getView().getTopInventory().getSize();
            if (event.isShiftClick() || event.getClick().isKeyboardClick() || event.getClick().isCreativeAction() || event.getClick() == ClickType.DOUBLE_CLICK || event.getHotbarButton() >= 0) {
                event.setCancelled(true);
                return;
            }
            if (event.getRawSlot() < topSize) {
                event.setCancelled(true);
                this.handleTradeMenuClick(event, player);
                return;
            }
        }
    }

    @EventHandler
    public void onInventoryDrag(InventoryDragEvent event) {
        if (event.getView() == null) {
            return;
        }
        String title = event.getView().getTitle();
        if (MainMenu.getTitle().equals(title)) {
            event.setCancelled(true);
        }
        if (title != null && title.startsWith("Auction: ")) {
            event.setCancelled(true);
        }
        if (PriceSelectionMenu.getTitle().equals(title)) {
            event.setCancelled(true);
        }
        if (AuctionDurationMenu.getTitle().equals(title)) {
            event.setCancelled(true);
        }
        if (ListMenu.getTitle().equals(title)) {
            event.setCancelled(true);
        }
        if (title != null && title.startsWith("Trade: ")) {
            int[] nArray;
            boolean targetsTop = false;
            int topSize = event.getView().getTopInventory().getSize();
            Iterator iterator = event.getRawSlots().iterator();
            while (iterator.hasNext()) {
                int raw = (Integer)iterator.next();
                if (raw >= topSize) continue;
                targetsTop = true;
                break;
            }
            if (!targetsTop) {
                return;
            }
            event.setCancelled(true);
            if (!(event.getWhoClicked() instanceof Player)) {
                return;
            }
            Player player = (Player)event.getWhoClicked();
            TradeService tradeService = GlobalMarketplacePlugin.getInstance().getTradeService();
            TradeSession session = tradeService.getPlayerTradeSession(player.getUniqueId());
            if (session == null) {
                return;
            }
            if (session.isPlayer1(player.getUniqueId())) {
                int[] nArray2 = new int[16];
                nArray2[0] = 0;
                nArray2[1] = 1;
                nArray2[2] = 2;
                nArray2[3] = 3;
                nArray2[4] = 9;
                nArray2[5] = 10;
                nArray2[6] = 11;
                nArray2[7] = 12;
                nArray2[8] = 18;
                nArray2[9] = 19;
                nArray2[10] = 20;
                nArray2[11] = 21;
                nArray2[12] = 27;
                nArray2[13] = 28;
                nArray2[14] = 29;
                nArray = nArray2;
                nArray2[15] = 30;
            } else {
                int[] nArray3 = new int[16];
                nArray3[0] = 5;
                nArray3[1] = 6;
                nArray3[2] = 7;
                nArray3[3] = 8;
                nArray3[4] = 14;
                nArray3[5] = 15;
                nArray3[6] = 16;
                nArray3[7] = 17;
                nArray3[8] = 23;
                nArray3[9] = 24;
                nArray3[10] = 25;
                nArray3[11] = 26;
                nArray3[12] = 32;
                nArray3[13] = 33;
                nArray3[14] = 34;
                nArray = nArray3;
                nArray3[15] = 35;
            }
            int[] playerSlots = nArray;
            HashSet<Integer> allowed = new HashSet<Integer>();
            for (int s : playerSlots) {
                allowed.add(s);
            }
            boolean valid = true;
            Iterator iterator2 = event.getRawSlots().iterator();
            while (iterator2.hasNext()) {
                int raw = (Integer)iterator2.next();
                if (raw >= event.getView().getTopInventory().getSize()) {
                    valid = false;
                    break;
                }
                if (allowed.contains(raw)) continue;
                valid = false;
                break;
            }
            if (!valid) {
                return;
            }
            ItemStack cursor = event.getOldCursor();
            if (cursor != null && !cursor.getType().isAir()) {
                ItemStack toAdd = cursor.clone();
                if (tradeService.addItemToTrade(player.getUniqueId(), toAdd)) {
                    event.getView().setCursor(null);
                    this.refreshTradeForBoth(session, player.getUniqueId());
                }
            }
        }
    }

    private void handleTradeMenuClick(InventoryClickEvent event, Player player) {
        ItemStack item;
        int[] nArray;
        TradeService tradeService = GlobalMarketplacePlugin.getInstance().getTradeService();
        TradeSession session = tradeService.getPlayerTradeSession(player.getUniqueId());
        if (session == null) {
            return;
        }
        if (session.isPlayer1(player.getUniqueId())) {
            int[] nArray2 = new int[16];
            nArray2[0] = 0;
            nArray2[1] = 1;
            nArray2[2] = 2;
            nArray2[3] = 3;
            nArray2[4] = 9;
            nArray2[5] = 10;
            nArray2[6] = 11;
            nArray2[7] = 12;
            nArray2[8] = 18;
            nArray2[9] = 19;
            nArray2[10] = 20;
            nArray2[11] = 21;
            nArray2[12] = 27;
            nArray2[13] = 28;
            nArray2[14] = 29;
            nArray = nArray2;
            nArray2[15] = 30;
        } else {
            int[] nArray3 = new int[16];
            nArray3[0] = 5;
            nArray3[1] = 6;
            nArray3[2] = 7;
            nArray3[3] = 8;
            nArray3[4] = 14;
            nArray3[5] = 15;
            nArray3[6] = 16;
            nArray3[7] = 17;
            nArray3[8] = 23;
            nArray3[9] = 24;
            nArray3[10] = 25;
            nArray3[11] = 26;
            nArray3[12] = 32;
            nArray3[13] = 33;
            nArray3[14] = 34;
            nArray = nArray3;
            nArray3[15] = 35;
        }
        int[] playerSlots = nArray;
        HashSet<Integer> allowed = new HashSet<Integer>();
        for (int s : playerSlots) {
            allowed.add(s);
        }
        int rawSlot = event.getRawSlot();
        if (rawSlot < event.getView().getTopInventory().getSize() && allowed.contains(rawSlot)) {
            ItemStack cursor = event.getCursor();
            ItemStack current = event.getCurrentItem();
            if ((current == null || current.getType().isAir()) && cursor != null && !cursor.getType().isAir()) {
                event.setCancelled(true);
                ItemStack toAdd = cursor.clone();
                if (tradeService.addItemToTrade(player.getUniqueId(), toAdd)) {
                    event.getView().setCursor(null);
                    this.refreshTradeForBoth(session, player.getUniqueId());
                }
                return;
            }
        }
        if ((item = event.getCurrentItem()) == null) {
            return;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return;
        }
        NamespacedKey actionKey = new NamespacedKey((Plugin)GlobalMarketplacePlugin.getInstance(), "trade_action");
        String action = (String)meta.getPersistentDataContainer().get(actionKey, PersistentDataType.STRING);
        if (action == null) {
            return;
        }
        switch (action) {
            case "ready": {
                tradeService.setPlayerReady(player.getUniqueId(), true);
                this.refreshTradeForBoth(session, player.getUniqueId());
                break;
            }
            case "unready": {
                tradeService.setPlayerReady(player.getUniqueId(), false);
                this.refreshTradeForBoth(session, player.getUniqueId());
                break;
            }
            case "confirm": {
                if (!tradeService.confirmTrade(player.getUniqueId())) break;
                player.sendMessage("\u00a7aTrade confirmed!");
                this.refreshTradeForBoth(session, player.getUniqueId());
                break;
            }
            case "unconfirm": {
                if (session.isPlayer1(player.getUniqueId())) {
                    session.setPlayer1Confirmed(false);
                } else {
                    session.setPlayer2Confirmed(false);
                }
                this.refreshTradeForBoth(session, player.getUniqueId());
                break;
            }
            case "cancel": {
                tradeService.cancelTrade(player.getUniqueId());
                break;
            }
            case "set_money": {
                MoneyInputSessionManager.get().start(player.getUniqueId(), session.getSessionId());
                player.closeInventory();
                player.sendMessage("\u00a7eEnter the amount of money to add to the trade (e.g., 100 or 99.99):");
                break;
            }
            default: {
                if (!action.startsWith("remove_item:")) break;
                try {
                    ItemStack toReturn;
                    int index = Integer.parseInt(action.substring(12));
                    List<ItemStack> list = session.isPlayer1(player.getUniqueId()) ? session.getPlayer1Items() : session.getPlayer2Items();
                    ItemStack itemStack = toReturn = index >= 0 && index < list.size() ? list.get(index).clone() : null;
                    if (!tradeService.removeItemFromTrade(player.getUniqueId(), index)) break;
                    if (toReturn != null) {
                        HashMap leftovers = player.getInventory().addItem(new ItemStack[]{toReturn});
                        for (ItemStack left : leftovers.values()) {
                            player.getWorld().dropItemNaturally(player.getLocation(), left);
                        }
                    }
                    player.sendMessage("\u00a7aItem removed from trade.");
                    this.refreshTradeForBoth(session, player.getUniqueId());
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }

    private void refreshTradeForBoth(TradeSession session, UUID actor) {
        Player self;
        Player other = Bukkit.getPlayer((UUID)session.getOtherPlayer(actor));
        if (other != null && other.isOnline()) {
            new TradeMenu().open(other, session.getSessionId());
        }
        if ((self = Bukkit.getPlayer((UUID)actor)) != null && self.isOnline()) {
            new TradeMenu().open(self, session.getSessionId());
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        Player player;
        String title;
        String string = title = event.getView() == null ? null : event.getView().getTitle();
        if (title != null && title.startsWith("Trade: ") && event.getPlayer() instanceof Player) {
            player = (Player)event.getPlayer();
            GlobalMarketplacePlugin.getInstance().getServer().getScheduler().runTaskLater((Plugin)GlobalMarketplacePlugin.getInstance(), () -> {
                String current;
                String string = current = player.getOpenInventory() != null ? player.getOpenInventory().getTitle() : null;
                if (current != null && current.startsWith("Trade: ")) {
                    return;
                }
                if (MoneyInputSessionManager.get().isInSession(player.getUniqueId())) {
                    return;
                }
                TradeService tradeService = GlobalMarketplacePlugin.getInstance().getTradeService();
                TradeSession session = tradeService.getPlayerTradeSession(player.getUniqueId());
                if (session != null && session.getStatus() == TradeSession.TradeSessionStatus.ACTIVE) {
                    tradeService.cancelTrade(player.getUniqueId());
                }
            }, 1L);
        }
        if (PriceSelectionMenu.getTitle().equals(title) && event.getPlayer() instanceof Player) {
            player = (Player)event.getPlayer();
            GlobalMarketplacePlugin.getInstance().getServer().getScheduler().runTaskLater((Plugin)GlobalMarketplacePlugin.getInstance(), () -> {
                String current;
                String string = current = player.getOpenInventory() != null ? player.getOpenInventory().getTitle() : null;
                if (!PriceSelectionMenu.getTitle().equals(current)) {
                    new PriceSelectionMenu().clearPrice(player.getUniqueId());
                }
            }, 1L);
        }
        if (AuctionDurationMenu.getTitle().equals(title) && event.getPlayer() instanceof Player) {
            player = (Player)event.getPlayer();
            GlobalMarketplacePlugin.getInstance().getServer().getScheduler().runTaskLater((Plugin)GlobalMarketplacePlugin.getInstance(), () -> {
                String current;
                String string = current = player.getOpenInventory() != null ? player.getOpenInventory().getTitle() : null;
                if (!AuctionDurationMenu.getTitle().equals(current)) {
                    new AuctionDurationMenu().clearSettings(player.getUniqueId());
                }
            }, 1L);
        }
    }

    private void handlePriceConfirm(Player player) {
        PriceSelectionMenu menu = new PriceSelectionMenu();
        BigDecimal price = menu.getCurrentPrice(player.getUniqueId());
        if (price == null || price.compareTo(BigDecimal.ZERO) <= 0) {
            player.sendMessage("\u00a7cInvalid price. Please set a price greater than 0.");
            return;
        }
        ItemStack inHand = player.getInventory().getItemInMainHand();
        if (inHand == null || inHand.getType() == Material.AIR) {
            player.closeInventory();
            player.sendMessage("\u00a7cYou must hold an item in your main hand to list it.");
            menu.clearPrice(player.getUniqueId());
            return;
        }
        MarketplaceService svc = GlobalMarketplacePlugin.getInstance().getMarketplaceService();
        if (svc == null) {
            player.sendMessage("\u00a7cMarketplace unavailable.");
            player.closeInventory();
            menu.clearPrice(player.getUniqueId());
            return;
        }
        try {
            ItemMeta liveMeta;
            NamespacedKey tokenKey = new NamespacedKey((Plugin)GlobalMarketplacePlugin.getInstance(), "gmarket_item_id");
            UUID listingId = UUID.randomUUID();
            ItemStack toSerialize = inHand.clone();
            ItemMeta cloneMeta = toSerialize.getItemMeta();
            if (cloneMeta != null) {
                cloneMeta.getPersistentDataContainer().set(tokenKey, PersistentDataType.STRING, (Object)listingId.toString());
                toSerialize.setItemMeta(cloneMeta);
            }
            if ((liveMeta = inHand.getItemMeta()) != null) {
                liveMeta.getPersistentDataContainer().set(tokenKey, PersistentDataType.STRING, (Object)listingId.toString());
                inHand.setItemMeta(liveMeta);
            }
            String serialized = ItemSerializer.toBase64(toSerialize);
            Optional<UUID> created = svc.createFixedListing(listingId, player.getUniqueId(), serialized, price);
            if (created.isPresent()) {
                ItemMeta cm;
                ItemStack current = player.getInventory().getItemInMainHand();
                boolean tokenOk = false;
                if (current != null && (cm = current.getItemMeta()) != null) {
                    String val = (String)cm.getPersistentDataContainer().get(tokenKey, PersistentDataType.STRING);
                    tokenOk = listingId.toString().equals(val);
                }
                if (!tokenOk) {
                    player.sendMessage("\u00a7cListing aborted: held item changed during creation.");
                    player.closeInventory();
                    menu.clearPrice(player.getUniqueId());
                    return;
                }
                player.getInventory().setItemInMainHand(new ItemStack(Material.AIR));
                String currencySymbol = GuiConfig.getInstance().getCurrencySymbol();
                player.sendMessage("\u00a7aFixed listing created for " + currencySymbol + String.valueOf(price) + "!");
                player.closeInventory();
                menu.clearPrice(player.getUniqueId());
            } else {
                player.sendMessage("\u00a7cFailed to create listing. Please try again.");
                ItemMeta lm = inHand.getItemMeta();
                if (lm != null) {
                    lm.getPersistentDataContainer().remove(tokenKey);
                    inHand.setItemMeta(lm);
                }
            }
        }
        catch (Exception ex) {
            player.sendMessage("\u00a7cAn error occurred while creating the listing.");
            GlobalMarketplacePlugin.getInstance().getLogger().warning("Failed to create listing: " + ex.getMessage());
            ex.printStackTrace();
        }
        menu.clearPrice(player.getUniqueId());
    }

    private void handleAuctionConfirm(Player player) {
        AuctionDurationMenu menu = new AuctionDurationMenu();
        AuctionDurationMenu.AuctionSettings settings = menu.getCurrentSettings(player.getUniqueId());
        if (settings == null) {
            player.sendMessage("\u00a7cAuction settings not found. Please try again.");
            player.closeInventory();
            return;
        }
        if (settings.price == null || settings.price.compareTo(BigDecimal.ZERO) <= 0) {
            player.sendMessage("\u00a7cInvalid starting price. Please set a price greater than 0.");
            return;
        }
        if (settings.durationMinutes <= 0) {
            player.sendMessage("\u00a7cInvalid duration. Please set a duration greater than 0 minutes.");
            return;
        }
        ItemStack inHand = player.getInventory().getItemInMainHand();
        if (inHand == null || inHand.getType() == Material.AIR) {
            player.closeInventory();
            player.sendMessage("\u00a7cYou must hold an item in your main hand to auction it.");
            menu.clearSettings(player.getUniqueId());
            return;
        }
        MarketplaceService svc = GlobalMarketplacePlugin.getInstance().getMarketplaceService();
        if (svc == null) {
            player.sendMessage("\u00a7cMarketplace unavailable.");
            player.closeInventory();
            menu.clearSettings(player.getUniqueId());
            return;
        }
        try {
            ItemMeta liveMeta;
            NamespacedKey tokenKey = new NamespacedKey((Plugin)GlobalMarketplacePlugin.getInstance(), "gmarket_item_id");
            UUID listingId = UUID.randomUUID();
            ItemStack toSerialize = inHand.clone();
            ItemMeta cloneMeta = toSerialize.getItemMeta();
            if (cloneMeta != null) {
                cloneMeta.getPersistentDataContainer().set(tokenKey, PersistentDataType.STRING, (Object)listingId.toString());
                toSerialize.setItemMeta(cloneMeta);
            }
            if ((liveMeta = inHand.getItemMeta()) != null) {
                liveMeta.getPersistentDataContainer().set(tokenKey, PersistentDataType.STRING, (Object)listingId.toString());
                inHand.setItemMeta(liveMeta);
            }
            Instant endTime = Instant.now().plus(Duration.ofMinutes(settings.durationMinutes));
            String serialized = ItemSerializer.toBase64(toSerialize);
            Optional<UUID> created = svc.createAuctionListing(listingId, player.getUniqueId(), serialized, settings.price, endTime);
            if (created.isPresent()) {
                int days;
                int hours;
                ItemMeta cm;
                ItemStack current = player.getInventory().getItemInMainHand();
                boolean tokenOk = false;
                if (current != null && (cm = current.getItemMeta()) != null) {
                    String val = (String)cm.getPersistentDataContainer().get(tokenKey, PersistentDataType.STRING);
                    tokenOk = listingId.toString().equals(val);
                }
                if (!tokenOk) {
                    player.sendMessage("\u00a7cAuction aborted: held item changed during creation.");
                    player.closeInventory();
                    menu.clearSettings(player.getUniqueId());
                    return;
                }
                player.getInventory().setItemInMainHand(new ItemStack(Material.AIR));
                String durationStr = settings.durationMinutes < 60 ? settings.durationMinutes + " minute" + (settings.durationMinutes != 1 ? "s" : "") : (settings.durationMinutes < 1440 ? hours + " hour" + ((hours = settings.durationMinutes / 60) != 1 ? "s" : "") : days + " day" + ((days = settings.durationMinutes / 1440) != 1 ? "s" : ""));
                String currencySymbol = GuiConfig.getInstance().getCurrencySymbol();
                player.sendMessage("\u00a7aAuction created! Starting price: " + currencySymbol + String.valueOf(settings.price) + ", Duration: " + durationStr);
                player.closeInventory();
                menu.clearSettings(player.getUniqueId());
            } else {
                player.sendMessage("\u00a7cFailed to create auction. Please try again.");
                ItemMeta lm = inHand.getItemMeta();
                if (lm != null) {
                    lm.getPersistentDataContainer().remove(tokenKey);
                    inHand.setItemMeta(lm);
                }
            }
        }
        catch (Exception ex) {
            player.sendMessage("\u00a7cAn error occurred while creating the auction.");
            GlobalMarketplacePlugin.getInstance().getLogger().warning("Failed to create auction: " + ex.getMessage());
            ex.printStackTrace();
        }
        menu.clearSettings(player.getUniqueId());
    }
}

