/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.globalMarketplace.commands;

import java.math.BigDecimal;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.texboobcat.globalMarketplace.GlobalMarketplacePlugin;
import org.texboobcat.globalMarketplace.integrations.BedrockMenuAdapter;
import org.texboobcat.globalMarketplace.model.Listing;
import org.texboobcat.globalMarketplace.model.TradeRequest;
import org.texboobcat.globalMarketplace.service.MarketplaceService;
import org.texboobcat.globalMarketplace.service.TradeService;
import org.texboobcat.globalMarketplace.util.ItemSerializer;

public class GMarketCommand
implements CommandExecutor,
TabCompleter {
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("This command can only be used by players.");
            return true;
        }
        Player player = (Player)sender;
        if (!sender.hasPermission("globalmarketplace.use")) {
            sender.sendMessage("You do not have permission.");
            return true;
        }
        if (args.length > 0 && args[0].equalsIgnoreCase("claim")) {
            int delivered;
            MarketplaceService svc = GlobalMarketplacePlugin.getInstance().getMarketplaceService();
            if (svc == null) {
                player.sendMessage("\u00a7cMarketplace unavailable.");
                return true;
            }
            int max = 36;
            if (args.length >= 2) {
                try {
                    max = Math.max(1, Integer.parseInt(args[1]));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if ((delivered = svc.claimDeliveries(player, max)) > 0) {
                player.sendMessage("\u00a7aClaimed " + delivered + " item(s).");
            } else {
                player.sendMessage("\u00a7eNo items to claim or inventory full.");
            }
            return true;
        }
        if (args.length > 0 && args[0].equalsIgnoreCase("help")) {
            this.showHelp(player, label);
            return true;
        }
        if (args.length > 0 && args[0].equalsIgnoreCase("cancel")) {
            UUID listingId;
            if (!player.hasPermission("globalmarketplace.cancel")) {
                player.sendMessage("\u00a7cNo permission.");
                return true;
            }
            if (args.length < 2) {
                player.sendMessage("\u00a7eUsage: /" + label + " cancel <listingUuid>");
                return true;
            }
            try {
                listingId = UUID.fromString(args[1]);
            }
            catch (Exception e) {
                player.sendMessage("\u00a7cInvalid listing UUID.");
                return true;
            }
            MarketplaceService svc = GlobalMarketplacePlugin.getInstance().getMarketplaceService();
            boolean ok = svc != null && svc.cancelListing(player.getUniqueId(), listingId);
            player.sendMessage(ok ? "\u00a7aListing cancelled. Item enqueued to your claims." : "\u00a7cCancel failed. Ensure listing is ACTIVE and owned by you.");
            return true;
        }
        if (args.length > 0 && args[0].equalsIgnoreCase("shop")) {
            boolean enabled = GlobalMarketplacePlugin.getInstance().getConfig().getBoolean("server-shop.enabled", false);
            if (!enabled) {
                player.sendMessage("\u00a7cServer shop is not enabled in config.");
                return true;
            }
            BedrockMenuAdapter.openServerShopMenu(player);
            return true;
        }
        if (args.length > 0 && args[0].equalsIgnoreCase("admin")) {
            if (args.length < 2) {
                player.sendMessage("\u00a7eUsage: /" + label + " admin <remove|reload|rollback|servershop> ...");
                return true;
            }
            String sub = args[1].toLowerCase();
            if (sub.equals("servershop")) {
                if (!player.hasPermission("globalmarketplace.admin.servershop")) {
                    player.sendMessage("\u00a7cNo permission.");
                    return true;
                }
                if (args.length < 3) {
                    player.sendMessage("\u00a7eUsage: /" + label + " admin servershop <add|remove|list|setprice>");
                    return true;
                }
                String action = args[2].toLowerCase();
                MarketplaceService svc = GlobalMarketplacePlugin.getInstance().getMarketplaceService();
                if (svc == null) {
                    player.sendMessage("\u00a7cMarketplace service unavailable.");
                    return true;
                }
                if (action.equals("add")) {
                    String serialized;
                    BigDecimal price;
                    if (args.length < 4) {
                        player.sendMessage("\u00a7eUsage: /" + label + " admin servershop add <price>");
                        player.sendMessage("\u00a77Hold the item you want to add in your main hand.");
                        return true;
                    }
                    try {
                        price = new BigDecimal(args[3]);
                        if (price.compareTo(BigDecimal.ZERO) <= 0) {
                            player.sendMessage("\u00a7cPrice must be greater than 0.");
                            return true;
                        }
                    }
                    catch (NumberFormatException e) {
                        player.sendMessage("\u00a7cInvalid price.");
                        return true;
                    }
                    ItemStack inHand = player.getInventory().getItemInMainHand();
                    if (inHand == null || inHand.getType() == Material.AIR) {
                        player.sendMessage("\u00a7cHold the item you want to add in your main hand.");
                        return true;
                    }
                    try {
                        serialized = ItemSerializer.toBase64(inHand);
                    }
                    catch (Exception ex) {
                        player.sendMessage("\u00a7cFailed to serialize item.");
                        return true;
                    }
                    Optional<UUID> created = svc.addServerListing(serialized, price);
                    if (created.isPresent()) {
                        player.sendMessage("\u00a7aServer listing added! ID: " + String.valueOf(created.get()));
                        player.sendMessage("\u00a77Item NOT removed from hand (infinite supply).");
                    } else {
                        player.sendMessage("\u00a7cFailed to add server listing.");
                    }
                    return true;
                }
                if (action.equals("remove")) {
                    if (args.length < 4) {
                        player.sendMessage("\u00a7eUsage: /" + label + " admin servershop remove <listingUuid>");
                        return true;
                    }
                    try {
                        UUID id = UUID.fromString(args[3]);
                        boolean ok = svc.removeServerListing(id);
                        player.sendMessage(ok ? "\u00a7aServer listing removed." : "\u00a7cListing not found.");
                    }
                    catch (IllegalArgumentException ex) {
                        player.sendMessage("\u00a7cInvalid UUID.");
                    }
                    return true;
                }
                if (action.equals("list")) {
                    List<Listing> listings = svc.getServerListings();
                    if (listings.isEmpty()) {
                        player.sendMessage("\u00a7eNo server listings configured.");
                    } else {
                        player.sendMessage("\u00a76=== Server Listings ===");
                        for (Listing l : listings) {
                            try {
                                ItemStack item = ItemSerializer.fromBase64(l.getItemSerialized());
                                String name = item != null && item.hasItemMeta() && item.getItemMeta().hasDisplayName() ? item.getItemMeta().getDisplayName() : (item != null ? item.getType().name() : "Unknown");
                                player.sendMessage("\u00a77- \u00a7f" + name + " \u00a77(\u00a7a$" + String.valueOf(l.getPrice()) + "\u00a77) \u00a78[" + String.valueOf(l.getUuid()) + "]");
                            }
                            catch (Exception ignored) {
                                player.sendMessage("\u00a77- \u00a7cMalformed listing \u00a78[" + String.valueOf(l.getUuid()) + "]");
                            }
                        }
                    }
                    return true;
                }
                if (action.equals("setprice")) {
                    if (args.length < 5) {
                        player.sendMessage("\u00a7eUsage: /" + label + " admin servershop setprice <listingUuid> <newPrice>");
                        return true;
                    }
                    try {
                        UUID id = UUID.fromString(args[3]);
                        BigDecimal newPrice = new BigDecimal(args[4]);
                        if (newPrice.compareTo(BigDecimal.ZERO) <= 0) {
                            player.sendMessage("\u00a7cPrice must be greater than 0.");
                            return true;
                        }
                        boolean ok = svc.updateServerListingPrice(id, newPrice);
                        player.sendMessage((String)(ok ? "\u00a7aPrice updated to $" + String.valueOf(newPrice) : "\u00a7cListing not found."));
                    }
                    catch (IllegalArgumentException ex) {
                        player.sendMessage("\u00a7cInvalid UUID or price.");
                    }
                    return true;
                }
                player.sendMessage("\u00a7eUsage: /" + label + " admin servershop <add|remove|list|setprice>");
                return true;
            }
            if (sub.equals("remove")) {
                if (!player.hasPermission("globalmarketplace.admin.remove")) {
                    player.sendMessage("\u00a7cNo permission.");
                    return true;
                }
                if (args.length < 3) {
                    player.sendMessage("\u00a7eUsage: /" + label + " admin remove <listingUuid>");
                    return true;
                }
                try {
                    UUID id = UUID.fromString(args[2]);
                    MarketplaceService svc = GlobalMarketplacePlugin.getInstance().getMarketplaceService();
                    boolean ok = svc != null && svc.adminRemoveListing(id);
                    player.sendMessage(ok ? "\u00a7aListing removed." : "\u00a7cFailed to remove listing (not found?).");
                }
                catch (IllegalArgumentException ex) {
                    player.sendMessage("\u00a7cInvalid UUID.");
                }
                return true;
            }
            if (sub.equals("reload")) {
                if (!player.hasPermission("globalmarketplace.admin.reload")) {
                    player.sendMessage("\u00a7cNo permission.");
                    return true;
                }
                GlobalMarketplacePlugin.getInstance().reloadConfig();
                MarketplaceService svc = GlobalMarketplacePlugin.getInstance().getMarketplaceService();
                if (svc != null) {
                    svc.loadServerListings(GlobalMarketplacePlugin.getInstance().getConfig());
                }
                player.sendMessage("\u00a7aGlobalMarketplace configuration reloaded.");
                return true;
            }
            if (sub.equals("rollback")) {
                if (!player.hasPermission("globalmarketplace.admin.rollback")) {
                    player.sendMessage("\u00a7cNo permission.");
                    return true;
                }
                if (args.length < 3) {
                    player.sendMessage("\u00a7eUsage: /" + label + " admin rollback <listingUuid>");
                    return true;
                }
                try {
                    UUID id = UUID.fromString(args[2]);
                    MarketplaceService svc = GlobalMarketplacePlugin.getInstance().getMarketplaceService();
                    boolean ok = svc != null && svc.adminRollbackListing(id);
                    player.sendMessage(ok ? "\u00a7aRollback successful: listing set ACTIVE, buyer refunded." : "\u00a7cRollback failed. Ensure listing is SOLD and balances allow revert.");
                }
                catch (IllegalArgumentException ex) {
                    player.sendMessage("\u00a7cInvalid UUID.");
                }
                return true;
            }
            player.sendMessage("\u00a7eUsage: /" + label + " admin <remove|reload|rollback> ...");
            return true;
        }
        if (args.length > 0 && args[0].equalsIgnoreCase("payout")) {
            Optional<BigDecimal> pendingOpt;
            MarketplaceService svc = GlobalMarketplacePlugin.getInstance().getMarketplaceService();
            if (svc == null) {
                player.sendMessage("\u00a7cMarketplace unavailable.");
                return true;
            }
            BigDecimal amount = null;
            if (args.length == 0) {
                BedrockMenuAdapter.openMainMenu(player);
                return true;
            }
            if (args.length >= 2 && !args[1].equalsIgnoreCase("all")) {
                try {
                    amount = new BigDecimal(args[1]);
                    if (amount.compareTo(BigDecimal.ZERO) <= 0) {
                        throw new NumberFormatException();
                    }
                }
                catch (NumberFormatException e) {
                    player.sendMessage("\u00a7cInvalid amount. Use a number or 'all'.");
                    return true;
                }
            }
            if ((pendingOpt = svc.getPendingBalance(player.getUniqueId())).isEmpty()) {
                player.sendMessage("\u00a7cCould not fetch your balance.");
                return true;
            }
            BigDecimal pending = pendingOpt.get();
            if (pending.compareTo(BigDecimal.ZERO) <= 0) {
                player.sendMessage("\u00a7eYou have no pending balance to withdraw.");
                return true;
            }
            boolean ok = svc.payout(player.getUniqueId(), amount);
            if (ok) {
                BigDecimal after = svc.getPendingBalance(player.getUniqueId()).orElse(BigDecimal.ZERO);
                player.sendMessage("\u00a7aPayout successful. Remaining pending: $" + String.valueOf(after));
            } else {
                player.sendMessage("\u00a7cPayout failed. Try again later.");
            }
            return true;
        }
        if (args.length > 0 && args[0].equalsIgnoreCase("sell")) {
            String serialized;
            BigDecimal price;
            if (args.length < 2) {
                player.sendMessage("\u00a7eUnknown command. Use /" + label + " help for usage.");
                return true;
            }
            try {
                price = new BigDecimal(args[1]);
                if (price.compareTo(BigDecimal.ZERO) <= 0) {
                    player.sendMessage("\u00a7cPrice must be greater than 0.");
                    return true;
                }
            }
            catch (NumberFormatException e) {
                player.sendMessage("\u00a7cInvalid price. Use a number like 100 or 99.99");
                return true;
            }
            ItemStack inHand = player.getInventory().getItemInMainHand();
            if (inHand == null || inHand.getType() == Material.AIR) {
                player.sendMessage("\u00a7cHold the item you want to sell in your main hand.");
                return true;
            }
            try {
                serialized = ItemSerializer.toBase64(inHand);
            }
            catch (Exception ex) {
                player.sendMessage("\u00a7cFailed to serialize item. Try again.");
                return true;
            }
            MarketplaceService svc = GlobalMarketplacePlugin.getInstance().getMarketplaceService();
            if (svc == null) {
                player.sendMessage("\u00a7cMarketplace service unavailable.");
                return true;
            }
            Optional<UUID> created = svc.createFixedListing(player.getUniqueId(), serialized, price);
            if (created.isPresent()) {
                player.getInventory().setItemInMainHand(new ItemStack(Material.AIR));
                player.sendMessage("\u00a7aListing created! ID: " + String.valueOf(created.get()));
            } else {
                player.sendMessage("\u00a7cCould not create listing. Please try again later.");
            }
            return true;
        }
        if (args.length > 0 && args[0].equalsIgnoreCase("auction")) {
            String serialized;
            int minutes;
            BigDecimal start;
            if (args.length < 3) {
                player.sendMessage("\u00a7eUsage: /" + label + " auction <startPrice> <minutes>");
                return true;
            }
            try {
                start = new BigDecimal(args[1]);
                minutes = Integer.parseInt(args[2]);
                if (start.compareTo(BigDecimal.ZERO) <= 0 || minutes <= 0) {
                    throw new NumberFormatException();
                }
            }
            catch (NumberFormatException e) {
                player.sendMessage("\u00a7cInvalid arguments. Example: /" + label + " auction 100 60");
                return true;
            }
            ItemStack inHand = player.getInventory().getItemInMainHand();
            if (inHand == null || inHand.getType() == Material.AIR) {
                player.sendMessage("\u00a7cHold the item you want to auction in your main hand.");
                return true;
            }
            try {
                serialized = ItemSerializer.toBase64(inHand);
            }
            catch (Exception ex) {
                player.sendMessage("\u00a7cFailed to serialize item.");
                return true;
            }
            MarketplaceService svc = GlobalMarketplacePlugin.getInstance().getMarketplaceService();
            Optional<UUID> created = svc.createAuctionListing(player.getUniqueId(), serialized, start, Instant.now().plus(Duration.ofMinutes(minutes)));
            if (created.isPresent()) {
                player.getInventory().setItemInMainHand(new ItemStack(Material.AIR));
                player.sendMessage("\u00a7aAuction created! ID: " + String.valueOf(created.get()));
            } else {
                player.sendMessage("\u00a7cCould not create auction.");
            }
            return true;
        }
        if (args.length > 0 && args[0].equalsIgnoreCase("bid")) {
            BigDecimal amount;
            UUID listingId;
            if (args.length < 3) {
                player.sendMessage("\u00a7eUsage: /" + label + " bid <listingUuid> <amount>");
                return true;
            }
            try {
                listingId = UUID.fromString(args[1]);
                amount = new BigDecimal(args[2]);
                if (amount.compareTo(BigDecimal.ZERO) <= 0) {
                    throw new NumberFormatException();
                }
            }
            catch (Exception e) {
                player.sendMessage("\u00a7cInvalid arguments.");
                return true;
            }
            MarketplaceService svc = GlobalMarketplacePlugin.getInstance().getMarketplaceService();
            boolean ok = svc.placeBid(listingId, player.getUniqueId(), amount);
            player.sendMessage(ok ? "\u00a7aBid placed." : "\u00a7cBid rejected.");
            return true;
        }
        if (args.length > 0 && args[0].equalsIgnoreCase("trade")) {
            if (args.length < 3) {
                player.sendMessage("\u00a7eUsage: /" + label + " trade <request|accept|decline> <playerName>");
                return true;
            }
            String action = args[1].toLowerCase();
            String targetName = args[2];
            TradeService tradeService = GlobalMarketplacePlugin.getInstance().getTradeService();
            if (action.equals("request")) {
                Player targetPlayer = Bukkit.getPlayer((String)targetName);
                if (targetPlayer == null) {
                    player.sendMessage("\u00a7cPlayer not found or not online.");
                    return true;
                }
                if (targetPlayer.getUniqueId().equals(player.getUniqueId())) {
                    player.sendMessage("\u00a7cYou cannot trade with yourself.");
                    return true;
                }
                TradeRequest request = tradeService.createTradeRequest(player.getUniqueId(), targetPlayer.getUniqueId());
                if (request == null) {
                    player.sendMessage("\u00a7cCould not create trade request. One of you may already be in a trade.");
                } else {
                    player.sendMessage("\u00a7aTrade request sent to " + targetPlayer.getName() + "!");
                }
                return true;
            }
            if (action.equals("accept")) {
                Player initiatorPlayer = Bukkit.getPlayer((String)targetName);
                if (initiatorPlayer == null) {
                    player.sendMessage("\u00a7cPlayer not found or not online.");
                    return true;
                }
                if (tradeService.acceptTradeRequest(player.getUniqueId(), initiatorPlayer.getUniqueId())) {
                    player.sendMessage("\u00a7aTrade request accepted! Opening trade window...");
                } else {
                    player.sendMessage("\u00a7cNo valid trade request found from " + targetName + ".");
                }
                return true;
            }
            if (action.equals("decline")) {
                Player initiatorPlayer = Bukkit.getPlayer((String)targetName);
                if (initiatorPlayer == null) {
                    player.sendMessage("\u00a7cPlayer not found or not online.");
                    return true;
                }
                if (tradeService.declineTradeRequest(player.getUniqueId(), initiatorPlayer.getUniqueId())) {
                    player.sendMessage("\u00a77Trade request declined.");
                } else {
                    player.sendMessage("\u00a7cNo valid trade request found from " + targetName + ".");
                }
                return true;
            }
            player.sendMessage("\u00a7eUsage: /" + label + " trade <request|accept|decline> <playerName>");
            return true;
        }
        if (args.length > 0 && args[0].equalsIgnoreCase("directbuy")) {
            UUID listingId;
            if (args.length < 2) {
                player.sendMessage("\u00a7eUsage: /" + label + " directbuy <listingUuid>");
                return true;
            }
            try {
                listingId = UUID.fromString(args[1]);
            }
            catch (Exception e) {
                player.sendMessage("\u00a7cInvalid listing UUID.");
                return true;
            }
            MarketplaceService svc = GlobalMarketplacePlugin.getInstance().getMarketplaceService();
            boolean ok = svc.purchaseDirect(player.getUniqueId(), listingId);
            if (ok) {
                int delivered = svc.claimDeliveries(player, 36);
                if (delivered > 0) {
                    player.sendMessage("\u00a7aDirect purchase successful. Item delivered to your inventory.");
                } else {
                    player.sendMessage("\u00a7eDirect purchase successful, but your inventory was full. Use /gmarket claim to receive.");
                }
            } else {
                player.sendMessage("\u00a7cDirect purchase failed.");
            }
            return true;
        }
        BedrockMenuAdapter.openMainMenu(player);
        GlobalMarketplacePlugin.getInstance().getLogger().info("/gmarket opened MainMenu for " + sender.getName());
        return true;
    }

    private void showHelp(Player player, String label) {
        player.sendMessage("\u00a76=== Global Marketplace Help ===");
        player.sendMessage("\u00a7e/" + label + " \u00a77- Open marketplace GUI");
        player.sendMessage("\u00a7e/" + label + " help \u00a77- Show this help");
        player.sendMessage("\u00a7e/" + label + " claim [amount] \u00a77- Claim delivered items");
        player.sendMessage("\u00a7e/" + label + " payout [amount|all] \u00a77- Withdraw earnings");
        player.sendMessage("\u00a7e/" + label + " cancel <listingId> \u00a77- Cancel your listing");
        player.sendMessage("\u00a7e/" + label + " directbuy <listingId> \u00a77- Buy direct listing");
        player.sendMessage("\u00a7e/" + label + " trade request <player> \u00a77- Send trade request");
        player.sendMessage("\u00a7e/" + label + " trade accept \u00a77- Accept trade request");
        player.sendMessage("\u00a7e/" + label + " trade decline \u00a77- Decline trade request");
        boolean serverShopEnabled = GlobalMarketplacePlugin.getInstance().getConfig().getBoolean("server-shop.enabled", false);
        if (serverShopEnabled) {
            player.sendMessage("\u00a7e/" + label + " shop \u00a77- Open server shop");
        }
        if (player.hasPermission("globalmarketplace.admin")) {
            player.sendMessage("\u00a7c/" + label + " admin remove <listingId> \u00a77- Remove listing");
            player.sendMessage("\u00a7c/" + label + " admin reload \u00a77- Reload plugin");
            player.sendMessage("\u00a7c/" + label + " admin rollback <listingId> \u00a77- Rollback a sold listing");
        }
        if (player.hasPermission("globalmarketplace.admin.servershop")) {
            player.sendMessage("\u00a76/" + label + " admin servershop add <price> \u00a77- Add server listing");
            player.sendMessage("\u00a76/" + label + " admin servershop remove <id> \u00a77- Remove server listing");
            player.sendMessage("\u00a76/" + label + " admin servershop list \u00a77- List all server listings");
            player.sendMessage("\u00a76/" + label + " admin servershop setprice <id> <price> \u00a77- Update price");
        }
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> out = new ArrayList<String>();
        if (!(sender instanceof Player)) {
            return out;
        }
        Player player = (Player)sender;
        if (args.length == 1) {
            String p = args[0].toLowerCase();
            ArrayList<String> base = new ArrayList<String>();
            base.add("help");
            base.add("claim");
            base.add("payout");
            base.add("sell");
            base.add("auction");
            base.add("bid");
            base.add("trade");
            base.add("directbuy");
            base.add("cancel");
            base.add("admin");
            boolean serverShopEnabled = GlobalMarketplacePlugin.getInstance().getConfig().getBoolean("server-shop.enabled", false);
            if (serverShopEnabled) {
                base.add("shop");
            }
            for (String s : base) {
                if (!s.startsWith(p)) continue;
                out.add(s);
            }
            return out;
        }
        if (args.length >= 1 && args[0].equalsIgnoreCase("admin")) {
            if (!player.hasPermission("globalmarketplace.admin") && !player.hasPermission("globalmarketplace.admin.servershop")) {
                return out;
            }
            if (args.length == 2) {
                String p = args[1].toLowerCase();
                ArrayList<String> subs = new ArrayList<String>();
                if (player.hasPermission("globalmarketplace.admin")) {
                    subs.add("remove");
                    subs.add("reload");
                    subs.add("rollback");
                }
                if (player.hasPermission("globalmarketplace.admin.servershop")) {
                    subs.add("servershop");
                }
                for (String s : subs) {
                    if (!s.startsWith(p)) continue;
                    out.add(s);
                }
                return out;
            }
            if (args.length == 3) {
                String sub = args[1].toLowerCase();
                if (sub.equals("servershop") && player.hasPermission("globalmarketplace.admin.servershop")) {
                    String[] actions;
                    String p = args[2].toLowerCase();
                    for (String s : actions = new String[]{"add", "remove", "list", "setprice"}) {
                        if (!s.startsWith(p)) continue;
                        out.add(s);
                    }
                    return out;
                }
                if (sub.equals("remove") || sub.equals("rollback")) {
                    String p = args[2];
                    if (p.isEmpty()) {
                        out.add("<listingUuid>");
                    }
                    if (p.matches("[0-9a-fA-F-]{1,36}")) {
                        out.add(p);
                    }
                    return out;
                }
            }
        }
        return out;
    }
}

