/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.globalMarketplace.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.texboobcat.globalMarketplace.GlobalMarketplacePlugin;
import org.texboobcat.globalMarketplace.model.TradeRequest;
import org.texboobcat.globalMarketplace.service.TradeService;

public class TradeCommand
implements CommandExecutor,
TabCompleter {
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String action;
        if (!(sender instanceof Player)) {
            sender.sendMessage("\u00a7cThis command can only be used by players.");
            return true;
        }
        Player player = (Player)sender;
        TradeService tradeService = GlobalMarketplacePlugin.getInstance().getTradeService();
        if (tradeService == null) {
            player.sendMessage("\u00a7cTrade service is not available.");
            return true;
        }
        if (args.length == 0) {
            this.showHelp(player, label);
            return true;
        }
        switch (action = args[0].toLowerCase()) {
            case "request": {
                if (args.length < 2) {
                    player.sendMessage("\u00a7eUsage: /" + label + " request <player>");
                    return true;
                }
                Player target = Bukkit.getPlayer((String)args[1]);
                if (target == null) {
                    player.sendMessage("\u00a7cPlayer not found or not online.");
                    return true;
                }
                if (target.equals((Object)player)) {
                    player.sendMessage("\u00a7cYou cannot trade with yourself.");
                    return true;
                }
                TradeRequest request = tradeService.createTradeRequest(player.getUniqueId(), target.getUniqueId());
                if (request != null) {
                    player.sendMessage("\u00a7aTrade request sent to " + target.getName());
                    target.sendMessage("\u00a7e" + player.getName() + " sent you a trade request. Use /trade accept or /trade decline");
                } else {
                    player.sendMessage("\u00a7cCould not send trade request. You may already have a pending request or be in a trade.");
                }
                return true;
            }
            case "accept": {
                if (args.length >= 2) {
                    Player initiatorPlayer = Bukkit.getPlayer((String)args[1]);
                    if (initiatorPlayer == null) {
                        player.sendMessage("\u00a7cPlayer not found or not online.");
                        return true;
                    }
                    boolean accepted = tradeService.acceptTradeRequest(player.getUniqueId(), initiatorPlayer.getUniqueId());
                    if (!accepted) {
                        player.sendMessage("\u00a7cNo valid trade request found from " + initiatorPlayer.getName() + ".");
                    }
                } else {
                    TradeRequest pendingRequest = tradeService.getPendingRequestForTarget(player.getUniqueId());
                    if (pendingRequest != null) {
                        boolean accepted = tradeService.acceptTradeRequest(player.getUniqueId(), pendingRequest.getInitiator());
                        if (!accepted) {
                            player.sendMessage("\u00a7cFailed to accept trade request.");
                        }
                    } else {
                        player.sendMessage("\u00a7cNo pending trade request to accept.");
                    }
                }
                return true;
            }
            case "decline": {
                if (args.length >= 2) {
                    Player initiatorPlayer = Bukkit.getPlayer((String)args[1]);
                    if (initiatorPlayer == null) {
                        player.sendMessage("\u00a7cPlayer not found or not online.");
                        return true;
                    }
                    boolean declined = tradeService.declineTradeRequest(player.getUniqueId(), initiatorPlayer.getUniqueId());
                    if (!declined) {
                        player.sendMessage("\u00a7cNo valid trade request found from " + initiatorPlayer.getName() + ".");
                    }
                } else {
                    TradeRequest pendingDeclineRequest = tradeService.getPendingRequestForTarget(player.getUniqueId());
                    if (pendingDeclineRequest != null) {
                        boolean declined = tradeService.declineTradeRequest(player.getUniqueId(), pendingDeclineRequest.getInitiator());
                        if (!declined) {
                            player.sendMessage("\u00a7cFailed to decline trade request.");
                        }
                    } else {
                        player.sendMessage("\u00a7cNo pending trade request to decline.");
                    }
                }
                return true;
            }
            case "help": {
                this.showHelp(player, label);
                return true;
            }
        }
        player.sendMessage("\u00a7cUnknown action. Use /" + label + " help for usage.");
        return true;
    }

    private void showHelp(Player player, String label) {
        player.sendMessage("\u00a76=== Trade Commands ===");
        player.sendMessage("\u00a7e/" + label + " request <player> \u00a77- Send trade request");
        player.sendMessage("\u00a7e/" + label + " accept [player] \u00a77- Accept trade request");
        player.sendMessage("\u00a7e/" + label + " decline [player] \u00a77- Decline trade request");
        player.sendMessage("\u00a7e/" + label + " help \u00a77- Show this help");
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (!(sender instanceof Player)) {
            return new ArrayList<String>();
        }
        Player player = (Player)sender;
        TradeService tradeService = GlobalMarketplacePlugin.getInstance().getTradeService();
        if (tradeService == null) {
            return new ArrayList<String>();
        }
        if (args.length == 1) {
            List<String> actions = Arrays.asList("request", "accept", "decline", "help");
            return actions.stream().filter(action -> action.toLowerCase().startsWith(args[0].toLowerCase())).collect(Collectors.toList());
        }
        if (args.length == 2) {
            String action2 = args[0].toLowerCase();
            if (action2.equals("request")) {
                return Bukkit.getOnlinePlayers().stream().filter(p -> !p.equals((Object)player)).map(Player::getName).filter(name -> name.toLowerCase().startsWith(args[1].toLowerCase())).collect(Collectors.toList());
            }
            if (action2.equals("accept") || action2.equals("decline")) {
                Player initiator;
                ArrayList<String> requesters = new ArrayList<String>();
                TradeRequest pendingRequest = tradeService.getPendingRequestForTarget(player.getUniqueId());
                if (pendingRequest != null && (initiator = Bukkit.getPlayer((UUID)pendingRequest.getInitiator())) != null) {
                    requesters.add(initiator.getName());
                }
                return requesters.stream().filter(name -> name.toLowerCase().startsWith(args[1].toLowerCase())).collect(Collectors.toList());
            }
        }
        return new ArrayList<String>();
    }
}

