/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.globalMarketplace.integrations;

import java.util.UUID;
import org.texboobcat.globalMarketplace.GlobalMarketplacePlugin;

public final class GeyserIntegration {
    private static volatile boolean checked = false;
    private static volatile boolean present = false;

    private GeyserIntegration() {
    }

    public static boolean isEnabled() {
        if (!GlobalMarketplacePlugin.getInstance().getConfig().getBoolean("geyser.enabled", true)) {
            return false;
        }
        return GeyserIntegration.isPresent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isPresent() {
        if (checked) return present;
        Class<GeyserIntegration> clazz = GeyserIntegration.class;
        synchronized (GeyserIntegration.class) {
            if (checked) return present;
            try {
                Class.forName("org.geysermc.geyser.api.GeyserApi", false, GeyserIntegration.class.getClassLoader());
                present = true;
            }
            catch (Throwable ignored) {
                present = false;
            }
            checked = true;
            if (present) {
                GlobalMarketplacePlugin.getInstance().getLogger().info("Geyser API detected. Bedrock support is available.");
            } else {
                GlobalMarketplacePlugin.getInstance().getLogger().fine("Geyser API not detected. Running in Java-only mode.");
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return present;
        }
    }

    public static boolean isBedrockPlayer(UUID uuid) {
        Object result;
        if (!GeyserIntegration.isEnabled() || uuid == null) {
            return false;
        }
        try {
            Class<?> floodApiClazz = Class.forName("org.geysermc.floodgate.api.FloodgateApi");
            Object fapi = floodApiClazz.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
            result = floodApiClazz.getMethod("isFloodgatePlayer", UUID.class).invoke(fapi, uuid);
            if (result instanceof Boolean && ((Boolean)result).booleanValue()) {
                return true;
            }
        }
        catch (ClassNotFoundException floodApiClazz) {
        }
        catch (Throwable floodApiClazz) {
            // empty catch block
        }
        try {
            Class<?> apiClazz = Class.forName("org.geysermc.geyser.api.GeyserApi");
            Object api = apiClazz.getMethod("api", new Class[0]).invoke(null, new Object[0]);
            try {
                result = apiClazz.getMethod("isBedrockPlayer", UUID.class).invoke(api, uuid);
                return result instanceof Boolean && (Boolean)result != false;
            }
            catch (NoSuchMethodException ignored) {
                Object opt = apiClazz.getMethod("connectionByUuid", UUID.class).invoke(api, uuid);
                if (opt != null) {
                    return (Boolean)opt.getClass().getMethod("isPresent", new Class[0]).invoke(opt, new Object[0]);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public static boolean sendForm(UUID uuid, Object formBuilder) {
        if (!GeyserIntegration.isEnabled() || uuid == null || formBuilder == null) {
            return false;
        }
        try {
            Object formObj;
            try {
                formObj = formBuilder.getClass().getMethod("build", new Class[0]).invoke(formBuilder, new Object[0]);
            }
            catch (NoSuchMethodException e) {
                formObj = formBuilder;
            }
            Class<?> formIface = Class.forName("org.geysermc.cumulus.form.Form");
            try {
                Class<?> floodApiClazz = Class.forName("org.geysermc.floodgate.api.FloodgateApi");
                Object fapi = floodApiClazz.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
                try {
                    floodApiClazz.getMethod("sendForm", UUID.class, formIface).invoke(fapi, uuid, formObj);
                    GlobalMarketplacePlugin.getInstance().getLogger().fine("Sent form via FloodgateApi.sendForm");
                    return true;
                }
                catch (NoSuchMethodException e1) {
                    Object fplayer = floodApiClazz.getMethod("getPlayer", UUID.class).invoke(fapi, uuid);
                    if (fplayer != null) {
                        fplayer.getClass().getMethod("sendForm", formIface).invoke(fplayer, formObj);
                        GlobalMarketplacePlugin.getInstance().getLogger().fine("Sent form via FloodgatePlayer.sendForm");
                        return true;
                    }
                }
            }
            catch (ClassNotFoundException floodApiClazz) {
                // empty catch block
            }
            try {
                Class<?> apiClazz = Class.forName("org.geysermc.geyser.api.GeyserApi");
                Object api = apiClazz.getMethod("api", new Class[0]).invoke(null, new Object[0]);
                apiClazz.getMethod("sendForm", UUID.class, formIface).invoke(api, uuid, formObj);
                GlobalMarketplacePlugin.getInstance().getLogger().fine("Sent form via GeyserApi.sendForm");
                return true;
            }
            catch (Throwable t2) {
                GlobalMarketplacePlugin.getInstance().getLogger().fine("GeyserApi sendForm failed: " + t2.getMessage());
                return false;
            }
        }
        catch (Throwable t) {
            GlobalMarketplacePlugin.getInstance().getLogger().fine("Failed to send Geyser form: " + t.getMessage());
            return false;
        }
    }
}

