/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.globalMarketplace.listeners;

import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.texboobcat.globalMarketplace.GlobalMarketplacePlugin;
import org.texboobcat.globalMarketplace.service.ItemValueService;

public class ItemValueListener
implements Listener {
    private final ItemValueService valueService;
    private final NamespacedKey valueTagKey;
    private final boolean autoUpdateOnInventoryOpen;

    public ItemValueListener(ItemValueService valueService, boolean autoUpdateOnInventoryOpen) {
        this.valueService = valueService;
        this.valueTagKey = new NamespacedKey((Plugin)GlobalMarketplacePlugin.getInstance(), "value_tagged");
        this.autoUpdateOnInventoryOpen = autoUpdateOnInventoryOpen;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEntityPickupItem(EntityPickupItemEvent event) {
        if (!this.valueService.isEnabled()) {
            return;
        }
        ItemStack item = event.getItem().getItemStack();
        if (item == null || item.getType() == Material.AIR) {
            return;
        }
        if (!this.isValueTagged(item) && this.valueService.addValueLore(item)) {
            this.markAsValueTagged(item);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onInventoryOpen(InventoryOpenEvent event) {
        if (!this.valueService.isEnabled() || !this.autoUpdateOnInventoryOpen) {
            return;
        }
        if (!(event.getPlayer() instanceof Player)) {
            return;
        }
        if (event.getInventory().getType() != InventoryType.PLAYER) {
            return;
        }
        Player player = (Player)event.getPlayer();
        this.valueService.updateAllItemsInInventory((Inventory)player.getInventory());
    }

    private boolean isValueTagged(ItemStack item) {
        if (item == null || item.getType() == Material.AIR) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return false;
        }
        return meta.getPersistentDataContainer().has(this.valueTagKey, PersistentDataType.BYTE);
    }

    private void markAsValueTagged(ItemStack item) {
        if (item == null || item.getType() == Material.AIR) {
            return;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return;
        }
        meta.getPersistentDataContainer().set(this.valueTagKey, PersistentDataType.BYTE, (Object)1);
        item.setItemMeta(meta);
    }
}

